/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.data.properties.traiano;

import com.ibm.cst.ui.embedded.api.viewer.MapViewerPlugin;
import com.ibm.mia.classic.map.ClassicMapPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.uif.fsl.common.action.ActionsManager;
import com.ibm.uif.fsl.common.client.payload.CommonPayload;
import com.ibm.uif.fsl.common.client.plugin.FSLCommonPlugin;
import com.ibm.uif.fsl.data.properties.Path;
import com.ibm.uif.fsl.data.properties.PropertiesDataRequest;
import java.util.Vector;

public final class TraianoPropertiesDataRequest
extends PropertiesDataRequest {
    private String initLetter = "";
    private int changeFloor = 0;
    private boolean correctWord;
    private static TraianoPropertiesDataRequest traianodataRequest;

    public TraianoPropertiesDataRequest() {
        traianodataRequest = this;
    }

    public static TraianoPropertiesDataRequest getTraianoDataRequest() {
        return traianodataRequest;
    }

    public final void sendRequest(String request) {
        String cat;
        System.out.println("Requete : " + request);
        super.sendRequest(request);
        if (request.startsWith("BT=")) {
            int id = Integer.parseInt(request.substring(4));
            if (id != 0) {
                this.updateLetter(id);
            }
            this.updateFloor(String.valueOf(this.getCurrentId()) + ".floor");
            this.sendInformation();
            if (this.isLastPOI() == 0) {
                if (this.initLetter.equals(FSLCommonPlugin.getNLSString("response"))) {
                    this.setCorrectWord(true);
                } else {
                    this.setCorrectWord(false);
                }
                ActionsManager.getActionsManager().languageChanged();
            } else if (this.isLastPOI() < 0) {
                ActionsManager.getActionsManager().languageChanged();
            }
        } else if (request.startsWith("Goto=")) {
            MapViewerPlugin pl = (MapViewerPlugin)PluginManager.getManager().getPlugin("Map Viewer");
            pl.$mapViewer.scroolToItinerary();
        } else if (request.startsWith("disclaimer")) {
            this.sendDisclaimer();
        } else if (request.startsWith("catalog") && (cat = request.substring(7)).equals("POI")) {
            this.sendPreferencesPOI();
        }
    }

    private final int getLastId(String currentId) {
        return Integer.parseInt(FSLCommonPlugin.getNLSString(String.valueOf(currentId.substring(0, 1)) + ".size"));
    }

    private final void setCorrectWord(boolean bool) {
        this.correctWord = bool;
    }

    public final boolean isCorrectWord() {
        return this.correctWord;
    }

    public final int isLastPOI() {
        if (this.getCurrentId() != null) {
            TraianoPropertiesDataRequest traianoPropertiesDataRequest = this;
            return traianoPropertiesDataRequest.getLastId(traianoPropertiesDataRequest.getCurrentId()) - Integer.parseInt(this.getCurrentId().substring(1));
        }
        return this.getLastId("A0");
    }

    public final void login() {
        this.sendRequest("login");
    }

    private final String getNextId(String precId) {
        if (!precId.equals("A0")) {
            int nextId = Integer.parseInt(precId.substring(1)) + 1;
            if (nextId > this.getLastId(precId)) {
                return null;
            }
            return String.valueOf(precId.substring(0, 1)) + String.valueOf(nextId);
        }
        return null;
    }

    private final void updateFloor(String floorSt) {
        if (floorSt != null && floorSt.length() > 0) {
            int floor = Integer.parseInt(FSLCommonPlugin.getNLSString(floorSt));
            ((ClassicMapPlugin)PluginManager.getManager().getPlugin("Map Viewer")).setFloor(floor);
        }
    }

    protected final String getMapTitle() {
        if (!this.isInGuidanceMode) {
            String title = FSLCommonPlugin.getNLSString(String.valueOf(Path.getPath().getCurrentId()) + ".floor").equals("1") ? FSLCommonPlugin.getNLSString("First_Floor") : FSLCommonPlugin.getNLSString("Second_Floor");
            return String.valueOf(title) + " " + this.getInformationTitle();
        }
        return super.getMapTitle();
    }

    private final void sendDisclaimer() {
        System.out.println(FSLCommonPlugin.getNLSString("Disclaimer_Description"));
        CommonPayload pl = new CommonPayload(3, FSLCommonPlugin.getNLSString("Disclaimer_Title"), FSLCommonPlugin.getNLSString("Disclaimer_Description"), null, null, null, null);
        Source src = new Source("");
        Message msg = new Message(src, pl.toString().getBytes());
        this.sendMessage("3", msg);
    }

    protected final void sendPreferences() {
        Source src = new Source("");
        CommonPayload pl = new CommonPayload(0, this.getHelloMessage(), this.getWelcomeMessage(), this.getPreferencesActions(), null, this.getWelcomeImage(), null);
        Message msg = new Message(src, pl.toString().getBytes());
        this.sendMessage("0", msg);
    }

    protected final void sendPreferencesPOI() {
        Source src = new Source("");
        CommonPayload pl = new CommonPayload(0, this.getHelloMessage(), this.getWelcomeMessage(), this.getPreferencesPOIActions(), null, this.getWelcomeImage(), null);
        Message msg = new Message(src, pl.toString().getBytes());
        this.sendMessage("0", msg);
    }

    private final Action[] getPreferencesPOIActions() {
        Vector ids = Path.getPath().getIds();
        TraianoPropertiesDataRequest traianoPropertiesDataRequest = this;
        int length = traianoPropertiesDataRequest.getLastId(traianoPropertiesDataRequest.getCurrentId());
        Action[] actions = new Action[length];
        int addedIndex = 0;
        int i2 = 0;
        while (i2 < ids.size()) {
            Action ac2;
            String id = (String)ids.elementAt(i2);
            actions[addedIndex] = ac2 = new Action(this.getArrivedToTitle(id), "topic", "BT=" + id, "autre", false);
            ++addedIndex;
            ++i2;
        }
        return actions;
    }

    private final Action[] getPreferencesActions() {
        Action ac2;
        Action[] actions = new Action[1];
        int addedIndex = 0;
        actions[addedIndex] = ac2 = new Action(FSLCommonPlugin.getNLSString("Lost"), "topic", "catalogPOI", "autre", false);
        return actions;
    }

    private final String updateLetter(int id) {
        String key = String.valueOf(this.getCurrentId()) + ".letter";
        this.initLetter = String.valueOf(this.initLetter) + FSLCommonPlugin.getNLSString(key);
        return this.initLetter;
    }

    protected final String getInformationDescription() {
        String currentId = this.getCurrentId();
        String result = super.getInformationDescription();
        return result;
    }

    protected final Action[] getMapActions() {
        String currentId = this.getCurrentId();
        Vector ids = Path.getPath().getIds();
        System.out.println("getMapActions : " + this.changeFloor);
        String nextId = this.getNextId(currentId);
        int length = 0;
        if (nextId != null) {
            ++length;
        }
        Action[] actions = new Action[length];
        int addedIndex = 0;
        if (nextId != null) {
            Action ac2;
            actions[addedIndex] = ac2 = new Action(this.getGuidanceTitle(nextId), "topic", "Goto=" + nextId, "autre", false);
        }
        return actions;
    }

    protected final Action[] getInformationActions() {
        Vector ids = Path.getPath().getIds();
        String currentId = this.getCurrentId();
        if (currentId.compareTo("A0") == 0) {
            Action ac2;
            int length = 1;
            Action[] actions = new Action[1];
            int addedIndex = 0;
            actions[addedIndex] = ac2 = new Action(this.getArrivedToTitle("A1"), "topic", "BT=A1", "autre", false);
            return actions;
        }
        String nextId = this.getNextId(currentId);
        int length = 0;
        if (nextId != null) {
            ++length;
        }
        Action[] actions = new Action[length];
        int addedIndex = 0;
        if (nextId != null) {
            Action ac3;
            actions[addedIndex] = ac3 = new Action(this.getArrivedToTitle(nextId), "topic", "BT=" + nextId, "autre", false);
            ++addedIndex;
        }
        return actions;
    }

    protected final String getWktMessage() {
        String currentId = this.getCurrentId();
        Vector ids = Path.getPath().getIds();
        StringBuffer bf = new StringBuffer();
        bf.append("<wkt>");
        String floor1 = FSLCommonPlugin.getNLSString(String.valueOf(currentId) + ".floor");
        if (this.isInGuidanceMode) {
            String color = "LINECOLOR(255 128 0)";
            if (floor1.equals("2")) {
                color = "LINECOLOR(255 255 0)";
            }
            bf.append("PATH(ID(path1), " + color + ", LINESTRING(");
            String initPath = Path.getPath().getWayPointsPaths()[ids.indexOf(currentId)][ids.indexOf(this.getDestId())];
            if (initPath == null || initPath.length() == 0) {
                initPath = String.valueOf(currentId) + "-" + this.getDestId();
            }
            String wayPointsPaths = this.getWayPointsPath(initPath);
            bf.append(this.getWktPathCoordinates(wayPointsPaths));
            bf.append("))");
        }
        bf.append("LAYER(ID(visitor)LINECOLOR(255 255 0),POINT(");
        bf.append(Path.getPositionX(currentId));
        bf.append(" " + Path.getPositionY(currentId));
        bf.append("))");
        bf.append("</wkt>");
        return bf.toString();
    }

    private final String getWayPointsPath(String initString) {
        int i2;
        String prevPoint = "";
        Vector ids = Path.getPath().getIds();
        String string = initString;
        int index = 0;
        while ((i2 = string.indexOf(45)) >= 0) {
            String point = string.substring(0, i2);
            if (point.compareTo(prevPoint) == 0) {
                return initString.substring(0, index - 1);
            }
            prevPoint = point;
            string = string.substring(i2 + 1);
            index += i2 + 1;
        }
        return initString;
    }
}

