/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.data.properties;

import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.uif.fsl.common.action.ActionsManager;
import com.ibm.uif.fsl.common.client.payload.CommonPayload;
import com.ibm.uif.fsl.common.client.plugin.FSLCommonPlugin;
import com.ibm.uif.fsl.common.client.plugin.translator.GeneralTranslator;
import com.ibm.uif.fsl.data.DataHandler;
import com.ibm.uif.fsl.data.DataRequest;
import com.ibm.uif.fsl.data.IDataHandler;
import com.ibm.uif.fsl.data.properties.Path;
import java.io.IOException;
import java.util.Calendar;
import javax.microedition.lcdui.Image;

public abstract class PropertiesDataRequest
extends DataRequest {
    private String currentLanguage = "it";
    protected boolean isInGuidanceMode = false;

    public void sendRequest(String request) {
        System.out.println("Requete : " + request);
        if (request.startsWith("BT=")) {
            Path.getPath().setPrecId(this.getCurrentId());
            String currentId = request.substring(3);
            Path.getPath().setCurrentId(currentId);
            if (currentId.equals(Path.getPath().getDestId())) {
                Path.getPath().setDestId(null);
                this.isInGuidanceMode = false;
            }
            Path.getPath().getSavedPoints().addElement(currentId);
            Path.getPath().getSavedDate().addElement(new Long(Calendar.getInstance().getTime().getTime()));
            this.sendInformation();
            this.sendLocation();
        } else if (request.startsWith("login")) {
            this.sendPreferences();
        } else if (request.startsWith("Goto=")) {
            String id = request.substring(5);
            Path.getPath().setDestId(id);
            this.isInGuidanceMode = true;
            this.sendLocation();
        } else if (request.startsWith("stopguidance")) {
            this.isInGuidanceMode = false;
            Path.getPath().setDestId(null);
            this.sendLocation();
        } else if (request.startsWith("language=")) {
            this.currentLanguage = request.substring(9);
            PropertiesDataRequest propertiesDataRequest = this;
            propertiesDataRequest.setCurrentLanguage(propertiesDataRequest.currentLanguage);
            this.sendPreferences();
            this.sendInformation();
            this.sendLocation();
        } else if (request.startsWith("User=")) {
            CommonPayload pl = new CommonPayload(0, this.getHelloMessage(), this.getWelcomeMessage(), null, null, this.getWelcomeImage(), null);
            Message m2 = new Message(new Source(""), pl.toString());
            DataHandler.getDataHandler().showMessage("0", m2);
        }
    }

    protected abstract void sendPreferences();

    protected final String getWelcomeImage() {
        return "/images/welcomImag.png";
    }

    protected final String getWelcomeMessage() {
        return FSLCommonPlugin.getNLSString("Welcome_Message");
    }

    protected final String getHelloMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append(FSLCommonPlugin.getNLSString("hello"));
        return sb.toString();
    }

    protected final void setCurrentLanguage(String language) {
        GeneralTranslator tr = (GeneralTranslator)PluginManager.getManager().getPlugin(Translator.PLUGIN_NAME);
        tr.setLanguage(language);
        this.currentLanguage = language;
        ActionsManager.getActionsManager().languageChanged();
        this.sendInformation();
        this.sendLocation();
    }

    protected final void sendLocation() {
        String wktMessage = this.getWktMessage();
        CommonPayload pl = new CommonPayload(2, this.getMapTitle(), "", this.getMapActions());
        String s2 = pl.toString();
        String response = s2.substring(0, s2.indexOf("</m>"));
        response = String.valueOf(response) + wktMessage + "</m>";
        pl = new CommonPayload(response);
        Message msg = new Message(new Source(""), pl.toString().getBytes());
        this.sendMessage("2", msg);
    }

    protected abstract Action[] getMapActions();

    protected final String getGuidanceTitle(String id) {
        return String.valueOf(FSLCommonPlugin.getNLSString("goto")) + " " + FSLCommonPlugin.getNLSString(String.valueOf(id) + ".title");
    }

    protected abstract String getWktMessage();

    protected final String getWktPathCoordinates(String string) {
        int i2 = 0;
        StringBuffer sb = new StringBuffer();
        while ((i2 = string.indexOf(45)) >= 0) {
            String wayPoint = string.substring(0, i2);
            sb.append(Path.getPositionX(wayPoint));
            sb.append(" ");
            sb.append(Path.getPositionY(wayPoint));
            sb.append(",");
            string = string.substring(i2 + 1);
        }
        sb.append(Path.getPositionX(string));
        sb.append(" ");
        sb.append(Path.getPositionY(string));
        return sb.toString();
    }

    protected final void sendInformation() {
        CommonPayload pl = new CommonPayload(1, this.getInformationTitle(), this.getInformationDescription(), this.getInformationActions(), null, this.getInformationImage(), null);
        Source src = new Source("");
        Message msg = new Message(src, pl.toString().getBytes());
        this.sendMessage("1", msg);
    }

    protected abstract Action[] getInformationActions();

    protected final String getArrivedToTitle(String id) {
        if (FSLCommonPlugin.getNLSString("arrivedTo").length() == 0) {
            return FSLCommonPlugin.getNLSString(String.valueOf(id) + ".title");
        }
        return String.valueOf(FSLCommonPlugin.getNLSString("arrivedTo")) + " " + FSLCommonPlugin.getNLSString(String.valueOf(id) + ".title");
    }

    protected final String getInformationTitle() {
        String key = String.valueOf(this.getCurrentId()) + ".title";
        String result = FSLCommonPlugin.getNLSString(key);
        return result;
    }

    protected String getInformationDescription() {
        String key = String.valueOf(this.getCurrentId()) + ".description1";
        String result = FSLCommonPlugin.getNLSString(key);
        return result;
    }

    protected final String getInformationImage() {
        String imageName = FSLCommonPlugin.getNLSString(String.valueOf(this.getCurrentId()) + ".image");
        try {
            Image.createImage((String)imageName);
        }
        catch (IOException ex) {
            imageName = null;
        }
        return imageName;
    }

    protected final void sendMessage(String type, Message msg) {
        IDataHandler h2 = (IDataHandler)((Object)PluginManager.getManager().getPlugin("DataHandler"));
        h2.showMessage(type, msg);
    }

    protected final String getCurrentId() {
        return Path.getPath().getCurrentId();
    }

    protected final String getDestId() {
        return Path.getPath().getDestId();
    }

    protected String getMapTitle() {
        if (!this.isInGuidanceMode) {
            return this.getInformationTitle();
        }
        StringBuffer buff = new StringBuffer();
        buff.append(FSLCommonPlugin.getNLSString("from"));
        buff.append(" ");
        buff.append(this.getInformationTitle());
        buff.append(" ");
        buff.append(FSLCommonPlugin.getNLSString("to"));
        buff.append(" ");
        buff.append(FSLCommonPlugin.getNLSString(String.valueOf(Path.getPath().getDestId()) + ".title"));
        return buff.toString();
    }
}

