/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.data.properties;

import com.ibm.uif.fsl.common.client.plugin.FSLCommonPlugin;
import java.util.Vector;

public final class Path {
    private Vector savedPoints = new Vector();
    private Vector savedDate = new Vector();
    private Vector ids = new Vector();
    private String[][] wayPointsPaths;
    private String[] points;
    private static Path path;
    private String currentId = null;
    private String destId = null;
    private String precId = null;

    private Path() {
        this.initializePoints();
        this.initializeWayPoints();
    }

    public static Path getPath() {
        if (path == null) {
            path = new Path();
        }
        return path;
    }

    private final void initializePoints() {
        int i2;
        this.ids = new Vector();
        String string = FSLCommonPlugin.getNLSString("points");
        while ((i2 = string.indexOf(45)) >= 0) {
            String point = string.substring(0, i2);
            this.ids.addElement(point);
            string = string.substring(i2 + 1);
        }
        this.ids.addElement(string);
        this.points = new String[this.ids.size()];
        i2 = 0;
        while (i2 < this.ids.size()) {
            this.points[i2] = (String)this.ids.elementAt(i2);
            ++i2;
        }
    }

    private final void initializeWayPoints() {
        this.wayPointsPaths = new String[this.points.length][this.points.length];
        int i2 = 0;
        while (i2 < this.points.length) {
            int j2 = 0;
            while (j2 < this.points.length) {
                this.wayPointsPaths[i2][j2] = i2 != j2 ? FSLCommonPlugin.getNLSString(String.valueOf(this.points[i2]) + "to" + this.points[j2]) : "";
                ++j2;
            }
            ++i2;
        }
    }

    public final Vector getSavedDate() {
        return this.savedDate;
    }

    public final Vector getSavedPoints() {
        return this.savedPoints;
    }

    public final Vector getIds() {
        return this.ids;
    }

    public final String[][] getWayPointsPaths() {
        return this.wayPointsPaths;
    }

    public static String getPositionX(String id) {
        return FSLCommonPlugin.getNLSString(String.valueOf(id) + ".positionx");
    }

    public static String getPositionY(String id) {
        return FSLCommonPlugin.getNLSString(String.valueOf(id) + ".positiony");
    }

    public final String getCurrentId() {
        return this.currentId;
    }

    public final String getDestId() {
        return this.destId;
    }

    public final void setCurrentId(String string) {
        this.currentId = string;
    }

    public final void setDestId(String string) {
        this.destId = string;
    }

    public final void setPrecId(String string) {
        this.precId = string;
    }
}

