/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.common.client.plugin.location;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.uif.fsl.common.client.plugin.FSLCommonPlugin;
import com.ibm.uif.fsl.common.client.plugin.location.CameraListener;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.MIDlet;

public final class CameraViewer
extends Canvas
implements CommandListener {
    public boolean IS_IN_USE = false;
    public boolean IS_SNAPING = false;
    public Player $player = null;
    private VideoControl $videoControl = null;
    private Command $captureCommand;
    private Command $exitCommand;
    private CameraListener cameraListener = null;
    private byte[] pngImage;
    private Displayable displayable;

    public CameraViewer() {
        try {
            this.$player = null;
            String platform = System.getProperty("microedition.platform");
            if (platform != null && platform.indexOf("Nokia") >= 0) {
                try {
                    this.$player = Manager.createPlayer((String)"capture://image");
                }
                catch (MediaException mediaException) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            if (this.$player == null) {
                this.$player = Manager.createPlayer((String)"capture://video");
            }
            this.$player.realize();
            this.$videoControl = (VideoControl)this.$player.getControl("VideoControl");
            this.$videoControl.initDisplayMode(1, (Object)this);
            this.$videoControl.setDisplayLocation(0, 0);
            this.$videoControl.setDisplayFullScreen(true);
            this.$captureCommand = new Command(FSLCommonPlugin.getNLSString("Capture"), 1, 0);
            CameraViewer cameraViewer = this;
            cameraViewer.addCommand(cameraViewer.$captureCommand);
            this.$exitCommand = new Command(FSLCommonPlugin.getNLSString("uc.exit"), 7, 1);
            CameraViewer cameraViewer2 = this;
            cameraViewer2.addCommand(cameraViewer2.$exitCommand);
            CameraViewer cameraViewer3 = this;
            cameraViewer3.setCommandListener(cameraViewer3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void commandAction(Command c2, Displayable s2) {
        if (c2 == this.$captureCommand) {
            if (!this.IS_SNAPING) {
                this.IS_SNAPING = true;
                this.takeSnapshot();
                this.processResult();
            }
        } else if (c2 == this.$exitCommand) {
            this.stop();
            this.IS_IN_USE = false;
        }
    }

    private final void processResult() {
        this.stop();
        new Thread(){

            public final void run() {
                CameraViewer.this.cameraListener.pictureShot(CameraViewer.this.pngImage);
                CameraViewer.this.IS_IN_USE = false;
            }
        }.start();
    }

    public final void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 8 && !this.IS_SNAPING) {
            this.IS_SNAPING = true;
            this.takeSnapshot();
            this.processResult();
        }
    }

    final synchronized void start(Displayable d2) throws MediaException, SecurityException {
        this.IS_SNAPING = false;
        this.refreshMenu();
        this.displayable = d2;
        if (this.$player != null) {
            try {
                Display.getDisplay((MIDlet)UniversalCommunicator.getInbox()).setCurrent((Displayable)this);
                this.$player.start();
                this.$videoControl.setVisible(true);
            }
            catch (MediaException mediaException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private final void refreshMenu() {
        CameraViewer cameraViewer = this;
        cameraViewer.removeCommand(cameraViewer.$captureCommand);
        CameraViewer cameraViewer2 = this;
        cameraViewer2.removeCommand(cameraViewer2.$exitCommand);
        this.$captureCommand = new Command(FSLCommonPlugin.getNLSString("Capture"), 1, 0);
        CameraViewer cameraViewer3 = this;
        cameraViewer3.addCommand(cameraViewer3.$captureCommand);
        this.$exitCommand = new Command(FSLCommonPlugin.getNLSString("uc.exit"), 7, 1);
        CameraViewer cameraViewer4 = this;
        cameraViewer4.addCommand(cameraViewer4.$exitCommand);
    }

    final synchronized void stop() {
        if (this.$player != null) {
            try {
                this.$videoControl.setVisible(false);
                this.$player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            Display.getDisplay((MIDlet)UniversalCommunicator.getInbox()).setCurrent(this.displayable);
        }
    }

    public final void takeSnapshot() {
        if (this.$player != null) {
            this.pngImage = null;
            try {
                this.pngImage = this.$videoControl.getSnapshot("encoding=png&width=640&height=480");
                if (this.pngImage == null) {
                    this.pngImage = this.$videoControl.getSnapshot("encoding=jpeg&width=640&height=480");
                }
            }
            catch (MediaException mediaException) {
            }
            catch (Exception e2) {
                this.IS_SNAPING = false;
            }
        }
    }

    public final void paint(Graphics g2) {
    }

    public final void setCameraListener(CameraListener l2) {
        this.cameraListener = l2;
    }
}

