/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rtk;

import com.ibm.rtk.CustomWidget;
import com.ibm.rtk.Keymap;
import com.ibm.rtk.Toolkit;
import com.ibm.rtk.VKeyboard;
import com.ibm.rtk.ValueListener;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class TextfieldWidget
extends CustomWidget {
    public static long timeout = 700L;
    public static int capsKey = 35;
    public int border = Toolkit.border;
    public int subbodybg = Toolkit.subbodybg;
    public int labelfg = 0;
    public int inputfg = 0;
    public int cursorfg = 255;
    boolean focus = false;
    private static long numericpadtime = 0L;
    private static boolean capslock = false;
    private Font normalfont = Toolkit.normalfont;
    private Font boldfont = Toolkit.boldfont;
    private int fontheight;
    private int fontwidth;
    private int prefwidth;
    private int prefheight;
    private int boxheight;
    private boolean selectmode = false;
    private int sizewidth = 0;
    private int glw;
    private int charw;
    private int lw;
    private String label;
    private Image required;
    private Image error;
    private Image optional;
    private Image upcase;
    private int imagewidth = 0;
    private int style = 32;
    private String actualtext = "";
    private String safetext = "";
    private String displaytext = "";
    private int caret = 0;
    private int previousKeyCode = 0;
    private int margin = 2;
    int position = 0;
    static VKeyboard vk = null;
    private ValueListener listener = null;
    private boolean wordbreak = true;
    private int lines = 3;
    private int currentline = 0;
    private int startline = 0;
    private int endline = 0;
    private int screenline = 0;
    private int maxlines = 0;
    private Vector cache = new Vector();
    private int prevkey = 0;
    boolean uplow = false;

    public TextfieldWidget(String string, int n2, int n3, int n4, int n5, Font font) {
        super(null);
        if (string == null) {
            string = "";
        }
        this.label = string;
        this.lines = n4;
        if (this.lines > 1) {
            n5 &= 0xFFFFFFBF;
        }
        if (this.lines <= 0) {
            this.lines = 1;
        }
        this.style = n5;
        this.normalfont = font;
        this.boldfont = Font.getFont((int)font.getFace(), (int)1, (int)font.getSize());
        this.init(n2, n3);
    }

    private static synchronized void start() {
        if (vk != null) {
            return;
        }
        vk = new VKeyboard();
    }

    private final void softWrap() {
        int n2;
        TextfieldWidget textfieldWidget = this;
        int n3 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        int n4 = this.caret;
        int n5 = (this.style & 0x10) == 16 ? n3 - this.imagewidth - this.margin - 3 : n3 - this.glw - this.imagewidth - this.margin - 3;
        int n6 = this.normalfont.stringWidth(this.displaytext);
        if (n6 <= (n5 -= 2)) {
            return;
        }
        if ((this.style & 0x800) != 2048) {
            return;
        }
        String string = "";
        int n7 = 0;
        for (n2 = this.currentline; n2 < this.maxlines; ++n2) {
            ++n7;
            String string2 = (String)this.cache.elementAt(n2);
            string = string + string2;
            if (string2.indexOf(10) != -1) break;
        }
        n2 = this.currentline;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (true) {
            int n11;
            if ((n11 = string.indexOf(32, n9)) == -1) {
                this.cache.insertElementAt(string.substring(n8, n10 + 1), n2);
                ++n2;
                ++this.maxlines;
                if (++n10 >= this.retlength(string)) break;
                this.cache.insertElementAt(string.substring(n10), n2);
                ++n2;
                ++this.maxlines;
                break;
            }
            n6 = this.normalfont.substringWidth(string, n8, n11 - n8);
            if (n6 >= n5) {
                this.cache.insertElementAt(string.substring(n8, n10 + 1), n2);
                ++n2;
                ++this.maxlines;
                n9 = ++n10;
                n8 = n10;
                continue;
            }
            n10 = n11;
            n9 = n10 + 1;
        }
        for (int i2 = 0; i2 < n7; ++i2) {
            --this.maxlines;
            this.cache.removeElementAt(n2);
        }
        if ((this.style & 0x1000) == 4096) {
            this.lines = this.cache.size();
            if (this.lines <= 0) {
                this.lines = 1;
            }
            this.adjustSize();
        }
        this.actualtext = this.displaytext = (String)this.cache.elementAt(this.currentline);
        TextfieldWidget textfieldWidget2 = this;
        if (n4 > textfieldWidget2.retlength(textfieldWidget2.displaytext)) {
            TextfieldWidget textfieldWidget3 = this;
            this.caret = n4 - textfieldWidget3.retlength(textfieldWidget3.displaytext);
            this.computeline(6);
            System.out.println("compute line down");
        }
        this.computeline(0);
    }

    private final void reflow() {
        if ((this.style & 0x800) != 2048) {
            return;
        }
        for (int i2 = 0; i2 < this.maxlines; ++i2) {
            this.currentline = i2;
            this.displaytext = this.actualtext = (String)this.cache.elementAt(i2);
            this.currentline = 0;
            this.startline = 0;
            this.endline = this.startline + this.lines;
            if (this.endline >= this.maxlines) {
                this.endline = this.maxlines;
            }
            this.softWrap();
        }
        this.position = 0;
        this.screenline = 0;
        this.currentline = 0;
        this.actualtext = "";
        if (this.maxlines > 0) {
            this.actualtext = (String)this.cache.elementAt(0);
        }
        this.displaytext = this.actualtext;
        this.caret = 0;
        this.startline = 0;
        this.endline = this.startline + this.lines;
        if (this.endline >= this.maxlines) {
            this.endline = this.maxlines;
        }
    }

    private final void setTextArea(String string) {
        int n2;
        int n3 = 0;
        int n4 = string.length();
        this.cache.removeAllElements();
        if (n4 == 0) {
            this.cache.addElement("");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (string.charAt(n2) != '\n') continue;
            this.cache.addElement(string.substring(n3, n2 + 1));
            n3 = n2 + 1;
        }
        if (n3 != n2) {
            this.cache.addElement(string.substring(n3, n2));
        }
        this.maxlines = this.cache.size();
        this.startline = this.currentline = this.maxlines - 1;
        this.computeline(0);
        this.displaytext = this.actualtext = (String)this.cache.elementAt(this.currentline);
        this.reflow();
        TextfieldWidget textfieldWidget = this;
        textfieldWidget.caret = textfieldWidget.retlength(textfieldWidget.displaytext);
        this.position = 0;
    }

    public final void setText(String string) {
        if (this.lines > 1 || (this.style & 0x1000) == 4096) {
            this.setTextArea(string);
            return;
        }
        this.actualtext = string;
        this.displaytext = string;
        int n2 = string.length();
        this.caret = this.retlength(string);
        this.position = 0;
        if ((this.style & 0x40) != 64) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.setCharAt(i2, '*');
        }
        this.displaytext = stringBuffer.toString();
        this.repaintExt();
    }

    public final String getText() {
        if (this.lines == 1) {
            return this.actualtext;
        }
        String string = "";
        for (int i2 = 0; i2 < this.maxlines; ++i2) {
            string = string + (String)this.cache.elementAt(i2);
        }
        return string;
    }

    public final void setStyle(int n2) {
        if (this.lines > 1) {
            this.style &= 0xFFFFFFBF;
        }
        this.style = n2;
        switch (this.style & 0x10) {
            case 16: {
                int n3 = this.fontheight;
                this.boxheight = n3 + n3 * this.lines + this.margin + this.margin;
                this.prefwidth = this.glw + this.charw * this.fontwidth + this.imagewidth + 2;
                break;
            }
            default: {
                this.boxheight = this.fontheight * this.lines + this.margin + this.margin;
                this.prefwidth = this.glw + this.charw * this.fontwidth + this.imagewidth + 2;
            }
        }
        if (!this.selectmode) {
            this.prefheight = this.boxheight;
        } else {
            this.prefheight = this.boxheight + vk.getPrefContentHeight(-1) + this.margin;
            if (this.prefwidth < vk.getPrefContentWidth(-1) + this.margin) {
                this.prefwidth = vk.getPrefContentWidth(-1) + this.margin;
            }
            this.sizewidth = this.prefwidth;
        }
        TextfieldWidget textfieldWidget = this;
        textfieldWidget.setText(textfieldWidget.actualtext);
        switch (this.style & 0xF) {
            case 1: {
                this.imagewidth = 0;
                break;
            }
            case 8: {
                this.imagewidth = this.optional.getWidth() + 1;
                break;
            }
            case 2: {
                this.imagewidth = this.required.getWidth() + 1;
                break;
            }
            case 4: {
                this.imagewidth = this.error.getWidth() + 1;
            }
        }
        this.imagewidth += this.upcase.getWidth();
    }

    private final void init(int n2, int n3) {
        TextfieldWidget.start();
        try {
            int n4 = this.normalfont.getBaselinePosition();
            this.upcase = n4 > 20 ? Toolkit.createImage("/rtkupcase20.png") : Toolkit.createImage(n4 > 10 ? "/rtkupcase12.png" : "/rtkupcase8.png");
            this.required = Toolkit.createImage("/rtkrequired.png");
            this.error = Toolkit.createImage("/rtkerror.png");
            this.optional = Toolkit.createImage("/rtkinfo.png");
            this.imagewidth = this.required.getWidth();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.fontheight = this.normalfont.getHeight();
        this.boxheight = this.fontheight * this.lines + this.margin + this.margin;
        if ((this.style & 0x10) == 16) {
            this.boxheight += this.fontheight;
        }
        this.fontwidth = this.normalfont.charWidth('8');
        this.lw = n2;
        this.glw = n2 == 0 ? this.boldfont.stringWidth(this.label) : n2 * this.fontwidth;
        this.charw = n3;
        this.prefwidth = this.glw + this.charw * this.fontwidth + this.imagewidth + 2;
        this.prefheight = this.boxheight;
        TextfieldWidget textfieldWidget = this;
        textfieldWidget.setStyle(textfieldWidget.style);
    }

    public final int getMinContentHeight() {
        return this.prefheight;
    }

    public final int getMinContentWidth() {
        return this.prefwidth;
    }

    public final int getPrefContentHeight(int n2) {
        return this.prefheight + 1;
    }

    public final int getPrefContentWidth(int n2) {
        if (this.sizewidth != 0 && this.sizewidth < this.prefwidth) {
            return this.sizewidth;
        }
        if (n2 == -1) {
            return this.prefwidth;
        }
        this.prefwidth = n2;
        return this.prefwidth;
    }

    public final void sizeChanged(int n2, int n3) {
        int n4 = this.width;
        this.sizewidth = n2;
        vk.ViewportSize(n2);
        if (this.sizewidth != n4) {
            this.reflow();
        }
        this.repaintExt();
    }

    private final void drawImage(Graphics graphics, Image image, int n2) {
        int n3 = image.getHeight();
        graphics.drawImage(image, n2, this.boxheight - n3, 20);
        n2 += image.getWidth();
        if (this.uplow) {
            graphics.drawImage(this.upcase, n2, this.boxheight - this.upcase.getHeight(), 20);
        }
    }

    private final void setClip(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.clipRect(n2, n3, n4, n5);
    }

    private final int retlength(String string) {
        int n2 = string.indexOf(10);
        if (n2 == -1) {
            return string.length();
        }
        return n2;
    }

    private final void mydrawString(Graphics graphics, String string, int n2, int n3, int n4) {
        int n5 = string.indexOf(10);
        if (n5 == -1 || this.lines <= 1) {
            graphics.drawString(string, n2, n3, n4);
        } else {
            graphics.drawSubstring(string, 0, n5, n2, n3, n4);
        }
    }

    private final void paintTextArea(Graphics graphics, int n2, int n3, int n4) {
        TextfieldWidget textfieldWidget = this;
        int n5 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        boolean bl = false;
        int n6 = 2;
        int n7 = this.fontheight + this.margin;
        int n8 = n5 - this.imagewidth - this.margin - 3;
        if ((this.style & 0x10) != 16) {
            n6 += this.glw;
            n8 -= this.glw;
            n7 -= this.fontheight;
        }
        graphics.clipRect(n6, n7, n8, this.lines * this.fontheight);
        int n9 = n4 + this.normalfont.stringWidth(this.displaytext);
        int n10 = n4;
        for (int i2 = this.startline; i2 < this.endline; ++i2) {
            String string = (String)this.cache.elementAt(i2);
            if ((this.style & 0x80) == 128) {
                n10 = n9 - this.normalfont.stringWidth(string);
            }
            this.mydrawString(graphics, string, n6 + n10, n7, 20);
            n7 += this.fontheight;
        }
    }

    private final void paintAlignTopBody(Graphics graphics, int n2, int n3) {
        TextfieldWidget textfieldWidget = this;
        int n4 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        int n5 = this.fontheight + this.margin;
        int n6 = this.subbodybg;
        int n7 = this.labelfg;
        int n8 = 0;
        if (!this.enable) {
            n6 = Toolkit.greyColor(n6);
            n7 = Toolkit.greyColor(n7);
            n8 = Toolkit.greyColor(n8);
        }
        if (this.border == 0) {
            graphics.setColor(n8);
            graphics.fillRect(0, this.fontheight, n4 - this.imagewidth - 2, this.lines * this.fontheight + this.margin + this.margin);
        }
        graphics.setColor(n6);
        graphics.fillRect(1, this.fontheight + 1, n4 - this.imagewidth - 2 - 2, this.lines * this.fontheight - 2 + this.margin + this.margin);
        Toolkit.drawBorder(this.border, graphics, 0, this.fontheight, n4 - this.imagewidth - 2, this.lines * this.fontheight + this.margin + this.margin);
        graphics.setColor(n7);
        graphics.setFont(this.boldfont);
        graphics.drawString(this.label, 0, 0, 20);
        switch (this.style & 0xF) {
            case 1: {
                if (!this.uplow) break;
                graphics.drawImage(this.upcase, n4 - this.upcase.getWidth() - 1, this.boxheight - this.upcase.getHeight(), 20);
                break;
            }
            case 8: {
                this.drawImage(graphics, this.optional, n4 - this.imagewidth);
                break;
            }
            case 2: {
                this.drawImage(graphics, this.required, n4 - this.imagewidth);
                break;
            }
            case 4: {
                this.drawImage(graphics, this.error, n4 - this.imagewidth);
            }
        }
    }

    private final void paintAlignTop(Graphics graphics, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.inputfg;
        int n7 = 0;
        TextfieldWidget textfieldWidget = this;
        int n8 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        graphics.setFont(this.normalfont);
        int n9 = 2;
        int n10 = n8 - this.imagewidth - this.margin - 3;
        String string = this.displaytext.substring(0, this.caret);
        int n11 = this.normalfont.stringWidth(string) - 1;
        int n12 = n8 - this.imagewidth - 2 - n11 - n9;
        if (!this.enable) {
            n6 = Toolkit.greyColor(n6);
            n7 = Toolkit.greyColor(n7);
        }
        if (n12 > 0) {
            n12 = 0;
        }
        if ((n5 = n9 + n11 + n12) > n9 + n8 - this.imagewidth - 3) {
            n5 = n9 + n8 - this.imagewidth - 2;
        }
        if ((this.style & 0x80) == 128 && (n4 = this.normalfont.stringWidth(this.displaytext)) < n10) {
            n12 += n10 - n4;
            n5 += n10 - n4;
        }
        n4 = this.margin + this.screenline * this.fontheight + this.fontheight;
        if (this.focus) {
            this.position = n5;
            graphics.setColor(n7);
            graphics.setColor(this.cursorfg);
            graphics.drawLine(this.position, n4, this.position, n4 + this.fontheight);
            graphics.drawLine(this.position + 1, n4, this.position + 1, n4 + this.fontheight);
        }
        graphics.setColor(n6);
        this.paintTextArea(graphics, n2, n3, n12);
        this.setClip(graphics, n9, this.fontheight + this.margin, n8 - this.imagewidth - 2 - n9, this.fontheight);
        this.mydrawString(graphics, this.displaytext, n9 + n12, n4, 20);
    }

    private final void paintAlignLeftBody(Graphics graphics, int n2, int n3) {
        graphics.setFont(this.normalfont);
        TextfieldWidget textfieldWidget = this;
        int n4 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        int n5 = this.subbodybg;
        int n6 = this.labelfg;
        int n7 = 0;
        if (!this.enable) {
            n5 = Toolkit.greyColor(n5);
            n6 = Toolkit.greyColor(n6);
            n7 = Toolkit.greyColor(n7);
        }
        if (this.border == 0) {
            graphics.setColor(n7);
            graphics.fillRect(this.glw, 0, n4 - this.glw - this.imagewidth - 2, this.boxheight);
        }
        graphics.setColor(n5);
        graphics.fillRect(this.glw + 1, 1, n4 - this.glw - this.imagewidth - 2 - 2, this.boxheight - 2);
        Toolkit.drawBorder(this.border, graphics, this.glw, 0, n4 - this.glw - this.imagewidth - 2, this.boxheight);
        graphics.setColor(n6);
        int n8 = this.glw - this.boldfont.stringWidth(this.label);
        graphics.setFont(this.boldfont);
        graphics.drawString(this.label, n8, this.margin, 20);
        switch (this.style & 0xF) {
            case 1: {
                if (!this.uplow) break;
                graphics.drawImage(this.upcase, n4 - this.upcase.getWidth() - 1, this.boxheight - this.upcase.getHeight(), 20);
                break;
            }
            case 8: {
                this.drawImage(graphics, this.optional, n4 - this.imagewidth);
                break;
            }
            case 2: {
                graphics.setColor(n7);
                this.drawImage(graphics, this.required, n4 - this.imagewidth);
                break;
            }
            case 4: {
                this.drawImage(graphics, this.error, n4 - this.imagewidth);
            }
        }
    }

    private final void paintAlignLeft(Graphics graphics, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.inputfg;
        int n7 = 0;
        TextfieldWidget textfieldWidget = this;
        int n8 = textfieldWidget.getPrefContentWidth(textfieldWidget.prefwidth);
        int n9 = this.glw + 2;
        int n10 = n8 - this.glw - this.imagewidth - this.margin - 3;
        String string = this.displaytext.substring(0, this.caret);
        int n11 = this.normalfont.stringWidth(string) - 1;
        int n12 = n10 - n11;
        if (!this.enable) {
            n6 = Toolkit.greyColor(n6);
            n7 = Toolkit.greyColor(n7);
        }
        if (n12 > 0) {
            n12 = 0;
        }
        if ((n5 = n9 + n11 + n12) > n9 + n10 - 1) {
            n5 = n9 + n10;
        }
        if ((this.style & 0x80) == 128 && (n4 = this.normalfont.stringWidth(this.displaytext)) < n10) {
            n12 += n10 - n4;
            n5 += n10 - n4;
        }
        n4 = this.screenline * this.fontheight;
        if (this.focus) {
            this.position = n5;
            graphics.setColor(n7);
            graphics.setColor(this.cursorfg);
            graphics.drawLine(this.position, n4 + 2, this.position, n4 + 2 + this.fontheight);
            graphics.drawLine(this.position + 1, n4 + 2, this.position + 1, n4 + 2 + this.fontheight);
        }
        graphics.setFont(this.normalfont);
        graphics.setColor(n6);
        this.paintTextArea(graphics, n2, n3, n12);
        this.setClip(graphics, n9, this.margin, n10, this.boxheight - this.margin);
        this.mydrawString(graphics, this.displaytext, n9 + n12, n4 + this.margin, 20);
    }

    public final void paint(Graphics graphics, int n2, int n3) {
        if (this.selectmode) {
            vk.paint(graphics, n2, n3, this.boxheight + this.margin);
        }
        if ((this.style & 0x10) == 16) {
            this.paintAlignTopBody(graphics, n2, n3);
            this.paintAlignTop(graphics, n2, n3);
        } else {
            this.paintAlignLeftBody(graphics, n2, n3);
            this.paintAlignLeft(graphics, n2, n3);
        }
    }

    private final void cPassword(int n2, int n3) {
        int n4 = this.actualtext.length();
        this.displaytext = this.actualtext;
        if ((this.style & 0x40) == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(this.actualtext);
        for (int i2 = 0; i2 < n4; ++i2) {
            stringBuffer.setCharAt(i2, '*');
        }
        if ((this.style & 0x400) == 1024) {
            stringBuffer.setCharAt(n2 - 1, (char)n3);
        }
        this.displaytext = stringBuffer.toString();
    }

    private final void transcode(String string, String string2, int n2) {
        int n3;
        if ((this.style & 0x1000) != 4096 && (this.style & 0x2000) == 8192 && this.actualtext.length() >= this.charw) {
            return;
        }
        if (!this.selectmode && (this.style & 0x400) == 1024) {
            if (n2 == capsKey) {
                this.uplow = true;
                if (capslock) {
                    capslock = false;
                    this.prevkey = 0;
                    this.uplow = false;
                    return;
                }
                if (this.prevkey == capsKey) {
                    capslock = true;
                    this.prevkey = capsKey;
                    return;
                }
                this.prevkey = n2;
                return;
            }
            long l2 = System.currentTimeMillis();
            if (numericpadtime - l2 < -timeout && this.prevkey != capsKey) {
                this.prevkey = 0;
            }
            numericpadtime = l2;
            if (this.prevkey != n2 && this.prevkey != capsKey && !capslock) {
                this.uplow = false;
            }
            n3 = 0;
            int n4 = Toolkit.transcode.range(n2, this.prevkey, this.uplow);
            if (n4 > 0) {
                if (n2 == this.prevkey) {
                    n2 = n4;
                    TextfieldWidget textfieldWidget = this;
                    if (textfieldWidget.retlength(textfieldWidget.actualtext) == 0) {
                        this.actualtext = string + (char)n2;
                        n3 = this.actualtext.length();
                        this.actualtext = this.actualtext + string2;
                    } else {
                        if (this.caret > 0) {
                            string = string.substring(0, this.caret - 1);
                        }
                        this.actualtext = string + (char)n2;
                        n3 = this.actualtext.length();
                        this.actualtext = this.actualtext + string2;
                    }
                    this.displaytext = this.actualtext;
                    this.cPassword(n3, n2);
                    return;
                }
                this.prevkey = n2;
                n2 = n4;
            } else {
                this.prevkey = n2;
            }
        }
        this.actualtext = string + (char)n2;
        n3 = this.actualtext.length();
        this.actualtext = this.actualtext + string2;
        this.cPassword(n3, n2);
        if ((this.style & 0x80) == 128) {
            if (!this.moveRL(n2)) {
                ++this.caret;
            }
        } else {
            ++this.caret;
        }
    }

    private final boolean moveRL(int n2) {
        return n2 >= 1424 && n2 <= 1871;
    }

    public final void adjustSize() {
        switch (this.style & 0x10) {
            case 16: {
                int n2 = this.fontheight;
                this.boxheight = n2 + n2 * this.lines + this.margin + this.margin;
                this.prefwidth = this.glw + this.charw * this.fontwidth + this.imagewidth + 2;
                break;
            }
            default: {
                this.boxheight = this.fontheight * this.lines + this.margin + this.margin;
                this.prefwidth = this.glw + this.charw * this.fontwidth + this.imagewidth + 2;
            }
        }
        if (!this.selectmode) {
            this.prefheight = this.boxheight;
        } else {
            this.prefheight = this.boxheight + vk.getPrefContentHeight(-1) + this.margin;
            if (this.prefwidth < vk.getPrefContentWidth(-1) + this.margin) {
                this.prefwidth = vk.getPrefContentWidth(-1) + this.margin;
            }
            this.sizewidth = this.prefwidth;
        }
        TextfieldWidget textfieldWidget = this;
        textfieldWidget.setPreferredSize(textfieldWidget.prefwidth, this.prefheight);
    }

    private final void textarea(int n2) {
        if (n2 == 10) {
            this.cache.insertElementAt(this.actualtext.substring(this.caret), this.currentline + 1);
            this.cache.setElementAt(this.actualtext.substring(0, this.caret) + "\n", this.currentline);
            this.caret = 0;
            this.position = 0;
            ++this.maxlines;
            if ((this.style & 0x1000) == 4096) {
                ++this.lines;
                this.adjustSize();
            }
            this.computeline(6);
            this.computeline(0);
            return;
        }
        if ((this.style & 0x80) == 128) {
            this.rightLeft(n2);
        } else {
            this.leftRight(n2);
        }
        this.cache.setElementAt(this.displaytext, this.currentline);
        this.softWrap();
        this.serviceRepaint();
    }

    private final void leftRight(int n2) {
        String string = this.actualtext.substring(0, this.caret);
        String string2 = this.actualtext.substring(this.caret);
        String string3 = this.actualtext;
        if (n2 == Keymap.KEYCODE_CLEAR || n2 == Keymap.KEYCODE_BACKSPACE || n2 == 8) {
            if (this.caret > 0) {
                string = string.substring(0, this.caret - 1);
            }
            this.actualtext = string + string2;
            if ((this.style & 0x40) == 64) {
                TextfieldWidget textfieldWidget = this;
                TextfieldWidget textfieldWidget2 = this;
                if (textfieldWidget.retlength(textfieldWidget.actualtext) < textfieldWidget2.retlength(textfieldWidget2.displaytext)) {
                    this.displaytext = this.displaytext.substring(1);
                }
            } else {
                this.displaytext = this.actualtext;
            }
            --this.caret;
            if (this.caret < 0) {
                if (this.currentline != 0 && this.lines > 1) {
                    int n3 = this.currentline;
                    this.computeline(1);
                    this.cache.removeElementAt(n3);
                    --this.maxlines;
                    if (this.maxlines < 0) {
                        this.maxlines = 0;
                    }
                    this.computeline(0);
                    TextfieldWidget textfieldWidget = this;
                    textfieldWidget.caret = textfieldWidget.retlength(textfieldWidget.displaytext);
                    this.actualtext = this.displaytext = this.displaytext.substring(0, this.caret) + string3;
                    if ((this.style & 0x1000) == 4096) {
                        --this.lines;
                        if (this.lines < 0) {
                            this.lines = 0;
                        }
                        this.adjustSize();
                    }
                } else {
                    this.caret = 0;
                }
            }
        } else {
            this.transcode(string, string2, n2);
        }
    }

    private final void rightLeft(int n2) {
        String string = this.actualtext.substring(0, this.caret);
        String string2 = this.actualtext.substring(this.caret);
        if (n2 == Keymap.KEYCODE_CLEAR || n2 == Keymap.KEYCODE_BACKSPACE || n2 == 8) {
            if (string2.length() > 0) {
                string2 = string2.substring(1);
            }
            this.actualtext = string + string2;
            if ((this.style & 0x40) == 64) {
                TextfieldWidget textfieldWidget = this;
                TextfieldWidget textfieldWidget2 = this;
                if (textfieldWidget.retlength(textfieldWidget.actualtext) < textfieldWidget2.retlength(textfieldWidget2.displaytext)) {
                    this.displaytext = this.displaytext.substring(1);
                }
            } else {
                this.displaytext = this.actualtext;
            }
            if (string2.length() <= 0 && this.currentline != this.maxlines - 1 && this.lines > 1) {
                string = (String)this.cache.elementAt(this.currentline + 1);
                this.actualtext = this.displaytext = this.displaytext + string.substring(0, this.retlength(string));
                this.cache.removeElementAt(this.currentline + 1);
                --this.maxlines;
                if (this.maxlines < 0) {
                    this.maxlines = 0;
                }
                if ((this.style & 0x1000) == 4096) {
                    --this.lines;
                    if (this.lines < 0) {
                        this.lines = 0;
                    }
                    this.adjustSize();
                }
                this.computeline(0);
            }
        } else {
            this.transcode(string, string2, n2);
        }
    }

    private final void processKey(int n2) {
        if (this.listener != null && !this.listener.valueNotify(n2, (Object)this)) {
            return;
        }
        if (this.selectmode) {
            this.prevkey = 0;
            if (n2 < 0) {
                switch (n2) {
                    case -15: {
                        this.selectmode = false;
                        this.prefheight = this.boxheight;
                        this.sizewidth = this.prefwidth;
                        TextfieldWidget textfieldWidget = this;
                        textfieldWidget.setPreferredSize(textfieldWidget.prefwidth, this.prefheight);
                        this.repaintExt();
                        return;
                    }
                    case -1: {
                        ++this.caret;
                        TextfieldWidget textfieldWidget = this;
                        if (this.caret > textfieldWidget.retlength(textfieldWidget.actualtext)) {
                            TextfieldWidget textfieldWidget2 = this;
                            textfieldWidget2.caret = textfieldWidget2.retlength(textfieldWidget2.actualtext);
                        }
                        this.repaintExt();
                        break;
                    }
                    case -2: {
                        --this.caret;
                        if (this.caret < 0) {
                            this.caret = 0;
                        }
                        this.repaintExt();
                        break;
                    }
                    case -3: {
                        this.computeline(1);
                        this.repaintExt();
                        break;
                    }
                    case -4: {
                        this.computeline(6);
                        this.repaintExt();
                    }
                }
                return;
            }
            if (n2 == 0) {
                this.repaintExt();
                return;
            }
        }
        if (n2 == Keymap.KEYCODE_JOGSELECT && (this.style & 0x100) == 0) {
            boolean bl = this.selectmode = !this.selectmode;
            if (!this.selectmode) {
                this.prefheight = this.boxheight;
            } else {
                this.prefheight = this.boxheight + vk.getPrefContentHeight(-1) + this.margin;
                if (this.prefwidth < vk.getPrefContentWidth(-1) + this.margin) {
                    this.prefwidth = vk.getPrefContentWidth(-1) + this.margin;
                }
            }
            this.sizewidth = this.prefwidth;
            TextfieldWidget textfieldWidget = this;
            textfieldWidget.setPreferredSize(textfieldWidget.prefwidth, this.prefheight);
            this.prevkey = 0;
            return;
        }
        this.modified = true;
        if (this.lines > 1 || (this.style & 0x1000) == 4096) {
            this.textarea(n2);
            return;
        }
        if ((this.style & 0x80) == 128) {
            this.rightLeft(n2);
        } else {
            this.leftRight(n2);
        }
        this.repaintExt();
    }

    public final void keyPressed(int n2) {
        if ((this.style & 0x200) == 512) {
            return;
        }
        if (this.selectmode) {
            n2 = vk.keyPressed(n2);
        }
        this.processKey(n2);
    }

    public final void keyReleased(int n2) {
    }

    public final void keyRepeated(int n2) {
    }

    private final int findCaret(int n2, int n3) {
        int n4 = 0;
        int n5 = n3 / this.fontheight;
        String string = this.displaytext;
        int n6 = this.currentline;
        if (n5 != this.screenline) {
            if ((n6 += n5 - this.screenline) > this.maxlines - 1) {
                return this.caret;
            }
            this.currentline = n6;
            this.screenline = n5;
            this.displaytext = this.actualtext = (String)this.cache.elementAt(this.currentline);
        }
        TextfieldWidget textfieldWidget = this;
        int n7 = textfieldWidget.retlength(textfieldWidget.displaytext);
        if (n7 == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < n7; ++i2) {
            if ((n4 += this.normalfont.charWidth(this.displaytext.charAt(i2))) <= n2) continue;
            return i2;
        }
        return n7;
    }

    public final void pointerPressed(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        if (this.selectmode) {
            if (n3 < this.boxheight + this.margin) {
                return;
            }
            this.processKey(vk.pointerPressed(n2, n3 -= this.boxheight + this.margin));
            return;
        }
        if ((this.style & 0x10) != 16) {
            n5 = this.glw + 2;
            n6 = this.glw + 1;
        }
        n2 -= n6;
        if ((this.style & 0x10) == 16) {
            n3 -= this.fontheight + this.margin;
        }
        if (n3 < 0) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        if (n2 > this.width - n6 - this.imagewidth - 2 - 2) {
            return;
        }
        int n7 = this.width - n6 - this.imagewidth - this.margin - 3;
        String string = this.displaytext.substring(0, this.caret);
        int n8 = this.normalfont.stringWidth(string) - 1;
        int n9 = n7 - n8;
        if (n9 > 0) {
            n9 = 0;
        }
        if ((this.style & 0x80) == 128 && (n4 = this.normalfont.stringWidth(this.displaytext)) < n7) {
            n9 += n7 - n4;
        }
        this.caret = this.findCaret(n2 - n9, n3);
        this.repaintExt();
    }

    public final void traverseOut() {
        this.focus = false;
        this.repaintExt();
        capslock = false;
        this.uplow = false;
    }

    private final boolean computeline(int n2) {
        if (this.lines == 1) {
            return false;
        }
        switch (n2) {
            case 0: {
                this.endline = this.startline + this.lines;
                if (this.endline >= this.maxlines) {
                    this.endline = this.maxlines;
                    this.startline = this.endline - this.lines;
                    if (this.startline < 0) {
                        this.startline = 0;
                    }
                }
                this.screenline = this.currentline - this.startline;
                return true;
            }
            case 1: {
                if (this.currentline == 0) {
                    return false;
                }
                --this.currentline;
                if (this.currentline < 0) {
                    this.currentline = 0;
                }
                if (this.currentline < this.startline) {
                    this.startline = this.currentline;
                    this.endline = this.startline + this.lines;
                }
                if (this.endline < this.maxlines) break;
                this.endline = this.maxlines;
                this.startline = this.endline - this.lines;
                if (this.startline >= 0) break;
                this.startline = 0;
                break;
            }
            case 6: {
                if (this.currentline == this.maxlines - 1) {
                    return false;
                }
                ++this.currentline;
                if (this.currentline >= this.maxlines) {
                    this.currentline = this.maxlines - 1;
                }
                if (this.currentline >= this.endline) {
                    this.endline = this.currentline + this.lines;
                    this.startline = this.endline - this.lines;
                    if (this.startline < 0) {
                        this.startline = 0;
                    }
                }
                if (this.endline < this.maxlines) break;
                this.endline = this.maxlines;
                this.startline = this.endline - this.lines;
                if (this.startline >= 0) break;
                this.startline = 0;
            }
        }
        this.screenline = this.currentline - this.startline;
        this.displaytext = this.actualtext = (String)this.cache.elementAt(this.currentline);
        TextfieldWidget textfieldWidget = this;
        if (this.caret > textfieldWidget.retlength(textfieldWidget.actualtext)) {
            TextfieldWidget textfieldWidget2 = this;
            textfieldWidget2.caret = textfieldWidget2.retlength(textfieldWidget2.actualtext);
            this.position = 0;
        }
        this.repaintExt();
        return true;
    }

    public final boolean traverse(int n2, int n3, int n4, int[] nArray) {
        if (!this.enable) {
            return false;
        }
        if (this.selectmode) {
            vk.traverse(n2, n3, n4, nArray);
            this.repaintExt();
            return true;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = this.prefwidth;
        nArray[3] = this.prefheight;
        this.prevkey = 0;
        switch (n2) {
            case 0: {
                this.focus = true;
                this.modified = false;
                break;
            }
            case 5: {
                ++this.caret;
                TextfieldWidget textfieldWidget = this;
                if (this.caret > textfieldWidget.retlength(textfieldWidget.actualtext)) {
                    TextfieldWidget textfieldWidget2 = this;
                    textfieldWidget2.caret = textfieldWidget2.retlength(textfieldWidget2.actualtext);
                    if (this.lines > 1 && this.currentline != this.maxlines - 1) {
                        this.caret = 0;
                        this.computeline(6);
                    }
                }
                this.repaintExt();
                return true;
            }
            case 2: {
                --this.caret;
                if (this.caret < 0) {
                    this.caret = 0;
                    if (this.currentline == 0) {
                        return false;
                    }
                    if (this.lines > 1 && this.currentline > 0) {
                        this.computeline(1);
                        TextfieldWidget textfieldWidget = this;
                        textfieldWidget.caret = textfieldWidget.retlength(textfieldWidget.displaytext);
                    }
                }
                this.repaintExt();
                return true;
            }
            case 1: 
            case 6: {
                if (this.computeline(n2)) {
                    return this.focus;
                }
                this.focus = !this.focus;
                this.repaintExt();
                return this.focus;
            }
        }
        return this.focus;
    }
}

