/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rtk;

import com.ibm.rtk.CustomWidget;
import com.ibm.rtk.Toolkit;
import com.ibm.rtk.ValueListener;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ScrollbarWidget
extends CustomWidget {
    public int position = 0;
    private static Image hlarrow = null;
    private static Image hrarrow;
    private static Image thumb;
    private static Image vthumb;
    private static Image vlarrow;
    private static Image vrarrow;
    private static int prevx;
    private static int prevy;
    static int linecolor;
    int type = 1;
    int prefwidth = 50;
    int prefheight = 12;
    boolean focus = false;
    int thumbstart = 0;
    int thumbwidth = 0;
    int area;
    int increment;
    int viewarea;
    final int arrowarea;
    ValueListener vc = null;
    private boolean traversal;

    public ScrollbarWidget(int n2, boolean bl) {
        super(null);
        this.arrowarea = 10;
        this.traversal = bl;
        if (hlarrow == null) {
            try {
                hlarrow = Toolkit.createImage("/rtkblarrow.png");
                hrarrow = Toolkit.createImage("/rtkbrarrow.png");
                thumb = Toolkit.createImage("/rtkthumb.png");
                vthumb = Toolkit.createImage("/rtkvthumb.png");
                vlarrow = Toolkit.createImage("/rtkbdarrow.png");
                vrarrow = Toolkit.createImage("/rtkbuarrow.png");
            }
            catch (Exception exception) {
                hlarrow = null;
                System.out.println(exception);
            }
        }
        this.type = n2;
        if (n2 == 0) {
            this.width = 12;
            this.height = 50;
        }
        this.setValues(500, 10, 0);
        this.move(0);
    }

    public final void setListener(ValueListener valueListener) {
        this.vc = valueListener;
    }

    public final void setValues(int n2, int n3, int n4) {
        int n5 = 13;
        int n6 = this.prefheight;
        this.viewarea = n2;
        this.position = n4;
        this.increment = n3;
        this.area = this.type == 1 ? n2 - this.prefwidth : n2 - this.prefheight;
        this.thumbwidth = 0;
        if (this.area < 0) {
            this.area = 0;
            return;
        }
        if (this.type == 1) {
            int n7 = this.prefwidth - n5 - n5;
            this.thumbwidth = this.prefwidth * n7 / n2;
        } else {
            int n8 = this.prefheight - n5 - n5;
            this.thumbwidth = this.prefheight * n8 / n2;
        }
        if (this.thumbwidth < 5) {
            this.thumbwidth = 5;
        }
        this.move(0);
    }

    private final void move(int n2) {
        int n3 = 13;
        if (this.area == 0) {
            return;
        }
        int n4 = this.type == 1 ? this.prefwidth - n3 - n3 - this.thumbwidth : this.prefheight - n3 - n3 - this.thumbwidth;
        this.position += n2;
        if (this.position > this.area) {
            this.position = this.area;
        }
        if (this.position < 0) {
            this.position = 0;
        }
        if (n2 != 0 && this.vc != null) {
            this.vc.valueNotify(this.position, (Object)this);
        }
        this.thumbstart = this.position * n4 / this.area;
        if (n2 != 0) {
            this.serviceRepaint();
        }
    }

    public final void paint(Graphics graphics, int n2, int n3) {
        int n4 = 13 + this.thumbstart;
        if (this.type == 1) {
            graphics.setColor(linecolor);
            graphics.drawLine(10, 4, this.prefwidth - 11, 4);
            graphics.drawImage(hlarrow, 0, 0, 20);
            graphics.drawImage(hrarrow, this.prefwidth - 9, 0, 20);
            if (this.thumbwidth == 0) {
                return;
            }
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(n4, 1, this.thumbwidth, 6);
            graphics.setColor(linecolor);
            graphics.drawRect(n4, 1, this.thumbwidth, 6);
            graphics.setClip(n4, 1, this.thumbwidth, 6);
            for (int i2 = 0; i2 < this.thumbwidth / thumb.getWidth() + 1; ++i2) {
                graphics.drawImage(thumb, n4 + i2 * thumb.getWidth(), 2, 20);
            }
            return;
        }
        graphics.setColor(linecolor);
        graphics.setColor(linecolor);
        graphics.drawLine(4, 10, 4, this.prefheight - 11);
        graphics.drawImage(vrarrow, 0, 0, 20);
        graphics.drawImage(vlarrow, 0, this.prefheight - 9, 20);
        if (this.thumbwidth == 0) {
            return;
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(1, n4, 6, this.thumbwidth);
        graphics.setClip(1, n4, 7, this.thumbwidth + 1);
        for (int i3 = 0; i3 < this.thumbwidth / vthumb.getHeight() + 1; ++i3) {
            graphics.drawImage(vthumb, 2, n4 + i3 * vthumb.getHeight(), 20);
        }
        graphics.setColor(linecolor);
        graphics.drawRect(1, n4, 6, this.thumbwidth);
    }

    public final int getMinContentHeight() {
        if (this.type == 1) {
            return 9;
        }
        return 20;
    }

    public final int getMinContentWidth() {
        if (this.type == 0) {
            return 9;
        }
        return 20;
    }

    public final int getPrefContentHeight(int n2) {
        if (this.type == 1) {
            return 10;
        }
        if (n2 != -1) {
            this.prefheight = n2;
        }
        return this.prefheight;
    }

    public final int getPrefContentWidth(int n2) {
        if (this.type == 0) {
            return 10;
        }
        if (n2 != -1) {
            this.prefwidth = n2;
        }
        return this.prefwidth;
    }

    public final void sizeChanged(int n2, int n3) {
        if (this.type == 0) {
            this.prefheight = n3;
        } else {
            this.prefwidth = n2;
        }
        ScrollbarWidget scrollbarWidget = this;
        scrollbarWidget.setValues(scrollbarWidget.viewarea, this.increment, this.position);
    }

    public final void pointerPressed(int n2, int n3) {
        int n4 = n3;
        int n5 = this.prefheight;
        prevx = n2;
        prevy = n3;
        if (this.type == 1) {
            n5 = this.prefwidth;
            n4 = n2;
        }
        if (n4 < 12) {
            ScrollbarWidget scrollbarWidget = this;
            scrollbarWidget.move(-scrollbarWidget.increment);
            return;
        }
        if (n4 < this.thumbstart + 12) {
            this.move(-(n5 - this.increment));
            return;
        }
        if (n4 > n5 - 12) {
            ScrollbarWidget scrollbarWidget = this;
            scrollbarWidget.move(scrollbarWidget.increment);
        } else if (n4 > this.thumbstart + this.thumbwidth + 12) {
            this.move(n5 - this.increment);
            return;
        }
    }

    public final void pointerDragged(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 13;
        if (this.type == 1) {
            n5 = this.prefwidth - n6 - n6 - this.thumbwidth;
            n4 = n2 - prevx;
        } else {
            n5 = this.prefheight - n6 - n6 - this.thumbwidth;
            n4 = n3 - prevy;
        }
        prevy = n3;
        prevx = n2;
        if (n5 != 0) {
            this.move(n4 * this.area / n5);
        }
    }

    public final void traverseOut() {
        this.focus = false;
    }

    protected final boolean traverse(int n2, int n3, int n4, int[] nArray) {
        if (!this.traversal) {
            return false;
        }
        if (this.type == 1) {
            switch (n2) {
                case 0: {
                    this.focus = true;
                    return true;
                }
                case 2: {
                    ScrollbarWidget scrollbarWidget = this;
                    scrollbarWidget.move(-scrollbarWidget.increment);
                    return true;
                }
                case 5: {
                    ScrollbarWidget scrollbarWidget = this;
                    scrollbarWidget.move(scrollbarWidget.increment);
                    return true;
                }
                case 1: 
                case 6: {
                    this.focus = !this.focus;
                    this.repaintExt();
                    nArray[0] = 0;
                    nArray[1] = 0;
                    nArray[2] = this.prefwidth;
                    nArray[3] = this.prefheight;
                    return this.focus;
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    this.focus = true;
                    return true;
                }
                case 1: {
                    ScrollbarWidget scrollbarWidget = this;
                    scrollbarWidget.move(-scrollbarWidget.increment);
                    return true;
                }
                case 6: {
                    ScrollbarWidget scrollbarWidget = this;
                    scrollbarWidget.move(scrollbarWidget.increment);
                    return true;
                }
                case 2: 
                case 5: {
                    this.focus = !this.focus;
                    this.repaintExt();
                    nArray[0] = 0;
                    nArray[1] = 0;
                    nArray[2] = this.prefwidth;
                    nArray[3] = this.prefheight;
                    return this.focus;
                }
            }
        }
        return false;
    }

    static {
        linecolor = 7249347;
    }
}

