/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.Mqtt;
import com.ibm.mqtt.MqttBaseClient;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttTimedEvent;

public final class MqttRetry
implements MqttTimedEvent {
    private MqttPacket packet;
    private MqttBaseClient sessionRef;
    protected long expires;

    public MqttRetry(MqttBaseClient mqttBaseClient, MqttPacket mqttPacket, long l2) {
        this.packet = mqttPacket;
        this.sessionRef = mqttBaseClient;
        this.expires = System.currentTimeMillis() + l2;
    }

    protected final void setMessage(MqttPacket mqttPacket) {
        this.packet = mqttPacket;
    }

    public final int getMsgId() {
        return this.packet.getMsgId();
    }

    public final int getQoS() {
        return this.packet.getQos();
    }

    public final int getMsgType() {
        return this.packet.getMsgType();
    }

    public final long getTime() {
        return this.expires;
    }

    public final boolean notifyEvent() throws Exception {
        if (this.outstanding()) {
            if (this.sessionRef.isConnected()) {
                this.sessionRef.writePacket(this.packet);
                MQeTrace.trace(this, (short)-30031, 0x200000L, Mqtt.msgTypes[this.packet.getMsgType()], new Integer(this.packet.getMsgId()));
            }
            this.expires = this.packet.getMsgType() == 12 ? System.currentTimeMillis() + (long)(this.sessionRef.getKeepAlivePeriod() * 1000) : System.currentTimeMillis() + (long)(this.sessionRef.getRetry() * 1000);
            return true;
        }
        return false;
    }

    public final synchronized boolean outstanding() {
        return this.sessionRef.outstanding(this.packet.getMsgId());
    }

    public final String toString() {
        return "[" + Mqtt.msgTypes[this.packet.getMsgType()] + " MsgId:" + this.packet.getMsgId() + " Expires:" + this.getTime() + "]";
    }
}

