/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;

public final class MqttPublish
extends MqttPacket {
    public String topicName;

    public MqttPublish() {
        this.setMsgType((short)3);
    }

    public MqttPublish(byte[] byArray, int n2) {
        super(byArray);
        this.setMsgType((short)3);
        this.topicName = MqttUtils.UTFToString(byArray, n2);
        if (this.getQos() > 0) {
            this.setMsgId(MqttUtils.toShort(byArray, n2 + this.topicName.length() + 2));
            this.setPayload(MqttUtils.SliceByteArray(byArray, n2 + this.topicName.length() + 4, byArray.length - (n2 + this.topicName.length() + 4)));
        } else {
            this.setPayload(MqttUtils.SliceByteArray(byArray, n2 + this.topicName.length() + 2, byArray.length - (n2 + this.topicName.length() + 2)));
        }
    }

    public final void compressTopic() {
    }

    public final void process(MqttProcessor mqttProcessor) {
        if (mqttProcessor.supportTopicNameCompression()) {
            this.uncompressTopic();
        }
        mqttProcessor.process(this);
    }

    public final byte[] toBytes() {
        byte[] byArray = MqttUtils.StringToUTF(this.topicName);
        this.message = this.getQos() > 0 ? new byte[byArray.length + 3] : new byte[byArray.length + 1];
        int n2 = 0;
        this.message[n2++] = super.toBytes()[0];
        System.arraycopy(byArray, 0, this.message, n2, byArray.length);
        n2 += byArray.length;
        if (this.getQos() > 0) {
            int n3 = this.getMsgId();
            this.message[n2++] = (byte)(n3 / 256);
            this.message[n2++] = (byte)(n3 % 256);
        }
        this.createMsgLength();
        return this.message;
    }

    private final void uncompressTopic() {
    }
}

