/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttProcessor;

public abstract class MqttPacket {
    protected byte[] message;
    private short msgType;
    private int msgLength;
    private int msgId = 0;
    private boolean retain;
    private boolean dup;
    private int qos;
    private byte[] payload = null;

    public MqttPacket() {
    }

    public MqttPacket(byte[] byArray) {
        byte by = byArray[0];
        this.msgType = MqttPacket.getMsgType(by);
        this.retain = (by & 1) != 0;
        this.dup = (by >>> 3 & 1) != 0;
        this.qos = by >>> 1 & 3;
    }

    protected static short getMsgType(byte by) {
        return (short)(by >>> 4 & 0xF);
    }

    protected final void createMsgLength() {
        int n2 = this.message.length + -1;
        if (this.payload != null) {
            n2 += this.payload.length;
        }
        this.msgLength = n2;
        int n3 = 0;
        byte[] byArray = new byte[4];
        do {
            int n4 = n2 % 128;
            if ((n2 /= 128) > 0) {
                n4 |= 0x80;
            }
            byArray[n3++] = (byte)n4;
        } while (n2 > 0);
        byte[] byArray2 = new byte[this.message.length + n3];
        byte[] byArray3 = byArray2;
        byArray2[0] = this.message[0];
        System.arraycopy(byArray, 0, byArray3, 1, n3);
        System.arraycopy(this.message, 1, byArray3, n3 + 1, this.message.length - 1);
        this.message = byArray3;
    }

    public abstract void process(MqttProcessor var1);

    public byte[] toBytes() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = (byte)(this.msgType << 4 & 0xF0);
        if (this.msgType == 8 | this.msgType == 9 | this.msgType == 10 | this.msgType == 11) {
            this.qos = 1;
        }
        byte by = (byte)((this.qos & 3) << 1);
        byte by2 = (byte)(this.dup ? 8 : 0);
        byte by3 = (byte)(this.retain ? 1 : 0);
        byArray2[0] = (byte)(byArray2[0] | by | by3 | by2);
        return byArray2;
    }

    public final byte[] getPayload() {
        return this.payload;
    }

    public final void setPayload(byte[] byArray) {
        this.payload = byArray;
    }

    public final void setDup(boolean bl) {
        this.dup = bl;
    }

    public final int getMsgId() {
        return this.msgId;
    }

    public final void setMsgId(int n2) {
        this.msgId = n2;
    }

    public final short getMsgType() {
        return this.msgType;
    }

    public final void setMsgType(short s2) {
        this.msgType = s2;
    }

    public final int getQos() {
        return this.qos;
    }

    public final void setQos(int n2) {
        this.qos = n2;
    }

    public final boolean isRetain() {
        return this.retain;
    }

    public final void setRetain(boolean bl) {
        this.retain = bl;
    }
}

