/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttListItem;

public final class MqttHashTable {
    private static int m_init_capacity;
    public int m_capacity;
    private int m_ceiling;
    private int size = 0;
    public MqttListItem[] hashTable;
    private MqttListItem recycle_bin;
    private int recycle_length = 0;

    public MqttHashTable() {
        this(101);
    }

    public MqttHashTable(int n2) {
        m_init_capacity = this.m_capacity = this.findPower(n2);
        this.m_ceiling = this.m_capacity * 3 / 4;
        this.hashTable = new MqttListItem[this.m_capacity];
    }

    public final void clear() {
        int n2 = 0;
        while (n2 < this.m_capacity) {
            this.hashTable[n2] = null;
            ++n2;
        }
        this.size = 0;
    }

    public final boolean containsKey(long l2) {
        return this.get(l2) != null;
    }

    private final int findPower(int n2) {
        int n3 = 2;
        while ((n3 <<= 1) < n2) {
        }
        return n3;
    }

    public final Object get(long l2) {
        int n2 = (int)((l2 >>> 32 ^ l2) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = this.hashTable[n2];
        mqttListItem = this.hashTable[n2];
        while (mqttListItem != null) {
            if (mqttListItem.keysMatch(l2)) {
                return mqttListItem.data;
            }
            mqttListItem = mqttListItem.next;
        }
        return null;
    }

    public final Object put(long l2, Object object) {
        if (this.size > this.m_ceiling) {
            int n2 = this.m_capacity;
            this.m_capacity <<= 1;
            this.m_ceiling = this.m_capacity * 3 / 4;
            this.rehash(n2);
            return this.put(l2, object);
        }
        int n3 = (int)((l2 >>> 32 ^ l2) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = this.hashTable[n3];
        if (mqttListItem == null) {
            this.hashTable[n3] = this.recycleCreate(l2, null, object);
            ++this.size;
            return null;
        }
        MqttListItem mqttListItem2 = mqttListItem;
        while (mqttListItem2 != null) {
            if (mqttListItem2.keysMatch(l2)) {
                Object object2 = mqttListItem2.data;
                mqttListItem2.data = object;
                return object2;
            }
            mqttListItem2 = mqttListItem2.next;
        }
        this.hashTable[n3] = this.recycleCreate(l2, mqttListItem, object);
        ++this.size;
        return null;
    }

    private final MqttListItem recycleCreate(long l2, MqttListItem mqttListItem, Object object) {
        if (this.recycle_bin != null) {
            MqttListItem mqttListItem2 = this.recycle_bin;
            this.recycle_bin = this.recycle_bin.next;
            --this.recycle_length;
            mqttListItem2.key = l2;
            mqttListItem2.next = mqttListItem;
            mqttListItem2.data = object;
            return mqttListItem2;
        }
        return new MqttListItem(l2, mqttListItem, object);
    }

    private final void rehash(int n2) {
        MqttListItem[] mqttListItemArray = this.hashTable;
        MqttListItem[] mqttListItemArray2 = new MqttListItem[this.m_capacity];
        this.hashTable = mqttListItemArray2;
        int n3 = 0;
        while (n3 < n2) {
            MqttListItem mqttListItem = mqttListItemArray[n3];
            while (mqttListItem != null) {
                MqttListItem mqttListItem2 = mqttListItem;
                mqttListItem = mqttListItem.next;
                long l2 = mqttListItem2.key;
                int n4 = (int)((l2 >>> 32 ^ l2) & (long)(this.m_capacity - 1));
                mqttListItem2.next = mqttListItemArray2[n4];
                mqttListItemArray2[n4] = mqttListItem2;
            }
            ++n3;
        }
    }

    public final Object remove(long l2) {
        if (this.size < this.m_ceiling / 4 && this.size >= m_init_capacity << 1) {
            int n2 = this.m_capacity;
            this.m_capacity >>= 1;
            this.m_ceiling = this.m_capacity * 3 / 4;
            this.rehash(n2);
            return this.remove(l2);
        }
        int n3 = (int)((l2 >>> 32 ^ l2) & (long)(this.m_capacity - 1));
        MqttListItem mqttListItem = null;
        MqttListItem mqttListItem2 = this.hashTable[n3];
        while (mqttListItem2 != null) {
            if (mqttListItem2.keysMatch(l2)) {
                if (mqttListItem == null) {
                    this.hashTable[n3] = mqttListItem2.next;
                } else {
                    mqttListItem.next = mqttListItem2.next;
                }
                --this.size;
                if (this.recycle_length < this.size / 8) {
                    mqttListItem2.next = this.recycle_bin;
                    this.recycle_bin = mqttListItem2;
                    ++this.recycle_length;
                }
                return mqttListItem2.data;
            }
            mqttListItem = mqttListItem2;
            mqttListItem2 = mqttListItem2.next;
        }
        return null;
    }

    public final int size() {
        return this.size;
    }
}

