/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.Mqtt;
import com.ibm.mqtt.MqttByteArray;
import com.ibm.mqtt.MqttConnack;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttHashTable;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttPingreq;
import com.ibm.mqtt.MqttPuback;
import com.ibm.mqtt.MqttPubcomp;
import com.ibm.mqtt.MqttPublish;
import com.ibm.mqtt.MqttPubrec;
import com.ibm.mqtt.MqttPubrel;
import com.ibm.mqtt.MqttReconn;
import com.ibm.mqtt.MqttRetry;
import com.ibm.mqtt.MqttSuback;
import com.ibm.mqtt.MqttSubscribe;
import com.ibm.mqtt.MqttTimedEvent;
import com.ibm.mqtt.MqttTimedEventQueue;
import com.ibm.mqtt.MqttUnsuback;
import com.ibm.mqtt.MqttUnsubscribe;
import java.util.Hashtable;
import java.util.Vector;

public abstract class MqttBaseClient
extends Mqtt
implements Runnable {
    private MqttHashTable outstandingQueue = null;
    private int retryPeriod;
    private boolean cleanSession = false;
    private Hashtable qos2PubsArrived = new Hashtable();
    private MqttPersistence persistenceLayer = null;
    private Object readerControl = new Object();
    private MqttTimedEventQueue retryQueue = null;
    private Hashtable grantedQoS = new Hashtable();
    private boolean terminated = false;
    private static int maxOutstanding = 10;
    private boolean outLockNotified = false;
    private Object outLock = new Object();

    protected MqttBaseClient() {
    }

    protected final void initialise(String string, MqttPersistence mqttPersistence, Class clazz) {
        super.initialise(string, clazz);
        this.retryPeriod = 10000;
        this.outstandingQueue = new MqttHashTable();
        this.retryQueue = new MqttTimedEventQueue(10, this);
        this.retryQueue.start();
        this.persistenceLayer = mqttPersistence;
    }

    protected abstract void notifyAck(int var1, int var2);

    protected abstract void publishArrived(String var1, byte[] var2, int var3, boolean var4) throws Exception;

    public final void anyErrors() throws MqttException {
        if (this.registeredException != null) {
            throw this.registeredException;
        }
    }

    protected final void connect(String string, boolean bl, boolean bl2, short s2, String string2, int n2, String string3, boolean bl3) throws MqttException, MqttPersistenceException {
        Object object = this.outLock;
        synchronized (object) {
            this.outLockNotified = false;
        }
        object = new MqttConnect();
        ((MqttConnect)object).setClientId(string);
        ((MqttConnect)object).CleanStart = bl;
        ((MqttConnect)object).TopicNameCompression = bl2;
        ((MqttConnect)object).KeepAlive = s2;
        if (string2 != null) {
            ((MqttConnect)object).Will = true;
            ((MqttConnect)object).WillTopic = string2;
            ((MqttConnect)object).WillQoS = n2;
            ((MqttConnect)object).WillRetain = bl3;
            ((MqttConnect)object).WillMessage = string3;
        } else {
            ((MqttConnect)object).Will = false;
        }
        this.setKeepAlive(s2);
        this.doConnect((MqttConnect)object, bl, s2);
    }

    private final void doConnect(MqttConnect mqttConnect, boolean bl, short s2) throws MqttException, MqttPersistenceException {
        Object object;
        Object object2;
        this.retryQueue.resetTimedEventQueue();
        this.outstandingQueue.clear();
        this.qos2PubsArrived.clear();
        this.initialiseOutMsgIds(null);
        if (this.persistenceLayer != null && !this.isConnectionLost()) {
            this.persistenceLayer.open(mqttConnect.getClientId(), this.connection);
        }
        if (bl) {
            this.cleanSession = true;
            if (this.persistenceLayer != null) {
                this.persistenceLayer.reset();
            }
        }
        if (s2 > 0) {
            object2 = new MqttRetry(this, new MqttPingreq(), s2 * 1000);
            object = this.outstandingQueue;
            synchronized (object) {
                this.outstandingQueue.put(0L, object2);
            }
            this.retryQueue.enqueue((MqttTimedEvent)object2);
        }
        if (!bl && this.persistenceLayer != null && !this.isConnectionLost()) {
            Object object3;
            Object object4;
            int n2;
            int n3;
            Object object5;
            int n4;
            byte[][] byArray = this.persistenceLayer.getAllSentMessages();
            object2 = byArray;
            if (byArray != null) {
                object = new Vector();
                n4 = 0;
                while (n4 < ((Object)object2).length) {
                    Object object6;
                    object5 = object2[n4];
                    n3 = 1;
                    n2 = 1;
                    do {
                        object4 = object5[n3];
                        ++n3;
                        ++n2;
                    } while ((object4 & 0x80) != 0);
                    if (MqttPacket.getMsgType((byte)object5[0]) == 3) {
                        object6 = new MqttPublish((byte[])object5, n2);
                        ((Vector)object).addElement(new Integer(((MqttPacket)object6).getMsgId()));
                        object3 = new MqttRetry(this, (MqttPacket)object6, this.retryPeriod);
                    } else {
                        object6 = new MqttPubrel((byte[])object5, n2);
                        ((Vector)object).addElement(new Integer(((MqttPacket)object6).getMsgId()));
                        object3 = new MqttRetry(this, (MqttPacket)object6, this.retryPeriod);
                    }
                    object6 = this.outstandingQueue;
                    synchronized (object6) {
                        this.outstandingQueue.put(((MqttRetry)object3).getMsgId(), object3);
                    }
                    this.retryQueue.enqueue((MqttTimedEvent)object3);
                    ++n4;
                }
                this.initialiseOutMsgIds((Vector)object);
            }
            byte[][] byArray2 = this.persistenceLayer.getAllReceivedMessages();
            object = byArray2;
            if (byArray2 != null) {
                n4 = 0;
                while (n4 < ((Object)object).length) {
                    object5 = object[n4];
                    n3 = 1;
                    n2 = 1;
                    do {
                        object4 = object5[n3];
                        ++n3;
                        ++n2;
                    } while ((object4 & 0x80) != 0);
                    object3 = new MqttPublish((byte[])object5, n2);
                    this.qos2PubsArrived.put(Integer.toString(((MqttPacket)object3).getMsgId()), object3);
                    ++n4;
                }
            }
        }
        this.registeredException = null;
        this.setConnectionLost(false);
        try {
            object2 = this.readerControl;
            synchronized (object2) {
                this.tcpipConnect(mqttConnect);
                this.readerControl.notify();
            }
        }
        catch (MqttException mqttException) {
            object2 = mqttException;
            throw mqttException;
        }
        catch (Exception exception) {
            object = new MqttException();
            ((MqttException)object).initCause(exception);
            throw object;
        }
    }

    protected void connectionLost() throws Exception {
        Object object = this.outLock;
        synchronized (object) {
            this.outLockNotified = true;
            this.outLock.notifyAll();
        }
    }

    protected final synchronized void setConnectionState(boolean bl) {
        super.setConnectionState(bl);
        this.retryQueue.canDeliverEvents(bl);
    }

    public final int getRetry() {
        return this.retryPeriod / 1000;
    }

    protected final byte[] getReturnedQoS(int n2) {
        MqttByteArray mqttByteArray = (MqttByteArray)this.grantedQoS.remove(new Integer(n2));
        return mqttByteArray == null ? null : mqttByteArray.getByteArray();
    }

    private final MqttPacket messageAck(int n2) {
        block18: {
            MqttRetry mqttRetry = null;
            mqttRetry = (MqttRetry)this.outstandingQueue.get(n2);
            if (mqttRetry == null) {
                return null;
            }
            if (mqttRetry.getQoS() == 2 && mqttRetry.getMsgType() == 3) {
                return this.messageAckQoS2(n2);
            }
            try {
                Object object;
                if (this.persistenceLayer != null) {
                    object = this.persistenceLayer;
                    synchronized (object) {
                        this.persistenceLayer.delSentMessage(n2);
                    }
                }
                object = this.outstandingQueue;
                synchronized (object) {
                    mqttRetry = (MqttRetry)this.outstandingQueue.remove(n2);
                }
                this.releaseMsgId(n2);
                if (mqttRetry == null) break block18;
                int n3 = mqttRetry.getMsgType();
                switch (n3) {
                    case 3: 
                    case 6: 
                    case 8: 
                    case 10: {
                        if (this.outstandingQueue.size() == maxOutstanding - 1) {
                            Object object2 = this.outLock;
                            synchronized (object2) {
                                this.outLockNotified = true;
                                this.outLock.notifyAll();
                            }
                        }
                        this.notifyAck(n3, n2);
                    }
                }
            }
            catch (MqttPersistenceException mqttPersistenceException) {}
        }
        return null;
    }

    private final MqttPacket messageAckQoS2(int n2) {
        MqttRetry mqttRetry = null;
        MqttPubrel mqttPubrel = null;
        mqttPubrel = this.genPubRelPacket(n2, false);
        try {
            Object object;
            if (this.persistenceLayer != null) {
                object = this.persistenceLayer;
                synchronized (object) {
                    this.persistenceLayer.updSentMessage(n2, ((MqttPacket)mqttPubrel).toBytes());
                }
            }
            object = this.outstandingQueue;
            synchronized (object) {
                mqttRetry = (MqttRetry)this.outstandingQueue.remove(n2);
                if (mqttRetry != null) {
                    mqttRetry.setMessage(mqttPubrel);
                    this.outstandingQueue.put(n2, mqttRetry);
                }
            }
        }
        catch (MqttPersistenceException mqttPersistenceException) {}
        return mqttPubrel;
    }

    public final boolean outstanding(int n2) {
        boolean bl = false;
        MqttHashTable mqttHashTable = this.outstandingQueue;
        synchronized (mqttHashTable) {
            bl = this.outstandingQueue.containsKey(n2);
        }
        return bl;
    }

    public final void process(MqttConnack mqttConnack) {
        MQeTrace.trace(this, (short)-30017, 0x200000L, new Integer(mqttConnack.returnCode));
        super.process(mqttConnack);
        this.notifyAck(1, mqttConnack.returnCode);
    }

    public final void process(MqttPuback mqttPuback) {
        MQeTrace.trace(this, (short)-30018, 0x200000L, new Integer(mqttPuback.getMsgId()));
        this.messageAck(mqttPuback.getMsgId());
    }

    public final void process(MqttPubcomp mqttPubcomp) {
        MQeTrace.trace(this, (short)-30019, 0x200000L, new Integer(mqttPubcomp.getMsgId()));
        this.messageAck(mqttPubcomp.getMsgId());
    }

    public final void process(MqttPublish mqttPublish) {
        boolean bl = false;
        MQeTrace.trace(this, (short)-30020, 0x200000L, new Integer(mqttPublish.getMsgId()), new Integer(mqttPublish.getQos()), new Boolean(mqttPublish.isRetain()));
        if (mqttPublish.getQos() != 2) {
            try {
                this.publishArrived(mqttPublish.topicName, mqttPublish.getPayload(), mqttPublish.getQos(), mqttPublish.isRetain());
            }
            catch (Exception exception) {
                bl = true;
                System.out.println("publishArrived Exception caught (QoS " + mqttPublish.getQos() + "):");
                exception.printStackTrace();
            }
        }
        if (mqttPublish.getQos() > 0 && !bl) {
            MQeTrace.trace(this, (short)-30021, 0x200000L, mqttPublish.getQos() == 1 ? "PUBACK" : "PUBREC", new Integer(mqttPublish.getMsgId()));
            if (mqttPublish.getQos() == 1) {
                MqttPuback mqttPuback = new MqttPuback();
                mqttPuback.setMsgId(mqttPublish.getMsgId());
                try {
                    this.writePacket(mqttPuback);
                }
                catch (Exception exception) {}
            } else {
                try {
                    Object object;
                    if (this.persistenceLayer != null) {
                        try {
                            object = this.persistenceLayer;
                            synchronized (object) {
                                this.persistenceLayer.addReceivedMessage(mqttPublish.getMsgId(), mqttPublish.toBytes());
                            }
                        }
                        catch (MqttPersistenceException mqttPersistenceException) {
                            MqttPersistenceException mqttPersistenceException2 = mqttPersistenceException;
                            throw mqttPersistenceException;
                        }
                        catch (Exception exception) {
                            throw new MqttPersistenceException("process(MqttPublish) - packet.toBytes() failed - msgid " + mqttPublish.getMsgId());
                        }
                    }
                    this.qos2PubsArrived.put(Integer.toString(mqttPublish.getMsgId()), mqttPublish);
                    object = new MqttPubrec();
                    ((MqttPacket)object).setMsgId(mqttPublish.getMsgId());
                    try {
                        this.writePacket((MqttPacket)object);
                    }
                    catch (Exception exception) {}
                }
                catch (MqttPersistenceException mqttPersistenceException) {}
            }
        }
    }

    public final void process(MqttPubrec mqttPubrec) {
        MQeTrace.trace(this, (short)-30022, 0x200000L, new Integer(mqttPubrec.getMsgId()));
        MqttPacket mqttPacket = this.messageAck(mqttPubrec.getMsgId());
        if (mqttPacket != null) {
            try {
                this.writePacket(mqttPacket);
            }
            catch (Exception exception) {}
        }
    }

    public final void process(MqttPubrel mqttPubrel) {
        boolean bl = false;
        MQeTrace.trace(this, (short)-30023, 0x200000L, new Integer(mqttPubrel.getMsgId()));
        MqttPublish mqttPublish = (MqttPublish)this.qos2PubsArrived.get(Integer.toString(mqttPubrel.getMsgId()));
        if (mqttPublish != null) {
            try {
                this.publishArrived(mqttPublish.topicName, mqttPublish.getPayload(), mqttPublish.getQos(), mqttPublish.isRetain());
            }
            catch (Exception exception) {
                bl = true;
                System.out.println("publishArrived Exception caught (QoS 2):");
                exception.printStackTrace();
            }
        }
        if (!bl) {
            Object object;
            MqttPersistenceException mqttPersistenceException;
            block12: {
                this.qos2PubsArrived.remove(Integer.toString(mqttPubrel.getMsgId()));
                mqttPersistenceException = null;
                try {
                    if (this.persistenceLayer == null) break block12;
                    object = this.persistenceLayer;
                    synchronized (object) {
                        this.persistenceLayer.delReceivedMessage(mqttPubrel.getMsgId());
                    }
                }
                catch (MqttPersistenceException mqttPersistenceException2) {
                    object = mqttPersistenceException2;
                    mqttPersistenceException = mqttPersistenceException2;
                }
            }
            object = new MqttPubcomp();
            ((MqttPacket)object).setMsgId(mqttPubrel.getMsgId());
            try {
                this.writePacket((MqttPacket)object);
            }
            catch (Exception exception) {}
            if (mqttPersistenceException != null) {
                this.setRegisteredThrowable(mqttPersistenceException);
            }
        }
    }

    public final void process(MqttSuback mqttSuback) {
        MQeTrace.trace(this, (short)-30024, 0x200000L, new Integer(mqttSuback.getMsgId()));
        this.grantedQoS.put(new Integer(mqttSuback.getMsgId()), new MqttByteArray(mqttSuback.TopicsQoS));
        this.messageAck(mqttSuback.getMsgId());
    }

    public final void process(MqttUnsuback mqttUnsuback) {
        MQeTrace.trace(this, (short)-30025, 0x200000L, new Integer(mqttUnsuback.getMsgId()));
        this.messageAck(mqttUnsuback.getMsgId());
    }

    protected int publish(String string, byte[] byArray, int n2, boolean bl) throws MqttException, MqttPersistenceException {
        int n3 = 0;
        if (n2 > 0) {
            n3 = this.nextMsgId();
        }
        MqttPublish mqttPublish = this.genPublishPacket(n3, n2, string, byArray, bl, false);
        this.sendPacket(mqttPublish);
        MQeTrace.trace(this, (short)-30026, 0x200000L, new Integer(n3), new Integer(n2), new Boolean(bl));
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        MQeTrace.trace(this, (short)-30027, 0x200000L);
        Object object = this.readerControl;
        synchronized (object) {
            while (!this.isSocketConnected() && !this.terminated) {
                try {
                    this.readerControl.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.terminated) {
            block22: while (!this.terminated) {
                block28: {
                    try {
                        this.process();
                    }
                    catch (Exception exception) {
                        object = this.readerControl;
                        synchronized (object) {
                            this.tcpipDisconnect(true);
                            this.readerControl.notify();
                        }
                        if (!this.isConnected()) break block28;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.setRegisteredThrowable(null);
                        System.out.println("WMQtt client:Lost connection...");
                        new MqttReconn(this).start();
                    }
                    catch (Throwable throwable) {
                        Object object2 = this.readerControl;
                        synchronized (object2) {
                            this.tcpipDisconnect(true);
                            this.readerControl.notify();
                        }
                        this.setRegisteredThrowable(throwable);
                    }
                }
                object = this.readerControl;
                synchronized (object) {
                    while (true) {
                        if (this.isSocketConnected() || this.terminated) {
                            continue block22;
                        }
                        try {
                            this.readerControl.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        MQeTrace.trace(this, (short)-30028, 0x200000L);
    }

    public final void setRetry(int n2) {
        if (n2 < 10) {
            n2 = 10;
        }
        this.retryPeriod = Math.abs(n2 * 1000);
    }

    protected int subscribe(String[] stringArray, int[] nArray) throws MqttException {
        int n2 = this.nextMsgId();
        byte[] byArray = new byte[nArray.length];
        this.grantedQoS.remove(new Integer(n2));
        int n3 = 0;
        while (n3 < nArray.length) {
            byArray[n3] = (byte)nArray[n3];
            ++n3;
        }
        MqttSubscribe mqttSubscribe = new MqttSubscribe();
        mqttSubscribe.setMsgId(n2);
        mqttSubscribe.setQos(1);
        mqttSubscribe.topics = stringArray;
        mqttSubscribe.topicsQoS = byArray;
        mqttSubscribe.setDup(false);
        MQeTrace.trace(this, (short)-30029, 0x200000L, new Integer(n2));
        this.sendPacket(mqttSubscribe);
        return n2;
    }

    protected final MqttPubrel genPubRelPacket(int n2, boolean bl) {
        MqttPubrel mqttPubrel = new MqttPubrel();
        mqttPubrel.setMsgId(n2);
        mqttPubrel.setDup(bl);
        return mqttPubrel;
    }

    protected int unsubscribe(String[] stringArray) throws MqttException {
        int n2 = this.nextMsgId();
        MqttUnsubscribe mqttUnsubscribe = new MqttUnsubscribe();
        mqttUnsubscribe.setMsgId(n2);
        mqttUnsubscribe.setQos(1);
        mqttUnsubscribe.topics = stringArray;
        mqttUnsubscribe.setDup(false);
        MQeTrace.trace(this, (short)-30030, 0x200000L, new Integer(n2));
        this.sendPacket(mqttUnsubscribe);
        return n2;
    }

    private final void sendPacket(MqttPacket mqttPacket) throws MqttException, MqttNotConnectedException {
        long l2 = this.getRetry() * 1000;
        if (!this.isSocketConnected()) {
            throw new MqttNotConnectedException();
        }
        if (mqttPacket.getQos() > 0) {
            boolean bl;
            Object object;
            int n2 = this.outstandingQueue.size();
            if (n2 >= maxOutstanding) {
                object = this.outLock;
                synchronized (object) {
                    try {
                        if (!this.outLockNotified) {
                            this.outLock.wait();
                        }
                        if (this.isSocketConnected()) {
                            this.outLockNotified = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.isSocketConnected()) {
                    throw new MqttNotConnectedException();
                }
            }
            if (this.persistenceLayer != null) {
                try {
                    object = this.persistenceLayer;
                    synchronized (object) {
                        this.persistenceLayer.addSentMessage(mqttPacket.getMsgId(), mqttPacket.toBytes());
                    }
                }
                catch (MqttPersistenceException mqttPersistenceException) {
                    object = mqttPersistenceException;
                    throw mqttPersistenceException;
                }
                catch (Exception exception) {
                    throw new MqttPersistenceException("sendPacket - toBytes failed, msgid " + mqttPacket.getMsgId());
                }
            }
            boolean bl2 = this.getKeepAlivePeriod() > 0 ? this.outstandingQueue.size() > 1 : (bl = this.outstandingQueue.size() > 0);
            if (bl2) {
                l2 = 0L;
            }
            MqttRetry mqttRetry = new MqttRetry(this, mqttPacket, l2);
            MqttHashTable mqttHashTable = this.outstandingQueue;
            synchronized (mqttHashTable) {
                this.outstandingQueue.put(mqttPacket.getMsgId(), mqttRetry);
            }
            this.retryQueue.enqueue(mqttRetry);
            if (l2 > 0L) {
                try {
                    this.writePacket(mqttPacket);
                }
                catch (MqttException mqttException) {}
            }
        } else {
            this.writePacket(mqttPacket);
        }
    }
}

