/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.user.inbox;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.common.CommonVisualPlugin;
import com.ibm.mobile.uib.common.MessageWidget;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBMessage;
import com.ibm.mobile.uib.plugins.core.comms.messaging.mqtt.MQTTProperties;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.Composite;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.ListWidget;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public final class Inbox
extends CommonVisualPlugin {
    protected static String PLUGIN_NAME = "Inbox";
    protected String ICON_PREFERENCE = "Tab-icon";
    protected String ICON_PREFERENCE_NEW = "Tab-icon-alert";
    protected String LOGO_PREFERENCE = "Logo";
    private static Translator translator;
    protected String persInboxTopic;
    protected String inboxChannelsListTopic;
    protected Command cmdCompose;
    protected Command cmdDelete;

    public Inbox() {
        super(PLUGIN_NAME, "/images/mail.png", "/images/mail-new.png");
    }

    public final void initialise(Preferences prefs) {
        super.initialise(prefs);
        String username = this.getPreferenceMgr().getGeneralPreferences().getDefaultClientID();
        this.persInboxTopic = "UIB/msg/" + username;
        this.inboxChannelsListTopic = "UIB/inbox/channels/" + username;
    }

    protected final StandardForm initialiseDisplay() {
        StandardForm form = new StandardForm();
        translator = (Translator)PluginManager.getManager().getPlugin("Language");
        String logoName = (String)this.prefs.get(this.LOGO_PREFERENCE);
        if (logoName != null) {
            try {
                Image logo = Toolkit.createImage(logoName);
                form.setLogo(logo, 24);
            }
            catch (Exception exception) {
                Exception e2 = exception;
                exception.printStackTrace();
            }
        }
        String iconName = (String)this.prefs.get(this.ICON_PREFERENCE);
        String highlightIcon = (String)this.prefs.get(this.ICON_PREFERENCE_NEW);
        this.setIcon(iconName, null);
        this.setHighlightIcon(highlightIcon);
        form.setBackground(this.getBackgroundImage(), this.getPreferenceMgr().getGeneralPreferences().getDefaultBGColour());
        StringWidget title = this.createTitlebar(translator.getKey("inbox.title"));
        form.append(title);
        this.listWidget = new ListWidget(Style.getDefaultFont(), 1);
        this.listWidget.highlightbg = this.getPreferenceMgr().getGeneralPreferences().getDefaultHLColour();
        this.listWidget.setCriteria(1);
        Composite inboxListScroll = this.listWidget.attachScroll(false);
        FormData data = new FormData();
        new FormData().top = new FormAttachment(title);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        inboxListScroll.setLayoutData(data);
        form.append(inboxListScroll);
        this.cmdCompose = new Command(translator.getKey("inbox.new"), 1, 2);
        this.cmdDelete = new Command(translator.getKey("inbox.delete"), 8, 2);
        form.addCommand(this.cmdDelete);
        this.listWidget.setListener(this);
        form.setListener(this);
        return form;
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command != this.cmdCompose) {
            if (command == this.cmdDelete) {
                this.deleteSelMessage();
            } else {
                super.commandAction(command, displayable);
            }
        }
    }

    protected final void deleteSelMessage() {
        int selIndex = this.listWidget.selectedindex;
        if (selIndex != -1) {
            this.listWidget.insertRemove(null, selIndex);
            if (selIndex != 0) {
                this.listWidget.setHighlight(selIndex - 1);
            } else {
                this.listWidget.repaintExt();
            }
        }
    }

    public final void messageArrived(Message message) {
        String topic = message.getSource().getTopic();
        if (topic.equals(this.persInboxTopic)) {
            this.addMessage(message);
        } else if (topic.equals(this.inboxChannelsListTopic)) {
            this.subscribeToChannels(message);
        }
    }

    protected final void addMessage(Message message) {
        UIBMessage uibMsg = this.createUIBMessage(message);
        this.autoDisplayedLastAlert = false;
        if (uibMsg != null) {
            this.lastMsg = uibMsg;
            MessageWidget msgWidget = new MessageWidget("");
            msgWidget.setMessage(uibMsg);
            Toolkit.setLocked(500L);
            this.listWidget.insertRemove(msgWidget, 0);
            Toolkit.setUnlocked();
            this.alerter.playSound();
            if (!this.focus) {
                try {
                    UniversalCommunicator.getInbox().requestTabDisplayChange(this.mainDisplay, Toolkit.createImage(this.hlIconLoc));
                }
                catch (IOException e2) {
                    this.log.warning(String.valueOf(PLUGIN_NAME) + " failed the highlight tab updated");
                    e2.printStackTrace();
                }
            } else {
                this.listWidget.doLayout();
                this.listWidget.repaintExt();
                this.setSelectedItem();
            }
        }
        this.handleAlert(uibMsg);
    }

    protected final void setSelectedItem() {
        if (this.listWidget.v.size() > 0 && this.listWidget.selectedindex == -1) {
            this.listWidget.setHighlight(0);
        }
    }

    protected final void subscribeToChannels(Message message) {
        String[] topics = this.getParsedArray(message.getDataString(), "UIB/inbox/channels/", null);
        int count = topics.length;
        Source source = message.getSource();
        if (topics != null) {
            try {
                this.connectionPool.subscribe(topics, source.getBroker(), this, new MQTTProperties());
            }
            catch (CommsException commsException) {
                CommsException e2 = commsException;
                commsException.printStackTrace();
                this.log.severe(String.valueOf(PLUGIN_NAME) + " could not subscribe to the list of channels");
            }
        }
    }

    public final void enable() {
        super.enable();
        this.addDefaultSubscriptions();
    }

    protected final void addDefaultSubscriptions() {
        Source persInboxSource = new Source(this.persInboxTopic);
        Source inboxChannelsSource = new Source(this.inboxChannelsListTopic);
        try {
            this.connectionPool.subscribe(persInboxSource, this, null);
            this.connectionPool.subscribe(inboxChannelsSource, this, null);
        }
        catch (CommsException e2) {
            this.log.severe(String.valueOf(PLUGIN_NAME) + " failed to subscribe to information");
            e2.printStackTrace();
        }
    }

    public final void hasFocus() {
        this.setSelectedItem();
        UniversalCommunicator.getInbox().requestTabDisplayChange(this.mainDisplay, this.getIcon());
        super.hasFocus();
    }

    public final void connected(String serverName) {
        this.addDefaultSubscriptions();
    }
}

