/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.user.home;

import com.ibm.mobile.uib.common.Dialog;
import com.ibm.mobile.uib.plugins.AbstractVisualPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionListener;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionPool;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringAttr;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public final class HomePage
extends AbstractVisualPlugin
implements ConnectionListener,
CommandListener {
    private int NOT_CONN = 2;
    private int CONNECTED = 0;
    private int CONNECTING = 1;
    private int DISCONN = 2;
    private String connectionPoolPlugin = "Connection Pool";
    private ConnectionPool connectionPool = null;
    private Image connectedImg = null;
    private Image connectingImg = null;
    private Image disconnectedImg = null;
    private StringAttr connStr = null;
    private StringWidget connWidget = null;
    private Translator translator = null;
    private StringWidget helpText = null;
    private Command settingsCommand = null;
    private String welcomeText;
    private StandardForm form;

    public HomePage() {
        super("Home");
    }

    public final void initialise(Preferences prefs) {
        try {
            this.translator = (Translator)PluginManager.getManager().getPlugin("Language");
            this.welcomeText = this.translator.getKey("homepage.welcome");
            String connected = (String)prefs.get("connected");
            String connecting = (String)prefs.get("connecting");
            String disconnected = (String)prefs.get("disconnected");
            this.connectedImg = Toolkit.createImage(connected);
            this.connectingImg = Toolkit.createImage(connecting);
            this.disconnectedImg = Toolkit.createImage(disconnected);
            String iconName = (String)prefs.get("Tab-icon");
            this.setIcon(iconName, null);
            this.connStr = new StringAttr(" " + this.translator.getKey("homepage.notconnected"), Style.getDefaultFont(), PreferencesManager.getInstance().getGeneralPreferences().getDefaultTextColour());
        }
        catch (IOException e2) {
            this.log.warning("Home could not load traffic light image");
            e2.printStackTrace();
        }
        super.initialise(prefs);
    }

    public final void enable() {
        super.enable();
        this.helpText.setItems(String.valueOf(this.welcomeText) + this.getPreferenceMgr().getGeneralPreferences().getDefaultClientID());
        this.connectionPool = (ConnectionPool)PluginManager.getManager().getPlugin(this.connectionPoolPlugin);
        try {
            this.connectionPool.addListener(this, PreferencesManager.getInstance().getGeneralPreferences().getDefaultBroker());
            if (this.connectionPool.isConnected()) {
                HomePage homePage = this;
                homePage.updateStatus(homePage.CONNECTED, " " + this.translator.getKey("homepage.connected"));
            }
        }
        catch (CommsException e2) {
            this.log.warning("Home failed to register with a connection listener. It will be unable to display the correct status of any server connections");
            e2.printStackTrace();
        }
    }

    protected final StandardForm initialiseDisplay() {
        FormData layout = null;
        this.form = new StandardForm();
        this.form.setBackground(this.getBackgroundImage(), this.getPreferenceMgr().getGeneralPreferences().getDefaultBGColour());
        HomePage homePage = this;
        StringWidget title = homePage.createTitlebar(homePage.translator.getKey("uc.title"));
        this.form.append(title);
        this.helpText = new StringWidget("", false);
        this.helpText.setStyle(this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour(), Style.getDefaultFont(), 0 != 0, 0);
        layout = new FormData();
        new FormData().top = new FormAttachment(title);
        layout.left = new FormAttachment(0, 0);
        layout.right = new FormAttachment(100, 0);
        this.helpText.setLayoutData(layout);
        this.form.append(this.helpText);
        Vector<Object> items = new Vector<Object>(2);
        items.addElement(this.disconnectedImg);
        items.addElement(this.connStr);
        this.connWidget = new StringWidget(items, false);
        this.connWidget.setFrame(-2);
        layout = new FormData();
        new FormData().top = new FormAttachment(this.helpText, 5);
        layout.left = new FormAttachment(0, 5);
        this.connWidget.setLayoutData(layout);
        this.form.append(this.connWidget);
        this.form.setCommandListener(this);
        this.settingsCommand = new Command(this.translator.getKey("homepage.settings"), 1, 1);
        this.form.addCommand(this.settingsCommand);
        return this.form;
    }

    public final void connectionLost(String serverName) {
        HomePage homePage = this;
        homePage.updateStatus(homePage.CONNECTING, " " + this.translator.getKey("homepage.connecting"));
        if (this.alerter != null) {
            this.alerter.tts(this.translator.getKey("homepage.connecting"));
            this.alerter.vibrate(3000);
        }
    }

    private final void updateStatus(int connIndex, String msg) {
        Vector<Object> items = new Vector<Object>(2);
        if (connIndex == this.NOT_CONN) {
            items.addElement(this.disconnectedImg);
        }
        if (connIndex == this.CONNECTED) {
            items.addElement(this.connectedImg);
        }
        if (connIndex == this.CONNECTING) {
            items.addElement(this.connectingImg);
        }
        this.connStr.object = msg;
        items.addElement(this.connStr);
        this.connWidget.setItems(items);
        this.form.repaintExt();
    }

    public final void connected(String serverName) {
        HomePage homePage = this;
        homePage.updateStatus(homePage.CONNECTED, " " + this.translator.getKey("homepage.connected"));
        if (this.alerter != null) {
            this.alerter.tts(this.translator.getKey("homepage.connected"));
        }
    }

    public final void commandAction(Command c2, Displayable aDisplayable) {
        Dialog settings;
        if (c2 == this.settingsCommand && (settings = (Dialog)((Object)this.pluginManager.getPlugin("Settings"))) != null) {
            settings.show(this.mainDisplay);
            return;
        }
        super.commandAction(c2, aDisplayable);
    }

    public final void hasFocus() {
        super.hasFocus();
        if (this.alerter != null) {
            this.alerter.tts(this.name);
        }
    }
}

