/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.comms.messaging.mqtt;

import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Connection;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionListener;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Subscriber;
import com.ibm.mobile.uib.plugins.core.comms.messaging.mqtt.MQTTProperties;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import com.ibm.mqtt.MqttClient;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttSimpleCallback;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class MqttConnection
implements Connection,
MqttSimpleCallback {
    private MqttClient client = null;
    private Hashtable allSubscribers = new Hashtable();
    private Hashtable wildcardSubscribers = new Hashtable();
    private boolean connected = false;
    private Vector connectionListeners = new Vector();
    private String host = null;
    private String user = null;
    private static String LWT_PREFIX = "status/UIB/";
    private Object connecting = new Object();
    private LogManager log;
    private Object lock = new Object();

    public MqttConnection(Hashtable properties, MqttPersistence persistence) throws CommsException {
        this.log = (LogManager)PluginManager.getManager().getPlugin("LogMgr");
        this.host = (String)properties.get("HOST");
        this.user = (String)properties.get("USER");
        try {
            this.client = new MqttClient("tcp://" + this.host);
            this.client.registerSimpleHandler(this);
        }
        catch (Exception mqe) {
            throw new CommsException("General Communications Exception", mqe);
        }
    }

    public final void connect(Hashtable publishProps) throws CommsException {
        Object object = this.connecting;
        synchronized (object) {
            try {
                String lwtTopic = String.valueOf(LWT_PREFIX) + this.user;
                this.client.connect(this.user, false, (short)20, lwtTopic, 1, "0", true);
                this.client.publish(lwtTopic, "1".getBytes(), 1, true);
                this.connected = true;
                this.notifyConnectionListeners();
            }
            catch (MqttException mqe) {
                throw new CommsException("Failed to connect", mqe);
            }
        }
    }

    public final void connectTillConnected() {
        while (!this.connected) {
            try {
                this.connect(null);
            }
            catch (Exception e2) {
                try {
                    this.log.warning("Attempt reconnect in 5 seconds");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private final void notifyConnectionListeners() {
        new Thread(new NotifyConnectionStatusThread()).start();
    }

    public final void publish(Message message, Hashtable publishProps) throws CommsException {
        byte[] data;
        if (!this.connected) {
            this.connect(null);
        }
        Source ch = message.getSource();
        boolean retain = false;
        int qos = 0;
        if (publishProps instanceof MQTTProperties) {
            MQTTProperties props = (MQTTProperties)publishProps;
            retain = props.isRetained();
            qos = props.getQos();
        }
        if ((data = message.getDataString().getBytes()) == null) {
            data = new byte[]{};
        }
        try {
            this.client.publish(ch.getTopic(), data, qos, retain);
        }
        catch (MqttException mqe) {
            throw new CommsException("Publish Failed", mqe);
        }
    }

    public final void subscribe(Source sc, Subscriber subscriber, Hashtable subProps) throws CommsException {
        if (!this.connected) {
            this.connect(null);
        }
        String topic = sc.getTopic();
        try {
            int qos = 0;
            if (subProps instanceof MQTTProperties) {
                MQTTProperties props = (MQTTProperties)subProps;
                qos = props.getQos();
            }
            this.addSubscriberInfo(topic, subscriber);
            String[] topics = new String[]{topic};
            int[] qoss = new int[]{qos};
            this.client.subscribe(topics, qoss);
        }
        catch (MqttException mqttException) {
            MqttException mqe = mqttException;
            mqttException.printStackTrace();
            this.removeSubscriberInfo(topic, subscriber);
            throw new CommsException("Subscribe Failed", mqe);
        }
    }

    private final void addSubscriberInfo(String topic, Subscriber subscriber) {
        Object object = this.lock;
        synchronized (object) {
            Hashtable currentSubsTable = !topic.endsWith("#") ? this.allSubscribers : this.wildcardSubscribers;
            Vector<Subscriber> subscribersForTopic = (Vector<Subscriber>)currentSubsTable.get(topic);
            if (subscribersForTopic == null) {
                subscribersForTopic = new Vector<Subscriber>(1);
                currentSubsTable.put(topic, subscribersForTopic);
            }
            if (subscribersForTopic.indexOf(subscriber) == -1) {
                subscribersForTopic.addElement(subscriber);
            }
        }
    }

    public final void unsubscribe(Source ch, Subscriber subscriber, Hashtable unsubProps) throws CommsException {
        if (!this.connected) {
            this.connect(null);
        }
        try {
            String topic = ch.getTopic();
            String[] topics = new String[]{topic};
            this.client.unsubscribe(topics);
            this.removeSubscriberInfo(topic, subscriber);
        }
        catch (MqttException mqe) {
            throw new CommsException("Unsubscribe Failed", mqe);
        }
    }

    private final void removeSubscriberInfo(String topic, Subscriber subscriber) {
        Hashtable currentSubsTable = !topic.endsWith("#") ? this.allSubscribers : this.wildcardSubscribers;
        String[] topics = new String[]{topic};
        Vector subscribersToTopic = (Vector)currentSubsTable.get(topic);
        if (subscribersToTopic != null) {
            if (subscribersToTopic.size() <= 1) {
                currentSubsTable.remove(topic);
            } else {
                subscribersToTopic.removeElement(subscriber);
            }
        }
    }

    public final void connectionLost() {
        this.connected = false;
        this.notifyConnectionListeners();
        while (!this.connected) {
            try {
                this.connectTillConnected();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final Vector findMatchingSubscribers(String topic) {
        Vector subscribers = (Vector)this.allSubscribers.get(topic);
        if (subscribers == null) {
            subscribers = new Vector();
        }
        Enumeration keys = this.wildcardSubscribers.keys();
        while (keys.hasMoreElements()) {
            String wcSubTopic = (String)keys.nextElement();
            if (!topic.startsWith(wcSubTopic.substring(0, wcSubTopic.length() - 1))) continue;
            Vector wcSubscribers = (Vector)this.wildcardSubscribers.get(wcSubTopic);
            Enumeration enumeration = wcSubscribers.elements();
            while (enumeration.hasMoreElements()) {
                subscribers.addElement(enumeration.nextElement());
            }
        }
        return subscribers;
    }

    public final void addListener(ConnectionListener listener, String brokerName) {
        if (this.connectionListeners.indexOf(listener) == -1) {
            this.connectionListeners.addElement(listener);
        }
    }

    public final void subscribe(String[] sources, String server, Subscriber subscriber, Hashtable subProps) throws CommsException {
        if (!this.connected) {
            this.connect(null);
        }
        int count = sources.length;
        int[] qosArray = new int[count];
        int i2 = 0;
        while (i2 < count) {
            this.addSubscriberInfo(sources[i2], subscriber);
            ++i2;
        }
        try {
            this.client.subscribe(sources, qosArray);
        }
        catch (MqttException mqttException) {
            MqttException e2 = mqttException;
            mqttException.printStackTrace();
            throw new CommsException("Subscribe Failed", e2);
        }
    }

    public final void publishArrived(String topicName, byte[] data, int qos, boolean retain) throws Exception {
        Message msg = new Message(new Source(topicName, this.host), data);
        new Thread(new DeliverMessage(msg, topicName)).start();
    }

    public final boolean isConnected() {
        return this.client.isConnected();
    }

    private final class DeliverMessage
    implements Runnable {
        Message msg = null;
        String topic = null;

        DeliverMessage(Message aMsg, String aTopic) {
            this.msg = aMsg;
            this.topic = aTopic;
        }

        public final void run() {
            try {
                Vector subscribers = MqttConnection.this.findMatchingSubscribers(this.topic);
                if (subscribers != null) {
                    Subscriber subscriber = null;
                    int i2 = 0;
                    while (i2 < subscribers.size()) {
                        subscriber = (Subscriber)subscribers.elementAt(i2);
                        subscriber.messageArrived(this.msg);
                        ++i2;
                    }
                }
            }
            catch (Exception e2) {
                MqttConnection.this.log.severe("The MQTT connection failed to deliver a message to the interested subscribers");
                e2.printStackTrace();
            }
        }
    }

    private final class NotifyConnectionStatusThread
    implements Runnable {
        NotifyConnectionStatusThread() {
        }

        public final void run() {
            int count = MqttConnection.this.connectionListeners.size();
            ConnectionListener listener = null;
            int i2 = 0;
            while (i2 < count) {
                listener = (ConnectionListener)MqttConnection.this.connectionListeners.elementAt(i2);
                if (MqttConnection.this.connected) {
                    listener.connected(MqttConnection.this.host);
                } else {
                    listener.connectionLost(MqttConnection.this.host);
                }
                ++i2;
            }
        }
    }
}

