/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.comms.messaging;

import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayload;
import com.ibm.mobile.uib.util.Utility;
import java.util.Vector;

public class UIBPayloadImpl
implements UIBPayload {
    protected String dataString;
    protected Action[] actions;

    public UIBPayloadImpl(int aType, String aTitle, String aBody, Action[] actions) {
        String xml = this.encode(aType, aTitle, aBody, null, null, null);
        StringBuffer buf = new StringBuffer(xml);
        buf.insert(0, "<m>");
        buf.append("</m>");
        this.dataString = buf.toString();
        this.actions = actions;
    }

    public UIBPayloadImpl(int aType, String aTitle, String aBody, Action[] actions, String aURL, String aImageURL, String aAudioURL) {
        String xml = this.encode(aType, aTitle, aBody, aURL, aImageURL, aAudioURL);
        StringBuffer buf = new StringBuffer(xml);
        buf.insert(0, "<m>");
        buf.append("</m>");
        this.dataString = buf.toString();
        this.actions = actions;
    }

    public UIBPayloadImpl(String xmlPayloadString) {
        this.dataString = xmlPayloadString;
    }

    protected final String encode(int aType, String aTitle, String aBody, String aURL, String aImageURL, String aAudioURL) {
        StringBuffer sb = new StringBuffer();
        sb = sb.append("<t>");
        sb.append(aType);
        sb.append("</t><s>");
        sb.append(aTitle);
        sb.append("</s><b>");
        sb.append(aBody);
        sb.append("</b>");
        if (aURL != null) {
            sb.append("<u>" + aURL + "</u>");
        }
        if (aImageURL != null) {
            sb.append("<img>" + aImageURL + "</img>");
        }
        if (aAudioURL != null) {
            sb.append("<au>" + aAudioURL + "</au>");
        }
        return sb.toString();
    }

    public final int getType() throws NumberFormatException {
        return Integer.parseInt(Utility.parseValueBetweenTags("<t>", "</t>", this.dataString));
    }

    public final String getSubject() {
        return Utility.parseValueBetweenTags("<s>", "</s>", this.dataString);
    }

    public final String getBody() {
        return Utility.parseValueBetweenTags("<b>", "</b>", this.dataString);
    }

    public String toString() {
        if (this.dataString != null) {
            return this.dataString;
        }
        return "Invalid message";
    }

    public final String getHeading() {
        return " " + this.getSubject();
    }

    public boolean isAlert() {
        return this.dataString.indexOf("</a>") != -1;
    }

    public final Action[] getActions() {
        if (this.actions == null) {
            String label = "";
            String key = "";
            String topic = null;
            String exit = "";
            boolean closeWindow = true;
            int index = 1;
            Action action = null;
            Vector<Action> actionList = new Vector<Action>();
            String actionXml = Utility.parseValueBetweenTags("<ars>", "</ars>", this.dataString);
            if (actionXml != null && !actionXml.equals("")) {
                while (label != null) {
                    label = Utility.parseValueBetweenTags("<l>", "</l>", index, actionXml);
                    if (label != null) {
                        key = Utility.getAttributeValue("key", "<ar>", index, actionXml);
                        exit = Utility.getAttributeValue("exit", "<ar>", index, actionXml);
                        closeWindow = !exit.equals("0");
                        topic = Utility.parseValueBetweenTags("<rt>", "</rt>", index, actionXml);
                        String msg = Utility.parseValueBetweenTags("<r>", "</r>", index, actionXml);
                        action = new Action(label, topic, msg, key, closeWindow);
                        actionList.addElement(action);
                    }
                    ++index;
                }
            }
            this.actions = new Action[actionList.size()];
            actionList.copyInto(this.actions);
        }
        return this.actions;
    }

    public final String getURL() {
        return Utility.parseValueBetweenTags("<u>", "</u>", this.dataString);
    }

    public final String getImageURL() {
        return Utility.parseValueBetweenTags("<img>", "</img>", this.dataString);
    }

    public final String getAudioURL() {
        return Utility.parseValueBetweenTags("<au>", "</au>", this.dataString);
    }
}

