/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.comms.messaging;

import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Connection;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionFactory;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionListener;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Subscriber;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import java.util.Hashtable;

public final class ConnectionPool
extends AbstractPlugin
implements Connection {
    private Hashtable connections = new Hashtable();
    private ConnectionFactory factory = null;
    static /* synthetic */ Class class$0;

    public ConnectionPool() {
        super("Connection Pool");
    }

    private final Connection getOrCreateConnection(String host) throws CommsException {
        Connection conn;
        if (host == null) {
            host = this.getPreferenceMgr().getGeneralPreferences().getDefaultBroker();
        }
        if ((conn = (Connection)this.connections.get(host)) == null) {
            if (this.factory == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.factory = (ConnectionFactory)((Object)this.pluginManager.getPlugin(clazz));
                if (this.factory == null) {
                    throw new CommsException("ConnectionFactory not found");
                }
            }
            String username = this.getPreferenceMgr().getGeneralPreferences().getDefaultClientID();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("HOST", host);
            properties.put("USER", username);
            conn = this.factory.createConnection(properties);
            this.connections.put(host, conn);
        }
        return conn;
    }

    public final void publish(Message message, Hashtable publishProps) throws CommsException {
        Connection conn = this.getOrCreateConnection(message.getSource().getBroker());
        conn.publish(message, publishProps);
    }

    public final void subscribe(Source channel, Subscriber subscriber, Hashtable subProps) throws CommsException {
        Connection conn = this.getOrCreateConnection(channel.getBroker());
        conn.subscribe(channel, subscriber, subProps);
    }

    public final void unsubscribe(Source channel, Subscriber subscriber, Hashtable unsubProps) throws CommsException {
        Connection conn = this.getOrCreateConnection(channel.getBroker());
        conn.unsubscribe(channel, subscriber, unsubProps);
    }

    public final void addListener(ConnectionListener listener, String server) throws CommsException {
        Connection conn = this.getOrCreateConnection(server);
        conn.addListener(listener, server);
    }

    public final void subscribe(String[] sources, String server, Subscriber subscriber, Hashtable subProps) throws CommsException {
        Connection conn = this.getOrCreateConnection(server);
        conn.subscribe(sources, server, subscriber, subProps);
    }

    public final boolean isConnected() {
        Connection conn = null;
        try {
            conn = this.getOrCreateConnection(PreferencesManager.getInstance().getGeneralPreferences().getDefaultBroker());
        }
        catch (CommsException commsException) {
            // empty catch block
        }
        if (conn != null) {
            return conn.isConnected();
        }
        return false;
    }
}

