/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.comms.messaging;

import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionPool;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import java.util.Calendar;

public final class Action {
    private String label = null;
    private String topic = null;
    private String response = null;
    private String key = null;
    private boolean closeWindow = true;
    private static PreferencesManager.GeneralPreference gp = null;

    public Action(String label, String topic, String message, String key, boolean closeWindow) {
        this.label = label;
        this.topic = topic;
        this.response = message;
        this.key = key;
        this.closeWindow = closeWindow;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getResponse() {
        return this.response;
    }

    public final String getTopic() {
        return this.topic;
    }

    public final String getKey() {
        return this.key;
    }

    public final boolean getCloseWindow() {
        return this.closeWindow;
    }

    public final void respond() {
        ConnectionPool connectionPool = (ConnectionPool)PluginManager.getManager().getPlugin("Connection Pool");
        if (connectionPool != null) {
            Action action = this;
            String resp = action.processSubstitutionTags(action.getResponse());
            Message msg = new Message(new Source(this.getTopic()), resp);
            try {
                connectionPool.publish(msg, null);
            }
            catch (CommsException commsException) {
                CommsException e2 = commsException;
                commsException.printStackTrace();
            }
        }
    }

    private final String processSubstitutionTags(String msgText) {
        String nameTag = "$name";
        String timeTag = "$time";
        String inputTag = "$input";
        if (msgText == null) {
            return "";
        }
        int nameTagIndex = msgText.indexOf(nameTag);
        int timeTagIndex = msgText.indexOf(timeTag);
        int inputTagIndex = msgText.indexOf(inputTag);
        StringBuffer buffer = new StringBuffer();
        int inputTagSize = inputTag.length();
        int length = msgText.length();
        if (nameTagIndex != -1 || timeTagIndex != -1 || inputTagIndex != -1) {
            int i2 = 0;
            while (i2 < length) {
                char c2 = msgText.charAt(i2);
                if (c2 != '$') {
                    buffer.append(c2);
                } else if (i2 == nameTagIndex) {
                    buffer.append(Action.getGeneralPrefs().getDefaultClientID());
                    i2 += 4;
                } else if (i2 == timeTagIndex) {
                    buffer.append(Calendar.getInstance().getTime());
                    i2 += 4;
                } else if (i2 == inputTagIndex) {
                    String string = msgText.substring(i2 + inputTagSize, i2 + inputTagSize + 1);
                }
                ++i2;
            }
            return buffer.toString();
        }
        return msgText;
    }

    private static PreferencesManager.GeneralPreference getGeneralPrefs() {
        if (gp == null) {
            gp = PreferencesManager.getInstance().getGeneralPreferences();
        }
        return gp;
    }
}

