/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.alerter;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.alerter.Alerter;
import com.ibm.mobile.uib.plugins.core.prefs.PreferenceException;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public final class GeneralAlerter
extends AbstractPlugin
implements Alerter {
    private Display display;
    private Preferences prefs;
    private boolean flashing;
    private boolean vibrate;
    private boolean playingSound;
    private String defaultSound = "/audio/alarm.wav";

    public GeneralAlerter() {
        super("Alerter");
    }

    public final void initialise(Preferences prefs) {
        super.initialise(prefs);
        this.prefs = prefs;
        this.display = UniversalCommunicator.getInbox().getDisplay();
    }

    public final boolean vibrate(int millis) {
        return this.display.vibrate(millis);
    }

    public final boolean flash(int millis) {
        return this.display.flashBacklight(millis);
    }

    public final void stopFlashing() {
        this.flashing = false;
    }

    public final void stopVibrating() {
        this.vibrate = false;
    }

    public final void playSound() {
        if (!this.playingSound) {
            this.playingSound = true;
            PlaySoundThread pst = new PlaySoundThread();
            new Thread(pst).start();
        }
    }

    public final void tts(String text) {
        Displayable disp = Display.getDisplay((MIDlet)UniversalCommunicator.getInbox()).getCurrent();
        disp.setTitle(text);
    }

    public final boolean willVibrate() {
        return this.prefs.get("vibrate").equals(Preferences.TRUE);
    }

    public final boolean willFlash() {
        return this.prefs.get("flash").equals(Preferences.TRUE);
    }

    public final boolean isAudible() {
        return this.prefs.get("audible").equals(Preferences.TRUE);
    }

    public final void setPrefs(boolean vibrate, boolean flash, boolean audible) {
        String val = vibrate ? Preferences.TRUE : Preferences.FALSE;
        this.prefs.put("vibrate", val);
        val = flash ? Preferences.TRUE : Preferences.FALSE;
        this.prefs.put("flash", val);
        val = audible ? Preferences.TRUE : Preferences.FALSE;
        this.prefs.put("audible", val);
        try {
            this.prefs.store();
        }
        catch (PreferenceException preferenceException) {
            PreferenceException e2 = preferenceException;
            preferenceException.printStackTrace();
            this.log.severe("Alerter could not store its preferences");
        }
    }

    public final void alert() {
        if (this.willVibrate()) {
            this.vibrate(4000);
        }
        if (this.willFlash()) {
            this.flash(4000);
        }
        if (this.isAudible()) {
            this.playSound();
        }
    }

    public final class PlaySoundThread
    implements Runnable,
    PlayerListener {
        public final void run() {
            try {
                InputStream in = this.getClass().getResourceAsStream("/audio/alarm.wav");
                Player player = Manager.createPlayer((InputStream)in, (String)"audio/x-wav");
                player.addPlayerListener((PlayerListener)this);
                player.realize();
                VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
                volumeControl.setLevel(70);
                player.start();
            }
            catch (Exception e2) {
                GeneralAlerter.this.log.severe("Alerter failed to play sound.");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            GeneralAlerter.this.playingSound = false;
        }

        public final void playerUpdate(Player player, String event, Object eventData) {
            if (event.equals("stopped")) {
                player.close();
                player.removePlayerListener((PlayerListener)this);
            }
        }
    }
}

