/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins;

import com.ibm.mobile.uib.common.UIBForm;
import com.ibm.mobile.uib.plugins.ExtendedVisualPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.VisualPlugin;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.TabBarWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class PluginTabBar
extends TabBarWidget {
    private MIDlet midlet;
    private Image homeIcon;
    private StandardForm homeForm;

    public PluginTabBar(MIDlet midlet) {
        super(midlet, true, null);
        this.midlet = midlet;
    }

    private final void addTab(StandardForm form, String name, Image icon, TabBarWidget tabBar) {
        if (this.homeForm == null) {
            this.homeForm = form;
        }
        if (icon != null) {
            name = null;
        }
        this.setTab(new Object[]{icon, name}, form, -1);
        form.setTabBar(tabBar);
        form.setFocus(tabBar);
    }

    private final void addTab(StandardForm form, String name, Image icon) {
        this.addTab(form, name, icon, this);
    }

    public final void addTab(VisualPlugin plugin) {
        if (plugin instanceof ExtendedVisualPlugin) {
            this.addExtendedTab((ExtendedVisualPlugin)plugin);
        } else {
            VisualPlugin visualPlugin = plugin;
            this.addTab(visualPlugin, visualPlugin.getDisplay());
        }
    }

    public final void addTab(VisualPlugin plugin, StandardForm form) {
        this.addTab(form, plugin.getName(), plugin.getIcon());
    }

    private final void addExtendedTab(ExtendedVisualPlugin plugin) {
        UIBForm[] uibForms = plugin.getDisplays();
        PluginTabBar tabBar = new PluginTabBar(this.midlet);
        tabBar.addTab(this.homeForm, "", this.getHomeIcon(), this);
        int index = 0;
        while (index < uibForms.length) {
            UIBForm uibForm = uibForms[index];
            tabBar.addTab(uibForm.getForm(), uibForm.getLabel(), uibForm.getIcon());
            ++index;
        }
        StandardForm firstForm = uibForms[0].getForm();
        this.addTab(firstForm, plugin.getName(), plugin.getIcon(), tabBar);
    }

    private final Image getHomeIcon() {
        if (this.homeIcon == null) {
            try {
                this.homeIcon = Toolkit.createImage("/images/leftarrow.png");
            }
            catch (IOException e2) {
                LogManager log = (LogManager)PluginManager.getManager().getPlugin("LogMgr");
                log.warning("Tab Bar failed to load /images/leftarrow.png");
                e2.printStackTrace();
            }
        }
        return this.homeIcon;
    }
}

