/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins;

import com.ibm.mobile.uib.plugins.Plugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.PluginRegistryEntry;
import com.ibm.mobile.uib.plugins.VisualPlugin;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import java.util.Enumeration;
import java.util.Vector;

public final class PluginRegistry {
    private Vector plugins = new Vector();
    private LogManager log;
    static /* synthetic */ Class class$0;

    public final void addPlugin(Plugin plugin) {
        String pluginName = plugin.getName();
        PluginRegistryEntry entry = new PluginRegistryEntry(pluginName, plugin);
        Vector vector = this.plugins;
        synchronized (vector) {
            if (!this.plugins.contains(entry)) {
                this.plugins.addElement(entry);
            }
        }
    }

    public final Plugin getPlugin(String pluginName) {
        Object plugin = null;
        Vector vector = this.plugins;
        synchronized (vector) {
            Enumeration it = this.plugins.elements();
            while (it.hasMoreElements()) {
                PluginRegistryEntry pre = (PluginRegistryEntry)it.nextElement();
                if (!pre.getPluginClassName().equals(pluginName)) continue;
                return pre.getPlugin();
            }
        }
        return null;
    }

    public final Vector getPlugins(Class pluginClass) {
        Vector<Plugin> requestedPlugins = new Vector<Plugin>();
        Plugin plugin = this.getPlugin(pluginClass.getName());
        if (plugin != null) {
            requestedPlugins.addElement(plugin);
        }
        Enumeration allPlugins = this.plugins.elements();
        while (allPlugins.hasMoreElements()) {
            PluginRegistryEntry entry = (PluginRegistryEntry)allPlugins.nextElement();
            Plugin currentPlugin = entry.getPlugin();
            if (!pluginClass.isAssignableFrom(currentPlugin.getClass())) continue;
            requestedPlugins.addElement(currentPlugin);
        }
        return requestedPlugins;
    }

    public final Vector getPlugins(int pluginType) {
        Vector<Plugin> requestedPlugins = new Vector<Plugin>();
        Enumeration allPlugins = this.plugins.elements();
        while (allPlugins.hasMoreElements()) {
            PluginRegistryEntry entry = (PluginRegistryEntry)allPlugins.nextElement();
            Plugin currentPlugin = entry.getPlugin();
            boolean pluginRequested = this.pluginIsType(currentPlugin, pluginType);
            if (!pluginRequested) continue;
            requestedPlugins.addElement(currentPlugin);
        }
        return requestedPlugins;
    }

    private final boolean pluginIsType(Plugin plugin, int type) {
        boolean result = false;
        String pluginClass = plugin.getClass().getName();
        switch (type) {
            case 0: {
                result = true;
            }
            case 1: {
                if (!PluginManager.isCorePlugin(pluginClass)) break;
                result = true;
                break;
            }
            case 2: {
                if (PluginManager.isCorePlugin(pluginClass)) break;
                result = true;
                break;
            }
            case 3: {
                if (!(plugin instanceof VisualPlugin)) break;
                result = true;
                break;
            }
            default: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.mobile.uib.plugins.core.logging.LogManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.log = (LogManager)this.getPlugin(clazz.getName());
                if (this.log == null) break;
                this.log.warning("Invalid type of plugins requested: " + type);
            }
        }
        return result;
    }

    public final Vector getPlugins() {
        return this.plugins;
    }
}

