/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.VisualPlugin;
import com.ibm.mobile.uib.plugins.alerter.Alerter;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public abstract class AbstractVisualPlugin
extends AbstractPlugin
implements VisualPlugin,
CommandListener {
    protected String logoName;
    protected String iconLoc;
    protected String noFocusIconLoc;
    protected String hlIconLoc;
    protected Image icon;
    protected Image noFocusIcon;
    protected StandardForm mainDisplay;
    protected Hashtable commands;
    protected boolean focus;
    protected static Image bgImage;
    protected Alerter alerter = null;

    public AbstractVisualPlugin(String pluginName) {
        this(pluginName, "/images/Default.png");
    }

    public AbstractVisualPlugin(String pluginName, String pluginIconLocation) {
        super(pluginName);
        this.iconLoc = pluginIconLocation;
        this.commands = new Hashtable();
    }

    public AbstractVisualPlugin(String pluginName, String pluginIconLocation, String pluginHighlightIconLoc) {
        super(pluginName);
        this.iconLoc = pluginIconLocation;
        this.hlIconLoc = pluginHighlightIconLoc;
        this.commands = new Hashtable();
    }

    public void initialise(Preferences prefs) {
        block3: {
            String iconName = prefs.getString("tab-icon");
            String noFocusIconName = prefs.getString("tab-icon-no-focus");
            this.setIcon(iconName, noFocusIconName);
            if (noFocusIconName != null) {
                try {
                    this.noFocusIcon = Toolkit.createImage(noFocusIconName);
                }
                catch (IOException e2) {
                    if (this.log == null) break block3;
                    this.log.warning(String.valueOf(this.getName()) + " failed to load its no focus icon named" + noFocusIconName);
                }
            }
        }
        super.initialise(prefs);
        this.setStyle();
        this.mainDisplay = this.initialiseDisplay();
        this.mainDisplay.setFullScreenMode(this.getPreferenceMgr().getGeneralPreferences().useFullscreen());
        this.mainDisplay.setCommandListener(this);
    }

    private final void setStyle() {
        Toolkit.formbg = this.getPreferenceMgr().getGeneralPreferences().getDefaultBGColour();
    }

    protected abstract StandardForm initialiseDisplay();

    public final Image getIcon() {
        if (this.icon == null) {
            this.icon = AbstractVisualPlugin.generateIcon(this.iconLoc, this.getName(), this.log);
        }
        return this.icon;
    }

    public final void setIcon(String iconName, String noFocusIconName) {
        this.iconLoc = iconName;
        this.noFocusIconLoc = noFocusIconName;
    }

    public final void setHighlightIcon(String pluginHighlightIconLoc) {
        this.hlIconLoc = pluginHighlightIconLoc;
    }

    public static Image generateIcon(String iconLocation, String pluginName, LogManager log) {
        Image icon;
        block3: {
            icon = null;
            try {
                if (iconLocation != null) {
                    icon = Toolkit.createImage(iconLocation);
                }
            }
            catch (IOException e2) {
                if (log == null) break block3;
                log.warning(String.valueOf(pluginName) + ": Failed to load icon '" + iconLocation + "'. Check the file exists and the correct permissions are set.");
            }
        }
        return icon;
    }

    public final StandardForm getDisplay() {
        return this.mainDisplay;
    }

    public final void addCommand(Command command, CommandListener listener) {
        if (this.mainDisplay != null) {
            this.commands.put(command, listener);
            this.mainDisplay.addCommand(command);
        }
    }

    public void hasFocus() {
        AbstractVisualPlugin abstractVisualPlugin = this;
        abstractVisualPlugin.changeIcon(abstractVisualPlugin.icon);
        this.focus = true;
    }

    public void lostFocus() {
        if (this.noFocusIcon != null) {
            AbstractVisualPlugin abstractVisualPlugin = this;
            abstractVisualPlugin.changeIcon(abstractVisualPlugin.noFocusIcon);
        }
        this.focus = false;
    }

    protected final StringWidget createTitlebar(String title) {
        return this.createTitlebar(title, this.getIcon());
    }

    protected final StringWidget createTitlebar(String title, Image icon) {
        return Style.createTitlebar(title, icon, 16, this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour());
    }

    public void commandAction(Command aCommand, Displayable aDisplayable) {
        Enumeration commandsEnum = this.commands.keys();
        while (commandsEnum.hasMoreElements()) {
            Command currentCommand = (Command)commandsEnum.nextElement();
            if (aCommand != currentCommand) continue;
            CommandListener listener = (CommandListener)this.commands.get(currentCommand);
            listener.commandAction(aCommand, aDisplayable);
        }
    }

    protected Image getBackgroundImage() {
        String imgName;
        if (bgImage == null && (imgName = PreferencesManager.getInstance().getGeneralPreferences().getDefaultBGImageName()) != null) {
            try {
                bgImage = Toolkit.createImage(imgName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bgImage;
    }

    protected final boolean isTTSEnabled() {
        return PreferencesManager.singleton.getGeneralPreferences().isTTSEnabled();
    }

    public void enable() {
        super.enable();
        this.alerter = (Alerter)((Object)PluginManager.getManager().getPlugin("Alerter"));
        if (this.noFocusIcon != null) {
            AbstractVisualPlugin abstractVisualPlugin = this;
            abstractVisualPlugin.changeIcon(abstractVisualPlugin.noFocusIcon);
        }
    }

    protected final void changeIcon(Image icon) {
        UniversalCommunicator.getInbox().requestTabDisplayChange(this.mainDisplay, icon);
    }
}

