/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.parser;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.graphics.Color;
import com.ibm.cst.ui.embedded.handler.wkt.WktBaseGeometryHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktBoxHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktColorHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktGeometryHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktLinestringHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktPointHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktPolygonHandler;
import com.ibm.cst.ui.embedded.list.IGeometryList;
import com.ibm.cst.ui.embedded.map.Annotation;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.IMap;
import com.ibm.cst.ui.embedded.map.Layer;
import com.ibm.cst.ui.embedded.map.Map;
import com.ibm.cst.ui.embedded.map.Path;
import com.ibm.cst.ui.embedded.parser.DefaultHandler;
import com.ibm.cst.ui.embedded.parser.IHandler;
import com.ibm.cst.ui.embedded.parser.WktHandler;
import java.util.Vector;

public final class MapWkTHandler
extends DefaultHandler {
    private final Vector elements = new Vector();
    private ITopElementHandler $curTagHandler = null;
    private final MapHandler $mapHandler = new MapHandler();
    private final LayerHandler $layerHandler = new LayerHandler(null);
    private final PathHandler $pathHandler = new PathHandler(null);
    private final AnnotationHandler $annotHandler = new AnnotationHandler(null);
    private int $depth = 0;

    public final void startElement(String qName) {
        if (this.$curTagHandler != null) {
            this.$curTagHandler.startElement(qName);
        } else if (qName.equals("MAP")) {
            this.$curTagHandler = this.$mapHandler;
            this.$mapHandler.resetHandler();
        } else if (qName.equals("LAYER")) {
            this.$curTagHandler = this.$layerHandler;
            this.$layerHandler.resetHandler();
        } else if (qName.equals("PATH")) {
            this.$curTagHandler = this.$pathHandler;
            this.$pathHandler.resetHandler();
        } else if (qName.equals("ANNOTATION")) {
            this.$curTagHandler = this.$annotHandler;
            this.$annotHandler.resetHandler();
        } else {
            DefaultHandler.trc("Unhandled top-level tag '" + qName + "'");
        }
        ++this.$depth;
    }

    public final void characters(String body) {
        if (this.$curTagHandler != null) {
            this.$curTagHandler.characters(body);
        } else {
            DefaultHandler.trc("Unexpected characters '" + body + "' outside of a Tag");
        }
    }

    public final void endElement(String qName) {
        if (this.$curTagHandler != null) {
            if (this.$depth > 0) {
                if (this.$depth > 1) {
                    this.$curTagHandler.endElement(qName);
                } else {
                    Object elem = this.$curTagHandler.getElement();
                    if (elem != null) {
                        this.elements.addElement(elem);
                    }
                    this.$curTagHandler = null;
                }
            } else {
                DefaultHandler.trc("Unexpected end tag '" + qName + "' does not match start tag " + this.$curTagHandler);
                this.$curTagHandler = null;
            }
        } else {
            DefaultHandler.trc("Unexpected top-level end tag '" + qName + "'");
        }
        --this.$depth;
    }

    public final Vector getTopElements() {
        return this.elements;
    }

    protected static boolean handlePrecision(String body, WktBaseGeometryHandler geomHandler) {
        boolean bHandled = false;
        DefaultHandler.trc("Warning: deprecated non-conformant PRECISION specification in " + geomHandler.getTagLabel() + " tag '" + body + "'");
        try {
            int precision = Integer.parseInt(body);
            geomHandler.setPrecision(precision);
            bHandled = true;
        }
        catch (NumberFormatException nfe) {
            DefaultHandler.trc("Could not convert assumed precision '" + body + "' to Integer");
        }
        return bHandled;
    }

    interface ITopElementHandler
    extends IHandler {
        public Object getElement();
    }

    final class MapHandler
    extends WktGeometryHandler
    implements ITopElementHandler {
        private IMap $map = null;

        public MapHandler() {
            super("MAP", null);
            this.addTagHandler(new LayerHandler((WktBaseGeometryHandler)this));
            this.addTagHandler(new PathHandler(this));
            this.addTagHandler(new AnnotationHandler((WktBaseGeometryHandler)this));
        }

        public final Object getElement() {
            return this.$map;
        }

        public final void resetHandler() {
            super.resetHandler();
            this.$map = new Map();
        }

        protected final boolean handleBody(String body) {
            return MapWkTHandler.handlePrecision(body, this);
        }

        protected final boolean handleTagClose(WktHandler handler) {
            boolean bUnhandled = false;
            if (handler instanceof LayerHandler) {
                ILayer layer = ((LayerHandler)handler).getLayer();
                if (layer != null) {
                    this.$map.addLayer(layer);
                }
            } else if (handler.handles("ANNOTATION")) {
                DefaultHandler.trc("Not sure what to do with Annotation tag within MAP tag");
                bUnhandled = true;
            } else {
                bUnhandled = true;
            }
            return !bUnhandled;
        }

        protected final void setArea(IEnvelope area) {
            super.setArea(area);
            this.$map.setExtent(this.$factory.createEnvelope(area));
        }
    }

    class LayerHandler
    extends WktGeometryHandler
    implements ITopElementHandler {
        private ILayer $layer;

        public LayerHandler(WktBaseGeometryHandler enclosing) {
            this("LAYER", enclosing);
        }

        protected LayerHandler(String tagName, WktBaseGeometryHandler enclosing) {
            super(tagName, enclosing);
            this.addTagHandler(new WktPolygonHandler(this));
            this.addTagHandler(new WktLinestringHandler(this));
            this.addTagHandler(new WktPointHandler(this));
            this.addTagHandler(new WktBoxHandler(this));
            this.addTagHandler(new WktColorHandler("FILLCOLOR"));
            this.addTagHandler(new WktColorHandler("LINECOLOR"));
            this.addTagHandler(new WktColorHandler("TEXTCOLOR"));
        }

        public final void resetHandler() {
            super.resetHandler();
            this.$layer = this.createLayer();
        }

        protected ILayer createLayer() {
            return new Layer();
        }

        public final Object getElement() {
            return this.getLayer();
        }

        public final ILayer getLayer() {
            DefaultHandler.trc("Parsed Layer '" + this.$layer.getName() + "' with " + this.$layer.getGeometryList().length() + " geometries");
            return this.$layer;
        }

        protected final boolean handleBody(String body) {
            return MapWkTHandler.handlePrecision(body, this);
        }

        protected final boolean handleTagClose(WktHandler handler) {
            boolean bUnHandled = false;
            if (handler instanceof WktPointHandler) {
                IPoint pt = ((WktPointHandler)handler).getPoint();
                this.addGeometry(pt);
            } else if (handler instanceof WktLinestringHandler) {
                ILineString line = ((WktLinestringHandler)handler).getLinestring();
                this.addGeometry(line);
            } else if (handler instanceof WktPolygonHandler) {
                IPolygon poly = ((WktPolygonHandler)handler).getPolygon();
                this.addGeometry(poly);
            } else if (handler instanceof WktColorHandler) {
                Color color = ((WktColorHandler)handler).getColor();
                if (handler.handles("FILLCOLOR")) {
                    this.$layer.setFillColor(color);
                } else if (handler.handles("LINECOLOR")) {
                    this.$layer.setDrawColor(color);
                } else if (handler.handles("TEXTCOLOR")) {
                    this.$layer.setTextColor(color);
                } else {
                    bUnHandled = true;
                }
            } else {
                bUnHandled = true;
            }
            return !bUnHandled;
        }

        private final void addGeometry(IGeometry geom) {
            if (geom != null) {
                IGeometryList geomList = this.$layer.getGeometryList();
                if (geomList == null) {
                    geomList = this.$factory.getListFactory().createGeometryList();
                    this.$layer.setGeometryList(geomList);
                }
                geomList.add(geom);
            }
        }

        protected final void setIDName(String ID, String name) {
            if (name != null) {
                this.$layer.setName(name);
            } else if (ID != null) {
                this.$layer.setName(ID);
            }
        }
    }

    final class PathHandler
    extends LayerHandler {
        public PathHandler(WktGeometryHandler enclosing) {
            super("PATH", enclosing);
        }

        protected final ILayer createLayer() {
            return new Path();
        }
    }

    final class AnnotationHandler
    extends WktGeometryHandler
    implements ITopElementHandler {
        private Annotation annotation;

        public AnnotationHandler(WktBaseGeometryHandler enclosing) {
            super("ANNOTATION", enclosing);
            this.addTagHandler(new WktColorHandler("TEXTCOLOR"));
            this.addTagHandler(new WktPointHandler(this));
        }

        public final void resetHandler() {
            this.annotation = new Annotation();
        }

        protected final boolean handleBody(String body) {
            this.annotation.setName(body);
            return true;
        }

        public final Object getElement() {
            return this.annotation;
        }

        protected final void setIDName(String ID, String name) {
            super.setIDName(ID, name);
        }

        protected final boolean handleTagClose(WktHandler handler) {
            boolean handled = true;
            if (handler.handles("TEXTCOLOR")) {
                Color textColor = ((WktColorHandler)handler).getColor();
                this.annotation.setTextColor(textColor);
            } else if (handler.handles("POINT")) {
                IPoint pt = ((WktPointHandler)handler).getPoint();
                DefaultHandler.trc("Found POINT in ANNOTATION, code to handle not implemented");
                this.annotation.getGeometryList().add(pt);
            } else {
                handled = false;
            }
            return handled;
        }
    }
}

