/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.map;

import com.ibm.cst.ui.embedded.factory.impl.ListFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.graphics.Color;
import com.ibm.cst.ui.embedded.graphics.ISpatialGC;
import com.ibm.cst.ui.embedded.list.IGeometryList;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.IdNameIndex;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.lcdui.Image;

public class Layer
implements ILayer {
    public static final Color DEFAULT_COLOR_FILL = Color.RED;
    public static final Color DEFAULT_COLOR_DRAW = Color.BLACK;
    public static final Color DEFAULT_COLOR_TEXT = Color.BLACK;
    private String $name;
    private Color $drawColor;
    private Color $fillColor;
    private Color $textColor;
    protected IGeometryList $geosList;
    private IdNameIndex $layerIndex;
    private boolean $visible;
    private Image $pointIcon = null;

    public Layer() {
        this("UnKnown", ListFactory.getInstance().createGeometryList());
    }

    public Layer(String name, IGeometryList geo) {
        this.$name = name;
        this.$geosList = geo;
        this.setVisible(true);
        this.$layerIndex = new IdNameIndex();
        this.loadPointIcon();
    }

    public final IGeometryList getGeometryList() {
        return this.$geosList;
    }

    public final void setGeometryList(IGeometryList list) {
        this.$geosList = list;
    }

    public final void setDrawColor(Color c2) {
        this.$drawColor = c2;
    }

    public final void setFillColor(Color c2) {
        this.$fillColor = c2;
    }

    public final void setTextColor(Color c2) {
        this.$textColor = c2;
    }

    public final Color getDrawColor() {
        return this.$drawColor != null ? this.$drawColor : DEFAULT_COLOR_DRAW;
    }

    public final Color getFillColor() {
        return this.$fillColor != null ? this.$fillColor : DEFAULT_COLOR_FILL;
    }

    public final Color getTextColor() {
        return this.$textColor != null ? this.$textColor : DEFAULT_COLOR_TEXT;
    }

    public final void setVisible(boolean bool) {
        this.$visible = bool;
    }

    public final boolean isVisible() {
        return this.$visible;
    }

    public final String getName() {
        return this.$name;
    }

    public final void setName(String string) {
        this.$name = string;
    }

    public final IdNameIndex getIndex() {
        return this.$layerIndex;
    }

    public void draw(ISpatialGC gc, IEnvelope mapArea) {
        this.dbg("Drawing layer '" + this.getName() + "' with " + this.getGeometryList().length() + " geometries");
        Enumeration enumGeoms = this.getGeoListElements();
        while (enumGeoms.hasMoreElements()) {
            IGeometry geom = (IGeometry)enumGeoms.nextElement();
            if (!this.isShown(gc, geom)) continue;
            if (geom instanceof IPolygon) {
                gc.setBackground(this.getFillColor());
                gc.fillPolygon((IPolygon)geom);
                gc.setForeground(this.getDrawColor());
                gc.drawPolygon((IPolygon)geom);
                continue;
            }
            if (geom instanceof ILineString) {
                gc.setForeground(this.getDrawColor());
                gc.drawPolyLine((ILineString)geom);
                continue;
            }
            if (!(geom instanceof IPoint)) continue;
            ISpatialCoordinate coord = ((IPoint)geom).getCoordinate();
            int radius = gc.getWidth() / 20;
            if (this.getPointIcon() == null) {
                gc.setBackground(DEFAULT_COLOR_DRAW);
                int n2 = radius;
                gc.fillOval(coord, n2, n2);
                gc.setForeground(this.getDrawColor());
                int n3 = radius;
                gc.drawOval(coord, n3, n3);
                continue;
            }
            gc.drawImage(this.getPointIcon(), coord);
        }
    }

    protected final boolean isShown(ISpatialGC gc, IGeometry geom) {
        return gc.drawAreaContains(geom) || geom.getEnvelope().contains(gc.getDrawArea()) || gc.drawAreaIntersects(geom.getEnvelope());
    }

    protected final void dbg(String msg) {
    }

    protected final Enumeration getGeoListElements() {
        return this.$geosList.elements();
    }

    protected void loadPointIcon() {
        try {
            this.$pointIcon = Toolkit.createImage("/images/visitor.png");
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
        }
    }

    protected Image getPointIcon() {
        return this.$pointIcon;
    }
}

