/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.handler.wkt;

import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.handler.wkt.WktBaseGeometryHandler;
import com.ibm.cst.ui.embedded.handler.wkt.WktGeometryHandler;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import com.ibm.cst.ui.embedded.parser.DefaultHandler;
import com.ibm.cst.ui.embedded.parser.WktHandler;
import java.util.Vector;

public final class WktPolygonHandler
extends WktGeometryHandler {
    private ISpatialCoordinateList $coordsList;
    private int[] $trianglesIndices;
    private String $ID;
    private String $name;

    public WktPolygonHandler(WktBaseGeometryHandler enclosing) {
        super("POLYGON", enclosing);
        this.addTagHandler(new TrianglePolygonHandler());
        this.addTagHandler(new EmptyHandler());
    }

    public final void resetHandler() {
        this.$coordsList = this.$factory.getListFactory().createSpatialCoordinateList();
        this.$trianglesIndices = null;
        this.$ID = null;
        this.$name = null;
    }

    protected final void setIDName(String ID, String name) {
        this.$ID = ID;
        this.$name = name;
        super.setIDName(ID, name);
    }

    protected final boolean handleBody(String body) {
        SpatialCoordinate coord = this.extractCoordinate(body);
        if (coord != null) {
            this.$coordsList.add(coord);
        }
        return true;
    }

    protected final boolean handleTagClose(WktHandler handler) {
        boolean bUnhandled = false;
        if (!(handler instanceof EmptyHandler)) {
            if (handler instanceof TrianglePolygonHandler) {
                this.$trianglesIndices = ((TrianglePolygonHandler)handler).getIndices();
                if (this.$trianglesIndices == null) {
                    DefaultHandler.trc("Warning, Polygon has no trianles");
                }
            } else {
                bUnhandled = true;
            }
        }
        return !bUnhandled;
    }

    public final IPolygon getPolygon() {
        IPolygon poly;
        int coordsCount = this.$coordsList.length();
        if (coordsCount > 3 && this.$trianglesIndices != null && this.$trianglesIndices.length > 3) {
            poly = this.$factory.createPolygon(this.$coordsList, this.$trianglesIndices);
        } else {
            if (coordsCount > 3) {
                DefaultHandler.trc("Polygon with " + coordsCount + " corners has no triangles");
            }
            poly = this.$factory.createPolygon(this.$coordsList);
        }
        return poly;
    }

    final class EmptyHandler
    extends WktBaseGeometryHandler {
        public EmptyHandler() {
            super("EMPTY", WktPolygonHandler.this);
        }

        public final void resetHandler() {
        }

        public final void characters(String body) {
            WktPolygonHandler.this.handleBody(body);
        }
    }

    final class TrianglePolygonHandler
    extends WktHandler {
        private int[] $indices;

        public TrianglePolygonHandler() {
            super("TRIANGLES");
        }

        public final int[] getIndices() {
            return this.$indices;
        }

        public final void resetHandler() {
            this.$indices = null;
        }

        public final void characters(String body) {
            Vector vec = WktHandler.tokenize(body, "|");
            this.$indices = new int[vec.size()];
            int i2 = 0;
            while (i2 < vec.size()) {
                this.$indices[i2] = Integer.parseInt((String)vec.elementAt(i2));
                ++i2;
            }
        }
    }
}

