/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.handler.wkt;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.factory.impl.GeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.parser.WktHandler;
import java.util.Vector;

public abstract class WktBaseGeometryHandler
extends WktHandler {
    public final IGeometryFactory $factory = GeometryFactory.getInstance();
    private IEnvelope $area = null;
    private int $precision;

    public WktBaseGeometryHandler(String tagLabel, IEnvelope extent, int precision) {
        super(tagLabel);
        this.$area = extent == null ? null : this.$factory.createEnvelope(extent.getCoordinates());
        this.$precision = precision;
    }

    public WktBaseGeometryHandler(String tagLabel, WktBaseGeometryHandler enclosing) {
        this(tagLabel, enclosing == null ? null : enclosing.$area, enclosing == null ? 10000 : enclosing.$precision);
    }

    public final int getPrecision() {
        return this.$precision;
    }

    public final IEnvelope getArea() {
        return this.$area;
    }

    protected void setArea(IEnvelope area) {
        this.$area = this.$factory.createEnvelope(area);
    }

    public final void setPrecision(int precision) {
        this.$precision = precision;
    }

    public final SpatialCoordinate extractCoordinate(String body) {
        SpatialCoordinate coord = null;
        Vector vec = WktHandler.tokenize(body, " ");
        if (vec.size() >= 2) {
            IEnvelope mapArea = this.getArea();
            double x2 = Double.parseDouble((String)vec.elementAt(0));
            double y2 = Double.parseDouble((String)vec.elementAt(1));
            if (mapArea != null) {
                x2 = x2 * (mapArea.getXmax() - mapArea.getXmin()) / (double)this.getPrecision() + mapArea.getXmin();
                y2 = y2 * (mapArea.getYmax() - mapArea.getYmin()) / (double)this.getPrecision() + mapArea.getYmin();
            }
            coord = new SpatialCoordinate(x2, y2);
        }
        return coord;
    }
}

