/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.graphics;

import java.util.Hashtable;

public class Color {
    public final int r;
    public final int g;
    public final int b;
    static final Hashtable rgbMap = new Hashtable();
    public static final Color WHITE = new Predefined(255, 255, 255, "white");
    public static final Color GRAY = new Predefined(128, 128, 128, "gray", true);
    public static final Color BLACK = new Predefined(0, 0, 0, "black");
    public static final Color GRAY_LIGHT = GRAY.lightened();
    public static final Color GRAY_DARK = GRAY.darkened();
    public static final Color RED = new Predefined(255, 0, 0, "red", true);
    public static final Color GREEN = new Predefined(0, 255, 0, "green", true);
    public static final Color BLUE = new Predefined(0, 0, 255, "blue", true);
    public static final Color RED_LIGHT = RED.lightened();
    public static final Color GREEN_LIGHT = GREEN.lightened();
    public static final Color BLUE_LIGHT = BLUE.lightened();
    public static final Color RED_DARK = RED.darkened();
    public static final Color GREEN_DARK = GREEN.darkened();
    public static final Color BLUE_DARK = BLUE.darkened();
    public static final Color CYAN = new Predefined(0, 255, 255, "cyan", true);
    public static final Color MAGENTA = new Predefined(255, 0, 255, "magenta", true);
    public static final Color YELLOW = new Predefined(255, 255, 0, "yellow", true);
    public static final Color CYAN_LIGHT = CYAN.lightened();
    public static final Color MAGENTA_LIGHT = MAGENTA.lightened();
    public static final Color YELLOW_LIGHT = YELLOW.lightened();
    public static final Color CYAN_DARK = CYAN.darkened();
    public static final Color MAGENTA_DARK = MAGENTA.darkened();
    public static final Color YELLOW_DARK = YELLOW.darkened();
    public static final Color PETROL = new Predefined(0, 128, 128, "petrol", true);
    public static final Color PURPLE = new Predefined(128, 0, 128, "purple", true);
    public static final Color BROWN = new Predefined(128, 128, 0, "brown", true);
    public static final Predefined ORANGE = new Predefined(255, 128, 0, "orange", true);
    public static final Predefined PINK = new Predefined(255, 128, 255, "pink", true);

    protected Color(int r, int g2, int b2) {
        int n2 = r < 0 ? 0 : (this.r = r > 255 ? 255 : r);
        int n3 = g2 < 0 ? 0 : (this.g = g2 > 255 ? 255 : g2);
        this.b = b2 < 0 ? 0 : (b2 > 255 ? 255 : b2);
    }

    public static Color getColor(int r, int g2, int b2) {
        Color color = (Color)rgbMap.get(Color.rgbHashKey(r, g2, b2));
        return color != null ? color : new Color(r, g2, b2);
    }

    public static int hashCode(int r, int g2, int b2) {
        return r + (g2 << 8) + (b2 << 16);
    }

    public static Integer rgbHashKey(int r, int g2, int b2) {
        return new Integer(Color.hashCode(r, g2, b2));
    }

    public final int hashCode() {
        return Color.hashCode(this.r, this.g, this.b);
    }

    public final Integer rgbHashKey() {
        return Color.rgbHashKey(this.r, this.g, this.b);
    }

    public final boolean equals(Object obj) {
        return obj.hashCode() == this.hashCode();
    }

    public String toString() {
        return "[" + this.r + ";" + this.g + ";" + this.b + "]";
    }

    public final Color darkened() {
        return Color.getColor(Color.darken(this.r), Color.darken(this.g), Color.darken(this.b));
    }

    static int darken(int color) {
        return ((color & 0xFF) + 1) / 2;
    }

    public final Color lightened() {
        return Color.getColor(Color.lighten(this.r), Color.lighten(this.g), Color.lighten(this.b));
    }

    static int lighten(int color) {
        return (color &= 0xFF) + (256 - color) / 2;
    }

    public static final class Predefined
    extends Color {
        static final Hashtable nameMap = new Hashtable();
        final String name;

        Predefined(int r, int g2, int b2, String name) {
            this(r, g2, b2, name, false);
        }

        Predefined(int r, int g2, int b2, String name, boolean addLightAndDark) {
            super(r, g2, b2);
            this.name = name;
            Predefined predefined = this;
            predefined.addPredefined(predefined, name);
            if (addLightAndDark) {
                new Predefined(this.lightened(), "light_" + name);
                new Predefined(this.darkened(), "dark_" + name);
            }
        }

        private final void addPredefined(Color color, String name) {
            nameMap.put(name, color);
            rgbMap.put(color.rgbHashKey(), color);
        }

        Predefined(Color color, String name) {
            this(color.r, color.g, color.b, name);
        }

        public final String toString() {
            return this.name;
        }
    }
}

