/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.operator;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.operator.Util;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import java.util.Enumeration;

public abstract class OpContain {
    private static boolean envelopeContainsGeometry(IEnvelope envelope, IGeometry geom) {
        if (geom instanceof IPoint) {
            IPoint iPoint;
            IPoint p2 = (IPoint)geom;
            return iPoint.getX() >= envelope.getXmin() && p2.getX() <= envelope.getXmax() && p2.getY() >= envelope.getYmin() && p2.getY() <= envelope.getYmax();
        }
        IEnvelope env = geom.getEnvelope();
        if (env.getXmin() < envelope.getXmin() || env.getXmax() > envelope.getXmax()) {
            return false;
        }
        return !(env.getYmin() < envelope.getYmin()) && !(env.getYmax() > envelope.getYmax());
    }

    private static boolean lineStringContaines(ILineString container, IGeometry content) {
        if (content instanceof IPoint) {
            ISpatialCoordinateList coords = container.getCoordinates();
            int i2 = 0;
            if (i2 < coords.length() - 1) {
                return Util.lineContainsPoint(coords.get(i2), coords.get(i2 + 1), content.getCoordinate());
            }
        } else if (content instanceof ILineString) {
            return container.equals(content);
        }
        return false;
    }

    private static boolean polygoneContainsGeometry(IPolygon container, IGeometry content) {
        boolean contains = true;
        ISpatialCoordinateList coords = content instanceof IEnvelope ? ((IEnvelope)content).toPolygone().getCoordinates() : content.getCoordinates();
        Enumeration e2 = coords.elements();
        while (e2.hasMoreElements()) {
            if (Util.polygoneContainsPoint(container, (ISpatialCoordinate)e2.nextElement())) continue;
            return false;
        }
        return contains;
    }

    private static boolean pointContaines(IPoint container, IGeometry content) {
        if (content instanceof IPoint) {
            return container.equals(content);
        }
        return false;
    }

    public static boolean contains(IGeometry container, IGeometry content) {
        if (container instanceof IEnvelope) {
            return OpContain.envelopeContainsGeometry((IEnvelope)container, content);
        }
        if (container instanceof IPolygon) {
            return OpContain.polygoneContainsGeometry((IPolygon)container, content);
        }
        if (container instanceof IPoint) {
            return OpContain.pointContaines((IPoint)container, content);
        }
        if (container instanceof ILineString) {
            return OpContain.lineStringContaines((ILineString)container, content);
        }
        return false;
    }
}

