/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.AbstractGeometry;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public final class LineString
extends AbstractGeometry
implements ILineString {
    protected ISpatialCoordinateList coordinates;
    protected IEnvelope $envelope;

    public LineString(ISpatialCoordinateList coords) {
        this(coords, null);
    }

    public LineString(ISpatialCoordinateList coords, IGeometryFactory factory) {
        super(factory);
        this.coordinates = coords;
        this.$envelope = null;
    }

    public final ISpatialCoordinate getCentroid() {
        if (!this.isEmpty()) {
            double totalLength = 0.0;
            double centSumX = 0.0;
            double centSumY = 0.0;
            int i2 = 0;
            while (i2 < this.coordinates.length() - 1) {
                double segmentLen = this.coordinates.get(i2).distance(this.coordinates.get(i2 + 1));
                totalLength += segmentLen;
                double midx = (this.coordinates.get(i2).getX() + this.coordinates.get(i2 + 1).getX()) / 2.0;
                centSumX += segmentLen * midx;
                double midy = (this.coordinates.get(i2).getY() + this.coordinates.get(i2 + 1).getY()) / 2.0;
                centSumY += segmentLen * midy;
                ++i2;
            }
            SpatialCoordinate coord = new SpatialCoordinate(centSumX / totalLength, centSumY / totalLength);
            return coord;
        }
        return null;
    }

    public final ISpatialCoordinate getCoordinate() {
        return this.isEmpty() ? null : this.coordinates.get(0);
    }

    public final ISpatialCoordinateList getCoordinates() {
        return this.coordinates;
    }

    public final IEnvelope getEnvelope() {
        if (this.$envelope == null) {
            this.$envelope = this.getFactory().createEnvelope(this.coordinates);
        }
        return this.$envelope;
    }

    public final boolean isEmpty() {
        return this.coordinates == null;
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof ILineString) {
            if (this.coordinates != null) {
                if (this.coordinates.equals(((ILineString)o2).getCoordinates())) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public final StringBuffer appendTo(StringBuffer sbuf) {
        if (sbuf == null) {
            sbuf = new StringBuffer();
        }
        sbuf.append("LINESTRING");
        ISpatialCoordinateList coordsList = this.getCoordinates();
        if (coordsList != null) {
            sbuf.append(coordsList.toString());
        } else {
            sbuf.append("()");
        }
        return sbuf;
    }
}

