/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.AbstractGeometry;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import java.util.Enumeration;

public final class Envelope
extends AbstractGeometry
implements IEnvelope {
    protected ISpatialCoordinate maxCoord;
    protected ISpatialCoordinate minCoord;

    public Envelope(double maxX, double maxY, double minX, double minY) {
        this(new SpatialCoordinate(maxX, maxY), new SpatialCoordinate(minX, minY));
    }

    public Envelope(ISpatialCoordinate max, ISpatialCoordinate min) {
        this(max, min, null);
    }

    public Envelope(ISpatialCoordinate max, ISpatialCoordinate min, IGeometryFactory factory) {
        super(factory);
        this.maxCoord = max;
        this.minCoord = min;
    }

    public Envelope(IEnvelope env) {
        this(env.getXmax(), env.getYmax(), env.getXmin(), env.getYmin());
    }

    public Envelope(ISpatialCoordinateList list, IGeometryFactory factory) {
        super(factory);
        double maxX = list.get(0).getX();
        double maxY = list.get(0).getY();
        double minX = list.get(0).getX();
        double minY = list.get(0).getY();
        Enumeration e2 = list.elements();
        while (e2.hasMoreElements()) {
            ISpatialCoordinate coord = (ISpatialCoordinate)e2.nextElement();
            minX = minX < coord.getX() ? minX : coord.getX();
            maxX = maxX > coord.getX() ? maxX : coord.getX();
            minY = minY < coord.getY() ? minY : coord.getY();
            double d2 = maxY = maxY > coord.getY() ? maxY : coord.getY();
        }
        this.maxCoord = new SpatialCoordinate(maxX, maxY);
        this.minCoord = new SpatialCoordinate(minX, minY);
    }

    public final ISpatialCoordinateList getCoordinates() {
        return this.getFactory().getListFactory().createSpatialCoordinateList(new ISpatialCoordinate[]{new SpatialCoordinate(this.getXmin(), this.getYmin()), new SpatialCoordinate(this.getXmax(), this.getYmin()), new SpatialCoordinate(this.getXmax(), this.getYmax()), new SpatialCoordinate(this.getXmin(), this.getYmax())});
    }

    public final double getXmax() {
        return this.maxCoord.getX();
    }

    public final double getXmin() {
        return this.minCoord.getX();
    }

    public final double getYmax() {
        return this.maxCoord.getY();
    }

    public final double getYmin() {
        return this.minCoord.getY();
    }

    public final void setXmax(double xmax) {
        this.maxCoord.setX(xmax);
    }

    public final void setXmin(double xmin) {
        this.minCoord.setX(xmin);
    }

    public final void setYmax(double ymax) {
        this.maxCoord.setY(ymax);
    }

    public final void setYmin(double Ymin) {
        this.minCoord.setY(Ymin);
    }

    public final ISpatialCoordinate getCentroid() {
        return new SpatialCoordinate((this.getXmin() + this.getXmax()) / 2.0, (this.getYmin() + this.getYmax()) / 2.0);
    }

    public final ISpatialCoordinate getCoordinate() {
        return this.getCentroid();
    }

    public final IEnvelope getEnvelope() {
        return this;
    }

    public final boolean isEmpty() {
        return Double.isNaN(this.getXmax()) || Double.isNaN(this.getXmin()) || Double.isNaN(this.getYmax()) || Double.isNaN(this.getYmin());
    }

    public final double getWidth() {
        return this.isEmpty() ? 0.0 : this.getXmax() - this.getXmin();
    }

    public final double getHeight() {
        return this.isEmpty() ? 0.0 : this.getYmax() - this.getYmin();
    }

    public final IPolygon toPolygone() {
        return this.getFactory().createPolygon(this.getFactory().getListFactory().createSpatialCoordinateList(new ISpatialCoordinate[]{new SpatialCoordinate(this.getXmin(), this.getYmin()), new SpatialCoordinate(this.getXmax(), this.getYmin()), new SpatialCoordinate(this.getXmax(), this.getYmax()), new SpatialCoordinate(this.getXmin(), this.getYmax()), new SpatialCoordinate(this.getXmin(), this.getYmin())}));
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof IEnvelope) {
            if (this.maxCoord != null && this.minCoord != null) {
                if (this.maxCoord.equals(new SpatialCoordinate(((IEnvelope)o2).getXmax(), ((IEnvelope)o2).getYmax())) && this.minCoord.equals(new SpatialCoordinate(((IEnvelope)o2).getXmin(), ((IEnvelope)o2).getYmin()))) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public final void setExtent(IEnvelope extent) {
        if (extent != null) {
            this.setXmin(extent.getXmin());
            this.setXmax(extent.getXmax());
            this.setYmin(extent.getYmin());
            this.setYmax(extent.getYmax());
        }
    }

    public final StringBuffer appendTo(StringBuffer sbuf) {
        if (sbuf == null) {
            sbuf = new StringBuffer();
        }
        sbuf.append("ENVELOPE40").append(this.maxCoord).append(", ").append(this.minCoord).append(" , ").append(this.getCentroid()).append(')');
        return sbuf;
    }
}

