/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.factory.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.factory.IGeometryListFactory;
import com.ibm.cst.ui.embedded.factory.impl.ListFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.Envelope;
import com.ibm.cst.ui.embedded.geometry.impl.LineString;
import com.ibm.cst.ui.embedded.geometry.impl.Point;
import com.ibm.cst.ui.embedded.geometry.impl.Polygon;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public final class GeometryFactory
implements IGeometryFactory {
    private static final IGeometryFactory defaultInstance = new GeometryFactory();
    private static final IGeometryListFactory listFactory = ListFactory.getInstance();

    public static IGeometryFactory getInstance() {
        return defaultInstance;
    }

    public final ILineString createLineString(ISpatialCoordinateList coords) {
        return new LineString(coords, this);
    }

    public final IPoint createPoint(ISpatialCoordinate coord) {
        return new Point(coord, this);
    }

    public final IEnvelope createEnvelope() {
        return this.createEnvelope(new SpatialCoordinate(Double.NaN, Double.NaN), new SpatialCoordinate(Double.NaN, Double.NaN));
    }

    public final IEnvelope createEnvelope(IEnvelope envel) {
        return envel == null ? null : new Envelope(envel);
    }

    public final IEnvelope createEnvelope(double maxX, double maxY, double minX, double minY) {
        return this.createEnvelope(new SpatialCoordinate(maxX, maxY), new SpatialCoordinate(minX, minY));
    }

    public final IEnvelope createEnvelope(ISpatialCoordinate max, ISpatialCoordinate min) {
        return new Envelope(max, min, this);
    }

    public final IEnvelope createEnvelope(ISpatialCoordinateList coords) {
        return new Envelope(coords, this);
    }

    public final IPolygon createPolygon(ISpatialCoordinateList ring) {
        return this.createPolygon(ring, null);
    }

    public final IPolygon createPolygon(ISpatialCoordinateList ring, int[] trianglesIndices) {
        return new Polygon(ring, trianglesIndices, this);
    }

    public final IGeometryListFactory getListFactory() {
        return listFactory;
    }
}

