/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.api.viewer;

import com.ibm.cst.ui.embedded.api.viewer.MapViewer;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.Map;
import com.ibm.cst.ui.embedded.map.Path;
import com.ibm.cst.ui.embedded.parser.MapWkTHandler;
import com.ibm.cst.ui.embedded.parser.Parser;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.uif.fsl.common.client.composite.CommonStandardForm;
import com.ibm.uif.fsl.common.client.payload.CommonPayload;
import com.ibm.uif.fsl.common.client.plugin.FSLCommonPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public abstract class MapViewerPlugin
extends FSLCommonPlugin {
    private CommonStandardForm $sf;
    protected Command $zoomIn;
    protected Command $zoomOut;
    protected Command $fullExtent;
    protected Command $toItinerary;
    public MapViewer $mapViewer;
    private String $userName;
    private final Parser $parser = new Parser();

    public MapViewerPlugin() {
        super("Map Viewer", null);
    }

    /*
     * WARNING - void declaration
     */
    protected Map loadMap(String mapFileSpec) {
        void var2_2;
        Map map = null;
        InputStream is = null;
        try {
            try {
                is = mapFileSpec.startsWith("/") ? this.getClass().getResourceAsStream(mapFileSpec) : Connector.openInputStream((String)mapFileSpec);
                this.trc("Opened stream " + is + " from " + mapFileSpec);
                Vector vectElems = this.parseWKT(is);
                this.trc("Parsed WKT, there are " + vectElems.size() + " elements");
                map = (Map)vectElems.elementAt(0);
            }
            catch (Exception ex) {
                this.log(ex);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    this.log(e2);
                }
            }
        }
        return var2_2;
    }

    public void initialise(Preferences preferences) {
        super.initialise(preferences);
        this.$userName = this.getPreferenceMgr().getGeneralPreferences().getDefaultClientID();
        String mapfile = (String)this.prefs.get("Mapfile");
        Map map = this.loadMap(mapfile);
        this.$mapViewer.setMap(map);
        String thumbLayerID = (String)this.prefs.get("thumb-layer");
        if (thumbLayerID != null) {
            this.$mapViewer.setThumbLayer(thumbLayerID);
        }
        this.$zoomIn = new Command("[#] Zoom In", 8, 1001);
        this.$zoomOut = new Command("[*] Zoom Out", 8, 1001);
        this.$fullExtent = new Command("[5] To Center", 8, 1001);
        this.$toItinerary = new Command("[1] To Itinerary", 8, 1001);
        this.$sf.addCommand(this.$zoomIn);
        this.$sf.addCommand(this.$zoomOut);
        this.$sf.addCommand(this.$fullExtent);
        this.$sf.setCommandListener(this);
    }

    public final Vector parseWKT(InputStream is) {
        Vector geomList = null;
        if (is != null) {
            MapWkTHandler handler = new MapWkTHandler();
            this.$parser.parse(is, handler);
            geomList = handler.getTopElements();
        }
        return geomList;
    }

    protected final StandardForm initialiseDisplay() {
        this.$sf = new CommonStandardForm(this);
        PreferencesManager.GeneralPreference gp = this.getPreferenceMgr().getGeneralPreferences();
        this.$sf.setBackground(this.getBackgroundImage(), gp.getDefaultBGColour());
        MapViewerPlugin mapViewerPlugin = this;
        Image connStatusImg = mapViewerPlugin.setConnectionStatusLogo(mapViewerPlugin.$sf, false);
        int titleMargin = connStatusImg == null ? -2 : -connStatusImg.getWidth();
        MapViewerPlugin mapViewerPlugin2 = this;
        StringWidget title = mapViewerPlugin2.createTitle(mapViewerPlugin2.getTitleTextColor());
        this.manageTitleAttachement(titleMargin);
        this.$mapViewer = new MapViewer();
        FormData mapFormData = new FormData();
        new FormData().top = new FormAttachment(this.getTitle(), 2);
        mapFormData.left = new FormAttachment(0, 2);
        mapFormData.right = new FormAttachment(100, -2);
        mapFormData.bottom = new FormAttachment(100, -2);
        this.$mapViewer.setLayoutData(mapFormData);
        this.$sf.append(title);
        this.$sf.append(this.$mapViewer);
        this.initializeListActionDialog(gp);
        return this.$sf;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.$zoomIn.equals(command)) {
            this.$mapViewer.zoomIn();
        } else if (this.$zoomOut.equals(command)) {
            this.$mapViewer.zoomOut();
        } else if (this.$fullExtent.equals(command)) {
            this.$mapViewer.toMapPlan();
        } else if (this.$toItinerary.equals(command)) {
            this.$mapViewer.toItinerary();
        } else {
            super.commandAction(command, displayable);
        }
    }

    public boolean keyPressed(int keyCode) {
        boolean bUnHandled = false;
        if (keyCode == 54 || keyCode == 104) {
            this.$mapViewer.toEast();
        } else if (keyCode == 52 || keyCode == 102) {
            this.$mapViewer.toWest();
        } else if (keyCode == 50 || keyCode == 116) {
            this.$mapViewer.toNorth();
        } else if (keyCode == 56 || keyCode == 98) {
            this.$mapViewer.toSouth();
        } else if (keyCode == 55 || keyCode == 42 || keyCode == 117 || keyCode == 118) {
            this.$mapViewer.zoomOut();
        } else if (keyCode == 57 || keyCode == 35 || keyCode == 106 || keyCode == 110) {
            this.$mapViewer.zoomIn();
        } else if (keyCode == 53 || keyCode == 103) {
            this.$mapViewer.toMapPlan();
        } else if (keyCode == 49 || keyCode == 114) {
            this.$mapViewer.toItinerary();
        } else {
            bUnHandled = !super.keyPressed(keyCode);
        }
        return !bUnHandled;
    }

    public final void pointerReleased(int x2, int y2) {
        this.$mapViewer.pointerReleased(x2, y2);
    }

    protected final void showMessage(CommonPayload pl) {
    }

    protected void showImage(CommonPayload pl) {
        String wkt = pl.getWkt();
        if (wkt != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(wkt.getBytes());
            Enumeration layers = this.parseWKT(is).elements();
            ILayer visitor = null;
            Vector<ILayer> itinerary = new Vector<ILayer>();
            while (layers.hasMoreElements()) {
                ILayer layer = (ILayer)layers.nextElement();
                if (layer instanceof Path) {
                    itinerary.addElement(layer);
                    continue;
                }
                if (layer.getName().equals("visitor")) {
                    visitor = layer;
                }
                this.$mapViewer.addLayer(layer);
            }
            Path[] paths = new Path[itinerary.size()];
            int i2 = 0;
            while (i2 < itinerary.size()) {
                paths[i2] = (Path)itinerary.elementAt(i2);
                ++i2;
            }
            this.$mapViewer.setItinerary(paths);
            if (visitor != null) {
                this.$mapViewer.toVisitor();
            }
            if (itinerary != null) {
                this.$sf.addCommand(this.$toItinerary);
            } else {
                this.$sf.removeCommand(this.$toItinerary);
            }
        }
        this.mainDisplay.repaint();
    }

    protected final void executeAction(Action action) {
        String requiredAction = action.getResponse();
        if (requiredAction.endsWith("Search") && !requiredAction.equals("elevatorSearch") && !requiredAction.startsWith("comfortRoomSearch")) {
            this.responseActionsInList = true;
        }
        super.executeAction(action);
    }
}

