/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.api.viewer;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.Envelope;
import com.ibm.cst.ui.embedded.graphics.Color;
import com.ibm.cst.ui.embedded.graphics.ISpatialGC;
import com.ibm.cst.ui.embedded.graphics.impl.SpatialGC;
import com.ibm.cst.ui.embedded.list.IGeometryList;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import com.ibm.cst.ui.embedded.list.impl.SpatialCoordinateList;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.Map;
import com.ibm.cst.ui.embedded.map.Path;
import com.ibm.rtk.CustomWidget;
import com.ibm.uif.fsl.common.client.composite.RollingMenu;
import javax.microedition.lcdui.Graphics;

public final class MapViewer
extends CustomWidget {
    private boolean $isTracking = false;
    public final long DOUBLE_CLICK_MAX_MILLIS;
    public final int DOUBLE_CLICK_PELS_APERTURE;
    public final int SCROLL_RATIO;
    public final int ZOOM_FACTOR;
    private IEnvelope $viewExtent = null;
    private ILayer $thumbLayer = null;
    private int $lastPointerX;
    private int $lastPointerY;
    private long $lastPointerMillis;
    private Map $map;
    private Path[] $itinerary;
    private double $halfZoom = 1.0;
    private RollingMenu menu;

    public MapViewer() {
        this((Map)null);
    }

    public MapViewer(Map map) {
        super(null);
        this.DOUBLE_CLICK_MAX_MILLIS = 500L;
        this.DOUBLE_CLICK_PELS_APERTURE = 2;
        this.SCROLL_RATIO = 30;
        this.ZOOM_FACTOR = 3;
        this.setMap(map);
        this.menu = new RollingMenu("");
    }

    public final void setMap(Map map) {
        this.$map = map;
        this.setViewExtent(map == null ? null : map.getExtent());
    }

    public final void setViewExtent(IEnvelope extent) {
        if (extent != null) {
            if (this.$viewExtent == null) {
                this.$viewExtent = new Envelope(extent);
            } else {
                this.$viewExtent.setExtent(extent);
            }
            this.form.repaint();
        }
    }

    public final void setThumbLayer(String layerID) {
        ILayer iLayer;
        if (layerID == null) {
            iLayer = null;
        } else {
            Map map = this.$map;
            iLayer = map.getLayer(map.findLayer(layerID));
        }
        this.$thumbLayer = iLayer;
    }

    public final void paint(Graphics g2, int w2, int h2) {
        this.paintVector(g2, w2, h2);
        this.menu.paint(g2, w2, h2);
    }

    public final void paintVector(Graphics g2, int width, int height) {
        g2.setColor(0, 0, 0);
        if (this.$viewExtent != null) {
            IEnvelope drawArea = MapViewer.fitRectangleToEnvelopeRatio(width, height, this.$viewExtent);
            SpatialGC gc = new SpatialGC(g2, drawArea, width, height);
            this.$halfZoom = gc.getZoom() / 2.0;
            this.$map.draw(gc, drawArea);
            if (this.$isTracking) {
                this.paintThumb(g2, gc, width, height, drawArea);
            }
        }
    }

    protected final void paintThumb(Graphics g2, ISpatialGC gc, int width, int height, IEnvelope drawArea) {
        if (this.$thumbLayer != null) {
            int thumbW = width / 4;
            int thumbH = height / 4;
            gc.setForeground(Color.RED);
            gc.drawCrossHair(drawArea.getCentroid(), (thumbW + thumbH) / 12);
            IEnvelope mapExtent = this.$map.getExtent();
            SpatialGC gcThumb = new SpatialGC(g2, mapExtent, thumbW, thumbH);
            this.$thumbLayer.draw(gcThumb, mapExtent);
            gcThumb.setForeground(Color.GRAY);
            gcThumb.drawEnvelope(drawArea);
            gcThumb.setForeground(Color.RED);
            gcThumb.drawCrossHair(drawArea.getCentroid(), (thumbW + thumbH) / 24);
        }
    }

    public final void toItinerary() {
        Envelope envel;
        if (this.$map != null && this.$itinerary != null && this.$itinerary.length > 0 && (envel = this.getItineraryEnvelope()) != null) {
            double margeL = envel.getWidth() / 10.0;
            double margeH = envel.getHeight() / 10.0;
            Envelope newEnvel = new Envelope(envel.getXmax() + margeL, envel.getYmax() + margeH, envel.getXmin() - margeL, envel.getYmin() - margeH);
            final double minXDelta = (newEnvel.getXmin() - this.$viewExtent.getXmin()) / 10.0;
            final double maxXDelta = (newEnvel.getXmax() - this.$viewExtent.getXmax()) / 10.0;
            final double minYDelta = (newEnvel.getYmin() - this.$viewExtent.getYmin()) / 10.0;
            final double maxYDelta = (newEnvel.getYmax() - this.$viewExtent.getYmax()) / 10.0;
            new Thread(){

                public final void run() {
                    int i2 = 0;
                    while (i2 < 10) {
                        Envelope envel = new Envelope(MapViewer.this.$viewExtent.getXmax() + maxXDelta, MapViewer.this.$viewExtent.getYmax() + maxYDelta, MapViewer.this.$viewExtent.getXmin() + minXDelta, MapViewer.this.$viewExtent.getYmin() + minYDelta);
                        MapViewer.this.setViewExtent(envel);
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++i2;
                    }
                }
            }.start();
        }
    }

    private final void addGeometriesCoordinates(ISpatialCoordinateList list, IGeometryList list2) {
        int i2 = 0;
        while (i2 < list2.length()) {
            IGeometry geo = list2.get(i2);
            ISpatialCoordinateList geometryCoordinates = geo.getCoordinates();
            int j2 = 0;
            while (j2 < geometryCoordinates.length()) {
                list.add(geometryCoordinates.get(j2));
                ++j2;
            }
            ++i2;
        }
    }

    public final void toMapPlan() {
        if (this.$map != null) {
            MapViewer mapViewer = this;
            mapViewer.setViewExtent(mapViewer.$map.getExtent());
        }
    }

    public final void toEast() {
        this.transform(3, 0);
    }

    public final void toWest() {
        this.transform(-3, 0);
    }

    public final void toNorth() {
        this.transform(0, -3);
    }

    public final void toSouth() {
        this.transform(0, 3);
    }

    public final void zoomOut() {
        this.transform(3, 3);
    }

    public final void zoomIn() {
        this.transform(-3, -3);
    }

    public final void transform(final int zoomFactorX, final int zoomFactorY) {
        if (this.$viewExtent != null) {
            new Thread(){

                public final void run() {
                    double zoomWidth = 0.0;
                    double zoomHeigth = 0.0;
                    if (zoomFactorX != 0) {
                        zoomWidth = (double)zoomFactorX * MapViewer.this.$viewExtent.getWidth() / 30.0;
                    }
                    if (zoomFactorY != 0) {
                        zoomHeigth = (double)zoomFactorY * MapViewer.this.$viewExtent.getHeight() / 30.0;
                    }
                    double indiceWidth = zoomWidth / 10.0;
                    double indiceHeigth = zoomHeigth / 10.0;
                    double i2 = 1.0;
                    while (i2 <= 10.0) {
                        MapViewer.this.$viewExtent.setXmax(MapViewer.this.$viewExtent.getXmax() + indiceWidth);
                        MapViewer.this.$viewExtent.setXmin(MapViewer.this.$viewExtent.getXmin() + (double)(zoomFactorY == 0 ? 1 : -1) * indiceWidth);
                        MapViewer.this.$viewExtent.setYmax(MapViewer.this.$viewExtent.getYmax() + indiceHeigth);
                        MapViewer.this.$viewExtent.setYmin(MapViewer.this.$viewExtent.getYmin() + (double)(zoomFactorX == 0 ? 1 : -1) * indiceHeigth);
                        MapViewer.this.form.repaint();
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        i2 += 1.0;
                    }
                }
            }.start();
        }
    }

    public final void scroolToItinerary() {
        Envelope envel;
        if (this.$map != null && this.$itinerary != null && this.$itinerary.length > 0 && (envel = this.getItineraryEnvelope()) != null) {
            if (envel.getHeight() > this.$viewExtent.getHeight() || envel.getWidth() > this.$viewExtent.getWidth()) {
                this.toItinerary();
            } else {
                ISpatialCoordinate coord = envel.getCentroid();
                this.centerTo(coord, envel);
            }
        }
    }

    private final void centerTo(ISpatialCoordinate coord, final Envelope envel) {
        double xMax = this.$viewExtent.getXmax();
        double xMin = this.$viewExtent.getXmin();
        double yMax = this.$viewExtent.getYmax();
        double yMin = this.$viewExtent.getYmin();
        final double deltaX = (coord.getX() - (xMax + xMin) / 2.0) / 10.0;
        final double deltaY = (coord.getY() - (yMax + yMin) / 2.0) / 10.0;
        new Thread(){

            public final void run() {
                double i2 = 1.0;
                while (i2 <= 10.0) {
                    double newXMax = MapViewer.this.$viewExtent.getXmax() + deltaX;
                    double newXMin = MapViewer.this.$viewExtent.getXmin() + deltaX;
                    if (newXMax <= MapViewer.this.$map.getExtent().getXmax() && newXMin >= MapViewer.this.$map.getExtent().getXmin()) {
                        MapViewer.this.$viewExtent.setXmax(newXMax);
                        MapViewer.this.$viewExtent.setXmin(newXMin);
                    }
                    double newYMax = MapViewer.this.$viewExtent.getYmax() + deltaY;
                    double newYMin = MapViewer.this.$viewExtent.getYmin() + deltaY;
                    if (newYMax <= MapViewer.this.$map.getExtent().getYmax() && newYMin >= MapViewer.this.$map.getExtent().getYmin()) {
                        MapViewer.this.$viewExtent.setYmax(MapViewer.this.$viewExtent.getYmax() + deltaY);
                        MapViewer.this.$viewExtent.setYmin(MapViewer.this.$viewExtent.getYmin() + deltaY);
                    }
                    MapViewer.this.form.repaint();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    i2 += 1.0;
                }
                if (envel != null && (envel.getHeight() > MapViewer.this.$viewExtent.getHeight() || envel.getWidth() > MapViewer.this.$viewExtent.getWidth())) {
                    MapViewer.this.toItinerary();
                }
            }
        }.start();
    }

    private final Envelope getItineraryEnvelope() {
        ILayer visitor = null;
        int i2 = 0;
        while (i2 < this.$map.getLayers().length) {
            ILayer layer = this.$map.getLayer(i2);
            if (layer.getName().equals("visitor")) {
                visitor = layer;
                break;
            }
            ++i2;
        }
        SpatialCoordinateList list = new SpatialCoordinateList();
        this.addGeometriesCoordinates(list, visitor.getGeometryList());
        int i3 = 0;
        while (i3 < this.$itinerary.length) {
            IGeometryList itinaryGeoms = this.$itinerary[i3].getGeometryList();
            this.addGeometriesCoordinates(list, itinaryGeoms);
            ++i3;
        }
        Envelope envel = new Envelope(list, null);
        return envel;
    }

    public final void toVisitor() {
        ILayer visitor = null;
        int i2 = 0;
        while (i2 < this.$map.getLayers().length) {
            ILayer layer = this.$map.getLayer(i2);
            if (layer.getName().equals("visitor")) {
                visitor = layer;
                break;
            }
            ++i2;
        }
        if (visitor == null || visitor.getGeometryList() == null || visitor.getGeometryList().length() == 0) {
            return;
        }
        ISpatialCoordinate coord = visitor.getGeometryList().get(0).getCoordinate();
        this.centerTo(coord, null);
    }

    public final void pointerDragged(int x2, int y2) {
        super.pointerDragged(x2, y2);
        if (this.$viewExtent != null) {
            int deltaX = x2 - this.$lastPointerX;
            int deltaY = y2 - this.$lastPointerY;
            IEnvelope iEnvelope = this.$viewExtent;
            iEnvelope.setXmax(iEnvelope.getXmax() - (double)deltaX * this.$halfZoom);
            IEnvelope iEnvelope2 = this.$viewExtent;
            iEnvelope2.setXmin(iEnvelope2.getXmin() - (double)deltaX * this.$halfZoom);
            IEnvelope iEnvelope3 = this.$viewExtent;
            iEnvelope3.setYmax(iEnvelope3.getYmax() + (double)deltaY * this.$halfZoom);
            IEnvelope iEnvelope4 = this.$viewExtent;
            iEnvelope4.setYmin(iEnvelope4.getYmin() + (double)deltaY * this.$halfZoom);
            this.$lastPointerX = x2;
            this.$lastPointerY = y2;
        }
        this.form.repaint();
    }

    protected final void pointerReleased(int x2, int y2) {
        this.$isTracking = false;
        this.form.repaint();
        super.pointerReleased(x2, y2);
    }

    protected final void pointerPressed(int x2, int y2) {
        super.pointerPressed(x2, y2);
        this.$isTracking = true;
        long timeMillis = System.currentTimeMillis();
        if (this.$lastPointerX - x2 <= 2 && this.$lastPointerX - x2 >= -2 && this.$lastPointerY - y2 <= 2 && this.$lastPointerY - y2 >= -2 && timeMillis - this.$lastPointerMillis < 500L) {
            this.doubleClicked(x2, y2);
            this.$lastPointerMillis = 0L;
        } else {
            this.$lastPointerMillis = timeMillis;
        }
        this.$lastPointerX = x2;
        this.$lastPointerY = y2;
        this.menu.touchPressed(x2, y2);
    }

    protected final void doubleClicked(int x2, int y2) {
        switch (this.menu.getCurrentAction()) {
            case 0: {
                this.toMapPlan();
                break;
            }
            case 1: {
                this.zoomIn();
                break;
            }
            case 2: {
                this.zoomOut();
            }
        }
    }

    public static IEnvelope fitRectangleToEnvelopeRatio(int width, int height, IEnvelope rectBounds) {
        double adjustH;
        double adjustW;
        double rectHOri;
        double cltRatioWonH = (double)width / (double)height;
        double rectWOri = rectBounds.getWidth();
        if (rectWOri < (rectHOri = rectBounds.getHeight()) * cltRatioWonH) {
            adjustW = (rectWOri - rectHOri * cltRatioWonH) / 2.0;
            adjustH = 0.0;
        } else {
            adjustH = (rectHOri - rectWOri / cltRatioWonH) / 2.0;
            adjustW = 0.0;
        }
        double minX = rectBounds.getXmin() + adjustW;
        double minY = rectBounds.getYmin() + adjustH;
        double maxX = rectBounds.getXmax() - adjustW;
        double maxY = rectBounds.getYmax() - adjustH;
        return new Envelope(maxX, maxY, minX, minY);
    }

    public final void addLayer(ILayer layer) {
        this.$map.addLayer(layer);
    }

    public final void setItinerary(Path[] itinerary) {
        if (itinerary != null && itinerary.length > 0) {
            int i2 = 0;
            while (i2 < itinerary.length) {
                this.$map.addLayer(itinerary[i2]);
                ++i2;
            }
        } else if (this.$itinerary != null && this.$itinerary.length > 0) {
            int i3 = 0;
            while (i3 < this.$itinerary.length) {
                int idxLayer = this.$map.findLayer(this.$itinerary[i3].getName());
                if (idxLayer >= 0) {
                    this.$map.clearLayer(idxLayer);
                }
                ++i3;
            }
        }
        this.$itinerary = itinerary;
    }

    public final Path[] getItinerary() {
        return this.$itinerary;
    }
}

