/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.common.client.plugin.location;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.uif.fsl.common.client.plugin.location.CameraListener;
import com.ibm.uif.fsl.common.client.plugin.location.CameraViewer;
import com.ibm.uif.fsl.common.client.plugin.location.ImageDecoder;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;

public abstract class ImageProvider
extends AbstractPlugin
implements CameraListener {
    private static String LOC_TOPIC_PREFIX_KEY = "publishTopicPrefix";
    private static String DECODER_NAME = "decoderName";
    private boolean isCameraSupported = false;
    protected ImageDecoder decoder;
    protected static CameraViewer camera;
    protected long decodingTime;

    public ImageProvider(String arg0) {
        super(arg0);
        if (System.getProperty("supports.video.capture") != null && System.getProperty("supports.video.capture").equalsIgnoreCase("true")) {
            this.isCameraSupported = true;
        }
    }

    public final void initialise(Preferences prefs) {
        super.initialise(prefs);
        String decoderClassName = (String)prefs.get(DECODER_NAME);
        if (decoderClassName != null) {
            this.initializeDecoder(decoderClassName);
        }
        if (this.isCameraSupported) {
            camera = this.getCameraViewer();
        }
    }

    protected final CameraViewer getCameraViewer() {
        if (camera == null) {
            camera = new CameraViewer();
        }
        return camera;
    }

    protected final Displayable getDisplayable() {
        return Display.getDisplay((MIDlet)UniversalCommunicator.getInbox()).getCurrent();
    }

    protected final void initializeDecoder(String decoderClassName) {
        try {
            Class<?> decoderClass = Class.forName(decoderClassName);
            this.decoder = (ImageDecoder)decoderClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassNotFoundException e2 = classNotFoundException;
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException e3 = illegalAccessException;
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            InstantiationException e4 = instantiationException;
            instantiationException.printStackTrace();
        }
    }

    protected final void setListener() {
        camera.setCameraListener(this);
    }

    public final void start() {
        if (camera != null && !ImageProvider.camera.IS_IN_USE) {
            try {
                ImageProvider.camera.IS_IN_USE = true;
                this.setListener();
                camera.start(this.getDisplayable());
            }
            catch (SecurityException securityException) {
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public final void pictureShot(byte[] pngImage) {
        if (pngImage != null) {
            String decodedText = null;
            byte[] decodedStream = null;
            if (this.decoder != null) {
                Image image = Image.createImage((byte[])pngImage, (int)0, (int)pngImage.length);
                long t1 = System.currentTimeMillis();
                try {
                    decodedStream = this.decoder.decodeImage(image);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.decodingTime = System.currentTimeMillis() - t1;
            }
            if (decodedStream != null) {
                decodedText = new String(decodedStream);
            }
            if (this.isCameraSupported) {
                this.imageDecoded(decodedText, pngImage);
            }
        }
    }

    protected abstract void imageDecoded(String var1, byte[] var2);
}

