/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uif.fsl.common.client.plugin;

import com.ibm.mobile.uib.Common;
import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.plugins.AbstractVisualPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.PreferenceException;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.Composite;
import com.ibm.rtk.CustomWidget;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.ListWidget;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringAttr;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.ValueListener;
import com.ibm.uif.fsl.common.MIAClientMidlet;
import com.ibm.uif.fsl.common.action.ActionsManager;
import com.ibm.uif.fsl.common.action.ToHelpCommand;
import com.ibm.uif.fsl.common.action.ToPluginCommand;
import com.ibm.uif.fsl.common.client.composite.CommonStandardForm;
import com.ibm.uif.fsl.common.client.composite.FslPopupForm;
import com.ibm.uif.fsl.common.client.composite.KeyListener;
import com.ibm.uif.fsl.common.client.payload.CommonPayload;
import com.ibm.uif.fsl.common.client.plugin.location.CommonBTLocationProvider;
import com.ibm.uif.fsl.data.DataRequest;
import com.ibm.uif.fsl.data.IDataRequest;
import com.ibm.uif.fsl.data.images.ImageManager;
import com.ibm.uif.fsl.data.plugin.IDataListener;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public abstract class FSLCommonPlugin
extends AbstractVisualPlugin
implements IDataListener,
KeyListener {
    public static Image arrowRight;
    private Preferences pluginPreference = null;
    private Timer $blinkTimer = null;
    private boolean $blinkStep = false;
    private Image $blinkIcon = null;
    private StringWidget imgWidget;
    private Vector msgWidgets = new Vector();
    private StringWidget title;
    protected FormData imgFormData;
    protected FormData msgFormData;
    protected CommonPayload currentPayLoad;
    private Vector commands = new Vector();
    private Vector keys = new Vector();
    protected boolean responseActionsInList = false;
    protected StandardForm listDetailForm;
    protected ListWidget listActionsWidget;
    protected int lastSelectedIndex = -1;
    private boolean isImageAboveMessage = true;
    private static Translator translator;
    public static int messageVSimage;
    private Command showVideo = null;
    protected StringBuffer ttsMessage = new StringBuffer();
    private PlaySoundThread playSoundThread;

    static {
        messageVSimage = 2;
    }

    public FSLCommonPlugin(String arg0, String arg1) {
        super(arg0, arg1, null);
        arrowRight = this.loadImage("fleche_droite.png");
    }

    public static String extractGeneralPref(String prefKey, String defaultValue) {
        String value = defaultValue;
        Preferences p2 = new Preferences("General-Prefs");
        try {
            p2.load();
            if (p2.isEmpty()) {
                p2.store(UniversalCommunicator.getInbox().getAppProperty(Common.GENERAL_PREFS_KEY));
            }
            if ((value = p2.getString(prefKey)) == null) {
                value = defaultValue;
            }
        }
        catch (PreferenceException preferenceException) {
            // empty catch block
        }
        return value;
    }

    public static String getNLSString(String key) {
        String result;
        if (translator == null) {
            translator = (Translator)PluginManager.getManager().getPlugin(Translator.PLUGIN_NAME);
        }
        if ((result = translator.getKey(key)) != null && result.length() > 0) {
            int i2;
            while ((i2 = result.indexOf("\\n")) >= 0) {
                result = String.valueOf(result.substring(0, i2)) + '\n' + result.substring(i2 + 2);
            }
        }
        return result;
    }

    public void initialise(Preferences preferences) {
        String s2;
        this.pluginPreference = preferences;
        super.initialise(preferences);
        String blinkIconName = preferences.getString("tab-icon-blink");
        if (blinkIconName != null) {
            this.$blinkIcon = this.loadImage(blinkIconName);
        }
        if (preferences.get("Tab-title") != null) {
            s2 = preferences.getString("Tab-title");
            this.title.setItems(s2);
        }
        if (preferences.get("image_above") != null) {
            s2 = preferences.getString("image_above");
            this.setImageAboveMessage(s2.equals("true"));
        }
        this.showVideo = new Command(FSLCommonPlugin.getNLSString("showVideo"), 8, 1001);
    }

    protected final Image getBackgroundImage() {
        Image image = null;
        String preferenceBGImage = null;
        if (this.pluginPreference.get("BG-Image") != null) {
            preferenceBGImage = this.pluginPreference.getString("BG-Image");
        }
        try {
            image = preferenceBGImage != null ? this.loadImage(preferenceBGImage) : super.getBackgroundImage();
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            image = super.getBackgroundImage();
        }
        return image;
    }

    protected final int getTitleTextColor() {
        return this.getColor("text-title-colour");
    }

    protected final int getBodyTextColor() {
        return this.getColor("text-body-colour");
    }

    private final int getColor(String key) {
        int color = 0;
        String prefColor = null;
        if (this.pluginPreference.get(key) != null) {
            prefColor = this.pluginPreference.getString(key);
        }
        try {
            color = prefColor != null ? Integer.parseInt(prefColor, 16) : this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour();
        }
        catch (Exception e2) {
            color = this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour();
        }
        return color;
    }

    protected StandardForm initialiseDisplay() {
        CommonStandardForm form = new CommonStandardForm(this);
        PreferencesManager.GeneralPreference gp = this.getPreferenceMgr().getGeneralPreferences();
        form.setBackground(this.getBackgroundImage(), gp.getDefaultBGColour());
        FSLCommonPlugin fSLCommonPlugin = this;
        fSLCommonPlugin.createTitle(fSLCommonPlugin.getTitleTextColor());
        this.imgWidget = Style.createStringWidget("", this.getBodyTextColor(), true);
        StringWidget msgWidget = Style.createStringWidget("", this.getBodyTextColor(), true);
        this.msgWidgets.addElement(msgWidget);
        Image connStatusImg = this.setConnectionStatusLogo(form, false);
        int titleMarge = connStatusImg == null ? -2 : -connStatusImg.getWidth();
        this.manageTitleAttachement(titleMarge);
        this.manageImageAttachement();
        form.append(this.title);
        form.append(msgWidget);
        form.append(this.imgWidget);
        this.initializeListActionDialog(gp);
        return form;
    }

    protected final void manageTitleAttachement(int titleMarge) {
        FormData titleFormData = new FormData();
        new FormData().top = new FormAttachment(0, 2);
        titleFormData.left = new FormAttachment(0, 2);
        titleFormData.right = new FormAttachment(100, titleMarge);
        this.title.setLayoutData(titleFormData);
    }

    protected final StringWidget createTitle(int tc) {
        String s2 = FSLCommonPlugin.getNLSString(String.valueOf(this.name) + "_plugin_title");
        if (s2 == null || s2.length() == 0) {
            s2 = this.name;
        }
        this.title = Style.createHeading(s2, tc);
        this.title.drawfocus = false;
        return this.title;
    }

    protected final void manageImageAttachement() {
        if (this.msgWidgets.size() != 0) {
            StringWidget previous = this.title;
            if (this.isImageAboveMessage || this.imgWidget.getItems() == null || this.imgWidget.getItems() != null && !(this.imgWidget.getItems() instanceof Image)) {
                int i2 = 0;
                while (i2 < this.msgWidgets.size()) {
                    this.msgFormData = new FormData();
                    this.msgFormData.top = new FormAttachment(previous, 2);
                    this.msgFormData.left = new FormAttachment(0, 2);
                    this.msgFormData.right = new FormAttachment(100, -2);
                    ((StringWidget)((Object)this.msgWidgets.elementAt(i2))).setLayoutData(this.msgFormData);
                    previous = (StringWidget)((Object)this.msgWidgets.elementAt(i2));
                    ++i2;
                }
                this.imgFormData = new FormData();
                this.imgFormData.top = new FormAttachment(previous, 2);
                this.imgFormData.left = new FormAttachment(0, 2);
                this.imgFormData.right = new FormAttachment(100, -2);
                this.imgWidget.setLayoutData(this.imgFormData);
            } else {
                this.imgFormData = new FormData();
                this.imgFormData.top = new FormAttachment(previous, 2);
                this.imgFormData.left = new FormAttachment(0, 2);
                this.imgFormData.right = new FormAttachment(100 / messageVSimage, -2);
                this.imgWidget.setLayoutData(this.imgFormData);
                int i3 = 0;
                while (i3 < this.msgWidgets.size()) {
                    this.msgFormData = new FormData();
                    this.msgFormData.top = new FormAttachment(previous, 2);
                    this.msgFormData.left = new FormAttachment(this.imgWidget, 2);
                    this.msgFormData.right = new FormAttachment(100, -2);
                    ((StringWidget)((Object)this.msgWidgets.elementAt(i3))).setLayoutData(this.msgFormData);
                    previous = (StringWidget)((Object)this.msgWidgets.elementAt(i3));
                    ++i3;
                }
            }
        }
    }

    protected final void initializeListActionDialog(PreferencesManager.GeneralPreference gp) {
        this.listDetailForm = new StandardForm();
        this.listDetailForm.setBackground(this.getBackgroundImage(), gp.getDefaultBGColour());
        this.listActionsWidget = new ListWidget(Font.getDefaultFont(), 1);
        this.listActionsWidget.highlightbg = this.getPreferenceMgr().getGeneralPreferences().getDefaultHLColour();
        this.listActionsWidget.drawfocus = false;
        this.listActionsWidget.autoscroll = true;
        Composite listScroll = this.listActionsWidget.attachScroll(false);
        this.listActionsWidget.setCriteria(1);
        FormData data = new FormData();
        new FormData().top = new FormAttachment(2, 2);
        data.left = new FormAttachment(2, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        listScroll.setLayoutData(data);
        this.listDetailForm.append(listScroll);
    }

    public final void enable() {
        super.enable();
        this.addManagedActions();
    }

    public void addManagedActions() {
        this.getDisplay().addCommand(ActionsManager.getActionsManager().getExitAction());
    }

    public void removeManagedActions() {
        this.getDisplay().removeCommand(ActionsManager.getActionsManager().getExitAction());
    }

    public void messageArrived(Message msg) {
        this.currentPayLoad = this.getPayLoad(msg.getDataString());
        if (!this.responseActionsInList) {
            if (this.currentPayLoad.isAlert()) {
                ((MIAClientMidlet)UniversalCommunicator.getInbox()).showPlugin(this);
                this.alerter.alert();
            }
            FSLCommonPlugin fSLCommonPlugin = this;
            fSLCommonPlugin.showContent(fSLCommonPlugin.currentPayLoad);
        } else {
            this.listActionsWidget.setListener(null);
            Style.showAsDialog(this.mainDisplay, this.listDetailForm, 1);
        }
        FSLCommonPlugin fSLCommonPlugin = this;
        fSLCommonPlugin.initializeVideoCommand(fSLCommonPlugin.currentPayLoad);
        FSLCommonPlugin fSLCommonPlugin2 = this;
        fSLCommonPlugin2.generateCommands(fSLCommonPlugin2.currentPayLoad.getActions());
        if (this.responseActionsInList) {
            this.listActionsWidget.selectedindex = 0;
            this.listActionsWidget.selected = (CustomWidget)((Object)this.listActionsWidget.v.elementAt(0));
        }
        this.listActionsWidget.setListener(new ValueListener(){

            public final boolean valueNotify(int arg0, Object arg1) {
                if (FSLCommonPlugin.this.responseActionsInList && arg0 != -2 && arg1 instanceof StringWidget) {
                    int i2;
                    FSLCommonPlugin.this.responseActionsInList = false;
                    FSLCommonPlugin.this.lastSelectedIndex = i2 = FSLCommonPlugin.this.listActionsWidget.v.indexOf(arg1);
                    if (i2 != -1) {
                        FSLCommonPlugin.this.listActionsWidget.setHighlight(i2);
                        FSLCommonPlugin.this.listActionsWidget.removeAll();
                        FSLCommonPlugin.this.listDetailForm.dispose();
                        FSLCommonPlugin.this.mainDisplay.dismissDialog();
                        FSLCommonPlugin fSLCommonPlugin = FSLCommonPlugin.this;
                        fSLCommonPlugin.executeAction(fSLCommonPlugin.currentPayLoad.getActions()[i2]);
                    }
                } else if (arg0 == -2 && arg1 instanceof StringWidget) {
                    FSLCommonPlugin.this.speak(((StringWidget)((Object)arg1)).getData());
                }
                return false;
            }
        });
        this.mainDisplay.doLayout();
        this.listDetailForm.doLayout();
        FSLCommonPlugin fSLCommonPlugin3 = this;
        fSLCommonPlugin3.playSound(fSLCommonPlugin3.currentPayLoad.getAudioURL());
    }

    private final void playSound(String string) {
        if (this.playSoundThread == null) {
            this.playSoundThread = new PlaySoundThread();
        }
        this.playSoundThread.stop();
        if (string == null || string.length() == 0) {
            return;
        }
        this.playSoundThread.setAudio(string);
        this.playSoundThread.run();
    }

    protected final Image loadImage(String imageName) {
        if (imageName != null) {
            try {
                if (!imageName.startsWith("/")) {
                    imageName = "/images/" + imageName;
                }
                return ImageManager.getImage(imageName);
            }
            catch (IOException e2) {
                this.log(e2);
            }
        }
        return null;
    }

    protected final CommonPayload getPayLoad(String string) {
        return new CommonPayload(string);
    }

    protected final void initializeVideoCommand(CommonPayload pl) {
        this.mainDisplay.removeCommand(this.showVideo);
        if (pl.getURL() != null && pl.getURL().length() > 0) {
            this.mainDisplay.addCommand(this.showVideo);
        }
    }

    protected final void showContent(CommonPayload pl) {
        this.ttsMessage = new StringBuffer();
        this.showImage(pl);
        this.showTitle(pl);
        this.showMessage(pl);
        this.manageImageAttachement();
        if (this.focus) {
            FSLCommonPlugin fSLCommonPlugin = this;
            fSLCommonPlugin.speak(fSLCommonPlugin.ttsMessage);
        } else {
            this.blinkIcon(true);
        }
    }

    protected void showMessage(CommonPayload pl) {
        this.showMessage(pl.getBody());
    }

    protected void showMessage(String body) {
        try {
            if (this.getMsgWidgets() != null && this.getMsgWidgets().size() > 0 && body != null) {
                int index;
                String sentence = body;
                Vector<String> paragraphes = new Vector<String>();
                while ((index = sentence.indexOf(10)) >= 0) {
                    paragraphes.addElement(sentence.substring(0, index));
                    sentence = sentence.substring(index + 1);
                }
                paragraphes.addElement(sentence);
                if (paragraphes.size() != this.getMsgWidgets().size()) {
                    int i2 = 0;
                    while (i2 < this.getMsgWidgets().size()) {
                        this.getDisplay().remove((StringWidget)((Object)this.getMsgWidgets().elementAt(i2)));
                        ++i2;
                    }
                    if (this.imgWidget != null) {
                        this.getDisplay().remove(this.imgWidget);
                    }
                    while (paragraphes.size() > this.getMsgWidgets().size()) {
                        StringWidget msgWidget = Style.createStringWidget("", this.getBodyTextColor(), true);
                        this.getMsgWidgets().addElement(msgWidget);
                    }
                    while (paragraphes.size() < this.getMsgWidgets().size()) {
                        StringWidget msgWidget = (StringWidget)((Object)this.getMsgWidgets().lastElement());
                        this.getMsgWidgets().removeElement((Object)msgWidget);
                    }
                    i3 = 0;
                    while (i3 < this.getMsgWidgets().size()) {
                        this.getDisplay().append((StringWidget)((Object)this.getMsgWidgets().elementAt(i3)));
                        ++i3;
                    }
                    if (this.imgWidget != null) {
                        this.getDisplay().append(this.imgWidget);
                    }
                    this.manageImageAttachement();
                }
                int i3 = 0;
                while (i3 < paragraphes.size()) {
                    ((StringWidget)((Object)this.getMsgWidgets().elementAt(i3))).setItems((String)paragraphes.elementAt(i3));
                    ++i3;
                }
                this.ttsMessage.append(" : " + body);
                this.ttsMessage.append("\n");
            }
        }
        catch (Throwable th) {
            this.log.severe(th.getMessage());
        }
    }

    protected void showImage(CommonPayload pl) {
        this.getImgWidget().setItems(null);
        if (this.imgWidget != null) {
            Image image = null;
            String imageURL = pl.getImageURL();
            if (imageURL.length() > 0) {
                try {
                    image = ImageManager.getImage(imageURL);
                    if (image == null) {
                        IDataRequest r = DataRequest.getDataRequest();
                        r.sendRequest("getImage?" + imageURL + "#" + this.getName());
                    } else {
                        this.imageArrived(image);
                    }
                }
                catch (IOException iOException) {
                    IOException e1 = iOException;
                    iOException.printStackTrace();
                }
            }
        }
    }

    public final void imageArrived(Image image) {
        if (image != null) {
            double ratioHeigth;
            Image rescaledImage = null;
            double ratioWidth = (double)this.mainDisplay.getWidth() / (double)image.getWidth();
            if (!this.isImageAboveMessage) {
                ratioWidth /= 2.0;
            }
            int mainDisplayHeigth = this.mainDisplay.getHeight();
            if (this.getTitle() != null) {
                mainDisplayHeigth -= this.getTitle().getMinContentHeight();
            }
            if (ratioWidth < (ratioHeigth = (double)mainDisplayHeigth / (double)image.getHeight())) {
                Image image2 = image;
                rescaledImage = this.rescaleImage(image2, (int)((double)image2.getWidth() * ratioWidth), (int)((double)image.getHeight() * ratioWidth));
            } else {
                Image image3 = image;
                rescaledImage = this.rescaleImage(image3, (int)((double)image3.getWidth() * ratioHeigth), (int)((double)image.getHeight() * ratioHeigth));
            }
            this.imgWidget.setItems(rescaledImage);
        } else {
            this.imgWidget.setItems(null);
        }
        this.manageImageAttachement();
        this.mainDisplay.doLayout();
    }

    protected final Image rescaleImage(Image image, int width, int height) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        Image newImage = Image.createImage((int)width, (int)height);
        Graphics g2 = newImage.getGraphics();
        int y2 = 0;
        while (y2 < height) {
            int x2 = 0;
            while (x2 < width) {
                g2.setClip(x2, y2, 1, 1);
                int dx = x2 * sourceWidth / width;
                int dy = y2 * sourceHeight / height;
                g2.drawImage(image, x2 - dx, y2 - dy, 20);
                ++x2;
            }
            ++y2;
        }
        return Image.createImage((Image)newImage);
    }

    protected final void showTitle(CommonPayload pl) {
        try {
            if (this.title != null && pl.getSubject() != null) {
                this.title.setItems(pl.getSubject());
                this.ttsMessage.append(pl.getSubject());
                this.ttsMessage.append("\n");
            }
        }
        catch (Throwable th) {
            this.log.severe(th.getMessage());
        }
    }

    private final void generateCommands(Action[] actions) {
        this.removeActions();
        this.keys.removeAllElements();
        if (actions != null) {
            int i2 = 0;
            while (i2 < actions.length) {
                String key = "XXX";
                boolean isVisible = true;
                if (actions[i2].getKey() != null && (key = actions[i2].getKey()).startsWith("!")) {
                    key = key.substring(1);
                    isVisible = false;
                }
                this.keys.addElement(key);
                this.generateAction(actions[i2], isVisible);
                ++i2;
            }
        }
    }

    protected final void removeActions() {
        int i2 = 0;
        while (i2 < this.commands.size()) {
            if (this.commands.elementAt(i2) != null) {
                this.mainDisplay.removeCommand((Command)this.commands.elementAt(i2));
            }
            ++i2;
        }
        this.commands.removeAllElements();
    }

    protected final void generateAction(Action action, boolean isVisible) {
        if (!this.responseActionsInList) {
            Command cmd = new Command(action.getLabel(), 8, 1001);
            this.addCommand(cmd, isVisible);
        } else {
            PreferencesManager.GeneralPreference gp = this.getPreferenceMgr().getGeneralPreferences();
            int textColour = this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour();
            StringWidget sw = Style.createStringWidget("", textColour);
            Vector<Object> v2 = new Vector<Object>();
            v2.addElement(arrowRight);
            v2.addElement(action.getLabel());
            sw.setItems(v2);
            this.listActionsWidget.append(sw);
        }
    }

    protected final void addCommand(Command cmd, boolean isVisible) {
        this.commands.addElement(cmd);
        if (isVisible) {
            this.mainDisplay.addCommand(cmd);
        }
    }

    public void commandAction(Command aCommand, Displayable aDisplayable) {
        if (aCommand == ActionsManager.getActionsManager().getExitAction()) {
            MIAClientMidlet m2 = (MIAClientMidlet)UniversalCommunicator.getInbox();
            m2.confirm();
        } else if (aCommand instanceof ToPluginCommand) {
            if (aCommand instanceof ToHelpCommand) {
                ((ToHelpCommand)aCommand).setFromPlugin(this);
            }
            ((ToPluginCommand)aCommand).execute();
        } else if (this.commands.contains(aCommand)) {
            int i2 = this.commands.indexOf(aCommand);
            FSLCommonPlugin fSLCommonPlugin = this;
            fSLCommonPlugin.executeAction(fSLCommonPlugin.currentPayLoad.getActions()[i2]);
        } else if (aCommand == this.showVideo) {
            try {
                UniversalCommunicator.getInbox().platformRequest(this.currentPayLoad.getURL());
            }
            catch (ConnectionNotFoundException e2) {
                this.log.warning("URL could not be launched for message '" + this.currentPayLoad.getURL() + "'");
            }
        } else {
            super.commandAction(aCommand, aDisplayable);
        }
    }

    protected void executeAction(Action action) {
        String requiredAction = action.getResponse();
        if (requiredAction.indexOf("#search") != -1 || requiredAction.indexOf("catalog") != -1) {
            this.responseActionsInList = true;
        }
        IDataRequest r = DataRequest.getDataRequest();
        r.sendRequest(requiredAction);
    }

    protected final void searchBluetoothDevice() {
        CommonBTLocationProvider bt = (CommonBTLocationProvider)PluginManager.getManager().getPlugin("BT_Location_Provider");
        if (bt != null) {
            bt.blueToothDetection();
        } else {
            FslPopupForm popup = new FslPopupForm(this.getDisplay(), "pas de provider BT", 0);
            popup.pop();
        }
    }

    public final StringWidget getImgWidget() {
        return this.imgWidget;
    }

    public final Vector getMsgWidgets() {
        return this.msgWidgets;
    }

    public final StringWidget getTitle() {
        return this.title;
    }

    public final void setImageAboveMessage(boolean bAbove) {
        this.isImageAboveMessage = bAbove;
        this.manageImageAttachement();
    }

    public final void hasFocus() {
        this.blinkIcon(false);
        super.hasFocus();
        FSLCommonPlugin fSLCommonPlugin = this;
        fSLCommonPlugin.speak(fSLCommonPlugin.ttsMessage);
    }

    protected final void blinkIcon(boolean bBlink) {
        if (this.$blinkIcon != null) {
            FSLCommonPlugin fSLCommonPlugin = this;
            synchronized (fSLCommonPlugin) {
                if (!bBlink) {
                    if (this.$blinkTimer != null) {
                        this.$blinkTimer.cancel();
                        this.$blinkTimer = null;
                    }
                } else if (this.$blinkTimer == null) {
                    TimerTask blinkTask = new TimerTask(){

                        public final void run() {
                            FSLCommonPlugin fSLCommonPlugin = FSLCommonPlugin.this;
                            fSLCommonPlugin.changeIcon(fSLCommonPlugin.$blinkStep ? FSLCommonPlugin.this.$blinkIcon : FSLCommonPlugin.this.noFocusIcon);
                            FSLCommonPlugin fSLCommonPlugin2 = FSLCommonPlugin.this;
                            fSLCommonPlugin2.$blinkStep = !fSLCommonPlugin2.$blinkStep;
                        }
                    };
                    this.$blinkTimer = new Timer();
                    this.$blinkStep = true;
                    this.$blinkTimer.scheduleAtFixedRate(blinkTask, 0L, 500L);
                }
            }
        }
    }

    public final void lostFocus() {
        super.lostFocus();
    }

    protected final void speak(Object object) {
        if (this.isTTSEnabled() && object != null) {
            if (object instanceof String) {
                try {
                    if (this.alerter != null) {
                        this.alerter.tts((String)object);
                    }
                }
                catch (Throwable th) {
                    this.log(th);
                }
            } else if (object instanceof StringBuffer) {
                this.speak(((StringBuffer)object).toString());
            } else if (object instanceof StringAttr) {
                this.speak(((StringAttr)object).data);
            }
        }
    }

    public boolean keyPressed(int keyCode) {
        String key = new Character((char)keyCode).toString();
        int i2 = this.keys.indexOf(key);
        if (i2 >= 0) {
            FSLCommonPlugin fSLCommonPlugin = this;
            fSLCommonPlugin.executeAction(fSLCommonPlugin.currentPayLoad.getActions()[i2]);
        } else if (keyCode == -5 && !this.responseActionsInList) {
            this.searchBluetoothDevice();
        }
        return false;
    }

    public final void keyReleased(int keyCode) {
    }

    public void pointerReleased(int x2, int y2) {
    }

    protected final void log(Throwable th) {
        this.log.severe("Exception " + th);
        System.out.println(th.getMessage());
        th.printStackTrace();
    }

    protected final void trc(String msg) {
        this.log.warning(msg);
        System.out.println(String.valueOf(this.getClass().getName()) + " " + msg);
    }

    protected final Image setConnectionStatusLogo(StandardForm form, boolean bOn) {
        Image connStatusImg = this.loadImage(bOn ? "n80_icon_radioOnTrasp7.png" : "n80_icon_radioOffTrasp7.png");
        if (connStatusImg != null) {
            form.setLogo(connStatusImg, 24);
        }
        return connStatusImg;
    }

    public void pluginConnected(boolean connected) {
        FSLCommonPlugin fSLCommonPlugin = this;
        fSLCommonPlugin.setConnectionStatusLogo(fSLCommonPlugin.getDisplay(), connected);
    }

    private final class PlaySoundThread
    implements Runnable,
    PlayerListener {
        private String audio;
        private Player player;

        public final void setAudio(String sound) {
            this.audio = sound;
        }

        public final void run() {
            try {
                if (this.player != null) {
                    if (this.player.getState() == 400) {
                        this.player.stop();
                    }
                    if (this.player.getState() != 0) {
                        this.player.close();
                    }
                }
                this.player = Manager.createPlayer((String)this.audio);
                this.player.realize();
                VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
                volumeControl.setLevel(70);
                this.player.start();
            }
            catch (Exception e2) {
                ((StringWidget)((Object)FSLCommonPlugin.this.getMsgWidgets().elementAt(0))).setItems("Failed to play sound : " + e2.getMessage() + " " + this.audio);
                FSLCommonPlugin.this.mainDisplay.doLayout();
            }
        }

        public final void stop() {
            if (this.player != null) {
                try {
                    this.player.stop();
                }
                catch (MediaException mediaException) {
                    MediaException e2 = mediaException;
                    mediaException.printStackTrace();
                }
            }
        }

        public final void playerUpdate(Player player, String event, Object eventData) {
            if (event.equals("stopped")) {
                player.close();
                player.removePlayerListener((PlayerListener)this);
            }
        }
    }
}

