/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rtk;

import com.ibm.rtk.CustomForm;
import com.ibm.rtk.CustomWidget;
import com.ibm.rtk.Toolkit;
import com.ibm.rtk.ValueListener;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public abstract class TabBarWidget
extends CustomWidget {
    public int selected = 0;
    public Vector item = new Vector();
    public int tabunselect = 13034239;
    public int tabselect = 0xFFFFFF;
    public int tabback = 0xE0E0E0;
    public int tabselfont = 0;
    public int tabunselfont = 0x909090;
    private boolean traversal = false;
    private MIDlet midlet;
    private Vector cf = new Vector();
    private ValueListener listener = null;
    private Font normalfont = Toolkit.normalfont;
    private int fontheight;
    private int lineheight;
    private int tabcurrent = 0;
    private int width = 240;
    private Image rightarrow;
    private int thumbh = 18;
    private int arrowarea = 24;
    private Object[] temp = new Object[1];
    private static Image offscreen = null;
    private static Graphics offgc = null;

    public TabBarWidget(MIDlet mIDlet, boolean bl, Font font) {
        super(null);
        this.midlet = mIDlet;
        this.traversal = bl;
        if (font != null) {
            this.normalfont = font;
        }
        this.init();
    }

    public final void setListener(ValueListener valueListener) {
        this.listener = valueListener;
        this.repaintExt();
    }

    public final void setSelectedTab(int n2) {
        int n3 = this.item.size();
        if (n3 == 0) {
            return;
        }
        if (n2 >= n3) {
            n2 = 0;
        }
        this.computeSelected(n2);
        this.repaintExt();
        CustomForm customForm = (CustomForm)this.cf.elementAt(this.selected);
        if (customForm != null) {
            Toolkit.setCurrent(this.midlet, customForm);
            customForm.repaint();
        }
        if (this.listener != null) {
            this.listener.valueNotify(this.selected, (Object)this);
        }
    }

    public final void setTab(Object object, CustomForm customForm, int n2) {
        if (object == null) {
            this.selected = this.selected == n2 ? 0 : --this.selected;
            if (this.selected < 0) {
                this.selected = 0;
            }
            this.item.removeElementAt(n2);
            this.cf.removeElementAt(n2);
            TabBarWidget tabBarWidget = this;
            tabBarWidget.setSelectedTab(tabBarWidget.selected);
            return;
        }
        if (n2 >= this.item.size()) {
            n2 = -1;
        }
        if (n2 == -1) {
            this.item.addElement(object);
            this.cf.addElement(customForm);
        } else {
            this.item.setElementAt(object, n2);
            this.cf.setElementAt(customForm, n2);
        }
        int n3 = this.getTabHeight(object);
        int n4 = this.getTabWidth(object);
        int n5 = this.thumbh;
        if (n3 > this.thumbh - 6) {
            this.thumbh = n3 + 6;
        }
        TabBarWidget tabBarWidget = this;
        tabBarWidget.computeSelected(tabBarWidget.selected);
        this.getbuffer();
    }

    public final void nextTab(int n2) {
        int n3 = this.item.size();
        this.selected += n2;
        if (this.selected < 0) {
            this.selected = n3 - 1;
        }
        if (this.selected >= n3) {
            this.selected = 0;
        }
        TabBarWidget tabBarWidget = this;
        tabBarWidget.setSelectedTab(tabBarWidget.selected);
    }

    private final void init() {
        try {
            this.rightarrow = Toolkit.createImage("/rtkrightarrow.png");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.fontheight = this.normalfont.getHeight();
        this.lineheight = this.fontheight + 1;
        if (offgc == null) {
            this.getbuffer();
        }
    }

    private final int getTabWidth(Object object) {
        Object[] objectArray;
        int n2 = this.width - this.arrowarea;
        int n3 = 0;
        int n4 = 0;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            this.temp[0] = object;
            objectArray = this.temp;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            object = objectArray[i2];
            if (object instanceof Image) {
                n4 += ((Image)object).getWidth() + 6;
            }
            if (object instanceof String && (n4 += this.normalfont.stringWidth((String)object) + 6) > n2) {
                return n2 - 10;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    private final void getbuffer() {
        int n2 = this.getPrefContentHeight(-1) + 1;
        if (offscreen == null) {
            offscreen = Image.createImage((int)this.width, (int)n2);
            offgc = offscreen.getGraphics();
        } else if (n2 > offscreen.getHeight() || this.width > offscreen.getWidth()) {
            offscreen = Image.createImage((int)this.width, (int)n2);
            offgc = offscreen.getGraphics();
        }
    }

    private final int getTabHeight(Object object) {
        Object[] objectArray;
        int n2 = 0;
        int n3 = 0;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            this.temp[0] = object;
            objectArray = this.temp;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            object = objectArray[i2];
            if (object instanceof Image) {
                n3 = ((Image)object).getHeight();
            }
            if (object instanceof String) {
                n3 = this.normalfont.getHeight();
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private final int maxdrawtabs() {
        int n2 = this.width - this.arrowarea - 6;
        int n3 = 0;
        int n4 = this.item.size();
        if (n4 == 0) {
            return 0;
        }
        int n5 = 0;
        for (int i2 = this.tabcurrent; i2 < n4; ++i2) {
            TabBarWidget tabBarWidget = this;
            if ((n5 += tabBarWidget.getTabWidth(tabBarWidget.item.elementAt(i2))) > n2) break;
            ++n3;
        }
        return n3;
    }

    private final void computeSelected(int n2) {
        this.selected = n2;
        int n3 = this.maxdrawtabs();
        if (n3 == 0) {
            return;
        }
        if (this.selected >= this.tabcurrent + n3) {
            int n4 = this.selected - (this.tabcurrent + n3);
            if (n4 > n3) {
                this.tabcurrent = this.selected - n3 + 1;
            } else {
                this.tabcurrent += n4 + 1;
                this.computeSelected(n2);
            }
        } else if (this.selected < this.tabcurrent) {
            this.tabcurrent = this.selected;
        }
    }

    private final void paintControl(Graphics graphics) {
        boolean bl = false;
        int n2 = 3;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.item.size();
        int n6 = this.maxdrawtabs();
        Graphics graphics2 = offgc;
        graphics2.setColor(0);
        graphics2.drawLine(n3, 0, n3, this.thumbh);
        graphics2.setFont(this.normalfont);
        for (int i2 = this.tabcurrent; i2 < n5 && i2 - this.tabcurrent < n6; ++i2) {
            Object[] objectArray;
            Object object = this.item.elementAt(i2);
            int n7 = this.getTabWidth(object);
            n4 = 1 + (this.thumbh - this.getTabHeight(object)) / 2;
            if (i2 == this.selected) {
                graphics2.setColor(this.tabselect);
                graphics2.fillRect(n3 + 1, 0, n7 - 1, this.thumbh);
                graphics2.setColor(0x909090);
                graphics2.drawLine(n3, this.thumbh, n3 + n7, this.thumbh);
                if (this.focus && this.drawfocus) {
                    graphics2.setStrokeStyle(1);
                    graphics2.drawRect(n3 + 2, 1, n7 - 4, this.thumbh - 2);
                    graphics2.setStrokeStyle(0);
                }
            } else {
                graphics2.setColor(this.tabunselect);
                graphics2.fillRect(n3 + 1, 0, n7, this.thumbh);
                graphics2.setColor(0);
                graphics2.drawLine(n3, this.thumbh, n3 + n7, this.thumbh);
            }
            graphics2.setColor(0);
            if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                this.temp[0] = object;
                objectArray = this.temp;
            }
            int n8 = n3 + n2;
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                object = objectArray[i3];
                n4 = 1 + (this.thumbh - this.getTabHeight(object)) / 2;
                if (object instanceof Image) {
                    graphics2.drawImage((Image)object, n8, n4, 20);
                    n8 += ((Image)object).getWidth() + 2;
                }
                if (!(object instanceof String)) continue;
                graphics2.setColor(this.tabunselfont);
                if (i2 == this.selected) {
                    graphics2.setColor(this.tabselfont);
                }
                graphics2.drawString((String)object, n8, n4, 20);
                n8 += this.normalfont.stringWidth((String)object) + 2;
            }
            graphics2.setColor(0);
            graphics2.drawLine(n3 += n7, 0, n3, this.thumbh);
        }
        graphics2.drawLine(n3, this.thumbh, this.width, this.thumbh);
        graphics2.setColor(this.tabback);
        graphics2.fillRect(n3 + 1, 0, this.width, this.thumbh);
        if (n6 != n5) {
            n4 = 1 + (this.thumbh - this.rightarrow.getHeight()) / 2;
            n3 = this.width - this.rightarrow.getWidth() - 6;
            graphics2.drawImage(this.rightarrow, n3, n4, 20);
        }
        graphics2.setColor(0);
        graphics2.drawLine(0, 0, this.width, 0);
        graphics.setClip(0, 0, this.width, this.getPrefContentHeight(-1) + 1);
        graphics.drawImage(offscreen, 0, 0, 20);
    }

    public final void paint(Graphics graphics, int n2, int n3) {
        this.paintControl(graphics);
    }

    public final int getMinContentHeight() {
        return this.thumbh;
    }

    public final int getMinContentWidth() {
        return 0;
    }

    public final int getPrefContentHeight(int n2) {
        return this.thumbh;
    }

    public final int getPrefContentWidth(int n2) {
        return 0;
    }

    public final void pointerPressed(int n2, int n3) {
        int n4 = this.maxdrawtabs();
        int n5 = this.item.size();
        if (n3 > this.thumbh) {
            return;
        }
        if (n4 != n5 && n2 > this.width - this.rightarrow.getWidth() - 6) {
            this.nextTab(1);
            return;
        }
        int n6 = 0;
        for (int i2 = this.tabcurrent; i2 < n5 && i2 - this.tabcurrent < n4; ++i2) {
            TabBarWidget tabBarWidget = this;
            int n7 = tabBarWidget.getTabWidth(tabBarWidget.item.elementAt(i2));
            if (n2 >= n6 && n2 <= n6 + n7) {
                this.computeSelected(i2);
                TabBarWidget tabBarWidget2 = this;
                tabBarWidget2.setSelectedTab(tabBarWidget2.selected);
            }
            n6 += n7;
        }
    }

    public final void traverseOut() {
        this.focus = false;
    }

    protected final void findIndex(CustomForm customForm) {
        if (this.cf.elementAt(this.selected) == customForm) {
            return;
        }
        for (int i2 = 0; i2 < this.cf.size(); ++i2) {
            if (this.cf.elementAt(i2) != customForm) continue;
            this.computeSelected(i2);
            break;
        }
    }

    public final void sizeChanged(int n2, int n3) {
        this.width = n2;
        TabBarWidget tabBarWidget = this;
        tabBarWidget.computeSelected(tabBarWidget.selected);
        this.getbuffer();
    }

    protected final boolean traverse(int n2, int n3, int n4, int[] nArray) {
        if (!this.traversal) {
            return false;
        }
        switch (n2) {
            case 0: {
                this.focus = true;
                return true;
            }
            case 2: {
                this.nextTab(-1);
                return true;
            }
            case 5: {
                this.nextTab(1);
                return true;
            }
            case 1: 
            case 6: {
                this.focus = !this.focus;
                this.repaintExt();
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = this.width;
                nArray[3] = this.height;
                return this.focus;
            }
        }
        return false;
    }
}

