/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rtk;

import com.ibm.rtk.CustomWidget;

public final class FormAttachment {
    public int numerator;
    public int denominator = 100;
    public int offset;
    public CustomWidget control;
    public int alignment;

    FormAttachment() {
    }

    public FormAttachment(int n2) {
        this(n2, 100, 0);
    }

    public FormAttachment(int n2, int n3) {
        this(n2, 100, n3);
    }

    public FormAttachment(int n2, int n3, int n4) {
        this.numerator = n2;
        this.denominator = n3;
        this.offset = n4;
    }

    public FormAttachment(CustomWidget customWidget) {
        this(customWidget, 0, -1);
    }

    public FormAttachment(CustomWidget customWidget, int n2) {
        this(customWidget, n2, -1);
    }

    public FormAttachment(CustomWidget customWidget, int n2, int n3) {
        this.control = customWidget;
        this.offset = n2;
        this.alignment = n3;
    }

    final FormAttachment divide(int n2) {
        return new FormAttachment(this.numerator, this.denominator * n2, this.offset / n2);
    }

    final int gcd(int n2, int n3) {
        int n4;
        if ((n2 = Math.abs(n2)) < (n3 = Math.abs(n3))) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        while (n3 != 0) {
            n4 = n2;
            n2 = n3;
            n3 = n4 % n3;
        }
        return n2;
    }

    final FormAttachment minus(FormAttachment formAttachment) {
        FormAttachment formAttachment2 = new FormAttachment();
        new FormAttachment().numerator = this.numerator * formAttachment.denominator - this.denominator * formAttachment.numerator;
        formAttachment2.denominator = this.denominator * formAttachment.denominator;
        int n2 = this.gcd(formAttachment2.denominator, formAttachment2.numerator);
        formAttachment2.numerator /= n2;
        formAttachment2.denominator /= n2;
        formAttachment2.offset = this.offset - formAttachment.offset;
        return formAttachment2;
    }

    final FormAttachment minus(int n2) {
        return new FormAttachment(this.numerator, this.denominator, this.offset - n2);
    }

    final FormAttachment plus(FormAttachment formAttachment) {
        FormAttachment formAttachment2 = new FormAttachment();
        new FormAttachment().numerator = this.numerator * formAttachment.denominator + this.denominator * formAttachment.numerator;
        formAttachment2.denominator = this.denominator * formAttachment.denominator;
        int n2 = this.gcd(formAttachment2.denominator, formAttachment2.numerator);
        formAttachment2.numerator /= n2;
        formAttachment2.denominator /= n2;
        formAttachment2.offset = this.offset + formAttachment.offset;
        return formAttachment2;
    }

    final FormAttachment plus(int n2) {
        return new FormAttachment(this.numerator, this.denominator, this.offset + n2);
    }

    final int solveX(int n2) {
        return this.numerator * n2 / this.denominator + this.offset;
    }

    final int solveY(int n2) {
        return (n2 - this.offset) * this.denominator / this.numerator;
    }

    public final String toString() {
        String string = this.control != null ? ((Object)((Object)this.control)).toString() : this.numerator + "/" + this.denominator;
        return "y = (" + string + (this.offset >= 0 ? ")x + " + this.offset : ")x - " + -this.offset);
    }
}

