/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rtk;

import com.ibm.rtk.CustomWidget;
import com.ibm.rtk.Keymap;
import com.ibm.rtk.Radiobox;
import com.ibm.rtk.Toolkit;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class CheckWidget
extends CustomWidget {
    public int border = Toolkit.border;
    public boolean selected = false;
    public int fg = 0;
    private String label;
    private int margin = 3;
    private int frame = 2;
    private Font normalfont = Toolkit.normalfont;
    private int style = 0;
    private int red;
    private int green;
    private int blue;
    private Radiobox radiobox = null;
    boolean focus = false;
    int prefwidth;
    int prefheight;
    private static Image radio = null;

    public CheckWidget(String string, Font font) {
        super(null);
        if (string == null) {
            string = "";
        }
        this.label = string;
        this.init(font);
    }

    private final void init(Font font) {
        this.red = Toolkit.highlightbg >> 16;
        this.green = (Toolkit.highlightbg & 0xFF00) >> 8;
        this.blue = Toolkit.highlightbg & 0xFF;
        if (font != null) {
            this.normalfont = font;
        }
        try {
            int n2 = this.normalfont.getBaselinePosition();
            radio = n2 > 20 ? Toolkit.createImage("/rtkradio20.png") : Toolkit.createImage(n2 > 13 ? "/rtkradio12.png" : "/rtkradio8.png");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.prefheight = this.frame + this.normalfont.getHeight();
        this.prefwidth = this.frame + this.normalfont.stringWidth(this.label) + this.margin + this.prefheight + this.frame;
    }

    public final void paint(Graphics graphics, int n2, int n3) {
        int n4 = 0;
        int n5 = this.fg;
        if (!this.enable) {
            n4 = Toolkit.greyColor(n4);
            n5 = Toolkit.greyColor(n5);
        }
        graphics.setFont(this.normalfont);
        int n6 = this.normalfont.getBaselinePosition();
        int n7 = this.frame;
        if (Toolkit.RTLLOCALE) {
            n7 = this.width - this.frame - n6;
        }
        int n8 = n6;
        Toolkit.drawRadio(graphics, n7, n8, n8 - 2, this.frame, (this.red << 16) + (this.green << 8) + this.blue, this.selected, this.enable, this.style & 0x10, radio);
        n7 = Toolkit.RTLLOCALE ? this.width - this.normalfont.stringWidth(this.label) - n6 - this.margin - this.frame : this.frame + n6 + this.margin;
        graphics.setColor(n5);
        graphics.drawString(this.label, n7, this.frame, 20);
    }

    public final void setSelection(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.selected = bl;
        if (this.radiobox != null) {
            this.radiobox.notify(this);
        }
        if (this.form != null) {
            this.form.notify(3, (Object)this);
        }
    }

    public final int getMinContentHeight() {
        return this.prefheight;
    }

    public final int getMinContentWidth() {
        return this.prefwidth;
    }

    public final int getPrefContentHeight(int n2) {
        return this.prefheight;
    }

    public final int getPrefContentWidth(int n2) {
        if (n2 != -1 && n2 > this.prefwidth) {
            this.prefwidth = n2;
        }
        return this.prefwidth;
    }

    public final void pointerPressed(int n2, int n3) {
        CheckWidget checkWidget = this;
        checkWidget.setSelection(!checkWidget.selected);
        this.repaintExt();
    }

    public final void keyPressed(int n2) {
        if (n2 == 32 || n2 == Keymap.KEYCODE_JOGSELECT) {
            CheckWidget checkWidget = this;
            checkWidget.setSelection(!checkWidget.selected);
            this.repaintExt();
        }
    }

    public final void traverseOut() {
        this.focus = false;
    }

    protected final boolean traverse(int n2, int n3, int n4, int[] nArray) {
        if (!this.enable) {
            return false;
        }
        switch (n2) {
            case 0: {
                this.focus = true;
                return true;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.focus = !this.focus;
                this.repaintExt();
                nArray[0] = 0;
                nArray[1] = 0;
                nArray[2] = this.prefwidth;
                nArray[3] = this.prefheight;
                return this.focus;
            }
        }
        return false;
    }

    public final String toString() {
        return "CheckItem " + this.label;
    }
}

