/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;
import java.util.Vector;

public final class MqttUnsubscribe
extends MqttPacket {
    public String[] topics;

    public MqttUnsubscribe() {
        this.setMsgType((short)10);
    }

    public MqttUnsubscribe(byte[] byArray, int n2) {
        super(byArray);
        this.setMsgType((short)10);
        this.setMsgId(MqttUtils.toShort(byArray, n2));
        Vector vector = MqttUtils.UTFToStrings(byArray, n2 + 2);
        int n3 = vector.size();
        this.topics = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.topics[n4] = vector.elementAt(n4).toString();
            ++n4;
        }
    }

    public final void process(MqttProcessor mqttProcessor) {
        mqttProcessor.process(this);
    }

    public final byte[] toBytes() {
        this.message = new byte[3];
        this.message[0] = super.toBytes()[0];
        int n2 = this.getMsgId();
        this.message[1] = (byte)(n2 / 256);
        this.message[2] = (byte)(n2 % 256);
        int n3 = 0;
        while (n3 < this.topics.length) {
            byte[] byArray = MqttUtils.StringToUTF(this.topics[n3]);
            this.message = MqttUtils.concatArray(this.message, byArray);
            ++n3;
        }
        this.createMsgLength();
        return this.message;
    }
}

