/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;
import java.util.Vector;

public final class MqttSubscribe
extends MqttPacket {
    public String[] topics;
    public byte[] topicsQoS;

    public MqttSubscribe() {
        this.setMsgType((short)8);
    }

    public MqttSubscribe(byte[] byArray, int n2) {
        super(byArray);
        this.setMsgType((short)8);
        this.setMsgId(MqttUtils.toShort(byArray, n2));
        Vector vector = MqttUtils.getTopicsWithQoS(MqttUtils.SliceByteArray(byArray, n2 + 2, byArray.length - (n2 + 2)));
        int n3 = vector.size();
        this.topicsQoS = new byte[n3];
        this.topics = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string = vector.elementAt(n4).toString();
            this.topics[n4] = string.substring(0, string.length() - 1);
            String string2 = string;
            char c2 = string2.charAt(string2.length() - 1);
            this.topicsQoS[n4] = (byte)Character.digit(c2, 10);
            ++n4;
        }
    }

    public final void process(MqttProcessor mqttProcessor) {
        mqttProcessor.process(this);
    }

    public final byte[] toBytes() {
        this.message = new byte[3];
        this.message[0] = super.toBytes()[0];
        int n2 = this.getMsgId();
        this.message[1] = (byte)(n2 / 256);
        this.message[2] = (byte)(n2 % 256);
        int n3 = 0;
        while (n3 < this.topics.length) {
            byte[] byArray = MqttUtils.StringToUTF(this.topics[n3]);
            this.message = MqttUtils.concatArray(MqttUtils.concatArray(this.message, byArray), 0, this.message.length + byArray.length, this.topicsQoS, n3, 1);
            ++n3;
        }
        this.createMsgLength();
        return this.message;
    }
}

