/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.IMqttClient;
import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.Mqtt;
import com.ibm.mqtt.MqttAdvancedCallback;
import com.ibm.mqtt.MqttBaseClient;
import com.ibm.mqtt.MqttBrokerUnavailableException;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttSimpleCallback;

public final class MqttClient
extends MqttBaseClient
implements IMqttClient {
    private Class traceClass = null;
    private String connection;
    private MqttPersistence persistenceLayer = null;
    private Thread reader = null;
    private Object connAckLock = new Object();
    private int conRetCode;
    private boolean isAppConnected = false;
    private MqttAdvancedCallback advCallbackHandler = null;
    private MqttSimpleCallback simpleCallbackHandler = null;

    public MqttClient(String string) throws MqttException {
        this(string, null);
    }

    public MqttClient(String string, MqttPersistence mqttPersistence) throws MqttException {
        this.initialise(string, mqttPersistence);
    }

    protected final void initialise(String string, MqttPersistence mqttPersistence) throws MqttException {
        Class<?> clazz = null;
        this.connection = string;
        this.persistenceLayer = mqttPersistence;
        if (string.startsWith("local://")) {
            try {
                Class.forName("com.ibm.micro.LocalListener");
                clazz = Class.forName("com.ibm.mqtt.local.MqttLocalBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                MqttException mqttException = new MqttException("LocalBinding unavailable: Microbroker classes not found");
                mqttException.initCause(classNotFoundException);
                throw mqttException;
            }
        }
        if (string.startsWith("tcp://")) {
            boolean bl = true;
            try {
                Class.forName("java.net.Socket");
                clazz = Class.forName("com.ibm.mqtt.j2se.MqttJ2SESocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            if (!bl) {
                try {
                    Class.forName("javax.microedition.io.Connector");
                    Class.forName("javax.microedition.io.StreamConnection");
                    clazz = Class.forName("com.ibm.mqtt.midp.MqttMidpSocket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MqttException mqttException = new MqttException("Cannot locate a J2SE Socket or J2ME StreamConnection class");
                    mqttException.initCause(classNotFoundException);
                    throw mqttException;
                }
            }
        } else {
            throw new MqttException("Unrecognised connection method:" + string);
        }
        MqttClient mqttClient = this;
        super.initialise(mqttClient.connection, this.persistenceLayer, clazz);
        try {
            this.traceClass = Class.forName("com.ibm.mqtt.trace.MQeTraceToBinaryFile");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.traceClass = null;
        }
        this.start(clazz);
    }

    private final void start(Class clazz) throws MqttException {
        try {
            this.reader = new Thread(this);
            this.reader.start();
            super.setRetry(10);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            throw new MqttException(exception2);
        }
    }

    public final void registerSimpleHandler(MqttSimpleCallback mqttSimpleCallback) {
        this.simpleCallbackHandler = mqttSimpleCallback;
    }

    public final void connect(String string, boolean bl, short s2, String string2, int n2, String string3, boolean bl2) throws MqttException, MqttPersistenceException, MqttBrokerUnavailableException, MqttNotConnectedException {
        MQeTrace.trace(this, (short)-30002, 0x100004L);
        if (!this.isAppConnected || !this.isSocketConnected()) {
            int n3 = 0;
            Object object = this.connAckLock;
            synchronized (object) {
                this.conRetCode = -1;
                super.connect(string, bl, false, s2, string2, n2, string3, bl2);
                try {
                    this.connAckLock.wait(this.getRetry() * 1000);
                }
                catch (InterruptedException interruptedException) {}
                n3 = this.conRetCode;
            }
            MQeTrace.trace(this, (short)-30003, 0x100008L);
            switch (n3) {
                case 0: {
                    this.isAppConnected = true;
                    break;
                }
                case 1: {
                    object = new MqttConnect();
                    throw new MqttException("WMQTT protocol name or version not supported:" + ((MqttConnect)object).ProtoName + " Version:" + ((MqttConnect)object).ProtoVersion);
                }
                case 2: {
                    throw new MqttException("WMQTT ClientId is invalid");
                }
                case 3: {
                    throw new MqttBrokerUnavailableException("WMQTT Broker is unavailable");
                }
                default: {
                    this.tcpipDisconnect(true);
                    throw new MqttNotConnectedException("WMQTT " + Mqtt.msgTypes[2] + " not received");
                }
            }
        }
    }

    protected final void connectionLost() throws Exception {
        MQeTrace.trace(this, (short)-30004, 0x200000L);
        super.connectionLost();
        if (this.simpleCallbackHandler == null) {
            throw new MqttNotConnectedException("WMQtt Connection Lost");
        }
        this.simpleCallbackHandler.connectionLost();
    }

    protected final void notifyAck(int n2, int n3) {
        switch (n2) {
            case 1: {
                Object object = this.connAckLock;
                synchronized (object) {
                    this.conRetCode = n3;
                    this.connAckLock.notifyAll();
                    break;
                }
            }
            case 8: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.subscribed(n3, this.getReturnedQoS(n3));
                break;
            }
            case 10: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.unsubscribed(n3);
                break;
            }
            case 3: 
            case 6: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.published(n3);
                break;
            }
        }
    }

    public final int publish(String string, byte[] byArray, int n2, boolean bl) throws MqttNotConnectedException, MqttPersistenceException, MqttException, NullPointerException {
        MQeTrace.trace(this, (short)-30007, 0x100004L);
        if (string == null) {
            throw new NullPointerException("NULL topic");
        }
        if (byArray == null) {
            throw new NullPointerException("NULL message");
        }
        if (string.indexOf(35) > -1 || string.indexOf(43) > -1) {
            throw new MqttException("Topic contains '#' or '+'");
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        this.anyErrors();
        int n3 = super.publish(string, byArray, n2, bl);
        MQeTrace.trace(this, (short)-30008, 0x100008L);
        return n3;
    }

    protected final void publishArrived(String string, byte[] byArray, int n2, boolean bl) throws Exception {
        MQeTrace.trace(this, (short)-30009, 0x100004L);
        if (this.simpleCallbackHandler != null) {
            this.simpleCallbackHandler.publishArrived(string, byArray, n2, bl);
        }
        MQeTrace.trace(this, (short)-30010, 0x100008L);
    }

    public final int subscribe(String[] stringArray, int[] nArray) throws MqttNotConnectedException, MqttException, NullPointerException {
        MQeTrace.trace(this, (short)-30011, 0x100004L);
        if (stringArray == null) {
            throw new NullPointerException("NULL topic array");
        }
        if (stringArray.length != nArray.length) {
            throw new MqttException("Array lengths unequal. Topics:" + stringArray.length + ", QoS:" + nArray.length);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                throw new NullPointerException("NULL topic in topic array at index " + n2);
            }
            ++n2;
        }
        if (nArray == null) {
            throw new NullPointerException("NULL requested QoS array");
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > 2) {
                nArray[n2] = 2;
            } else if (nArray[n2] < 0) {
                nArray[n2] = 0;
            }
            ++n2;
        }
        this.anyErrors();
        n2 = super.subscribe(stringArray, nArray);
        MQeTrace.trace(this, (short)-30012, 0x100008L);
        return n2;
    }

    public final int unsubscribe(String[] stringArray) throws MqttNotConnectedException, MqttException, NullPointerException {
        MQeTrace.trace(this, (short)-30013, 0x100004L);
        if (stringArray == null) {
            throw new NullPointerException("NULL topic array");
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                throw new NullPointerException("NULL topic in topic array at index " + n2);
            }
            ++n2;
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        this.anyErrors();
        n2 = super.unsubscribe(stringArray);
        MQeTrace.trace(this, (short)-30014, 0x100008L);
        return n2;
    }

    private final void invalidApiInvocation() throws MqttException {
        throw new MqttException("MqttClient API called in a callback method! Use a different thread.");
    }
}

