/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.MqttAdapter;
import com.ibm.mqtt.MqttConnack;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttPingreq;
import com.ibm.mqtt.MqttPingresp;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttPuback;
import com.ibm.mqtt.MqttPubcomp;
import com.ibm.mqtt.MqttPublish;
import com.ibm.mqtt.MqttPubrec;
import com.ibm.mqtt.MqttPubrel;
import com.ibm.mqtt.MqttSuback;
import com.ibm.mqtt.MqttSubscribe;
import com.ibm.mqtt.MqttUnsuback;
import com.ibm.mqtt.MqttUnsubscribe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Mqtt
implements MqttProcessor {
    private Class socketClass = null;
    private MqttAdapter socket = null;
    private DataInputStream stream_in = null;
    private DataOutputStream stream_out = null;
    private boolean haveWill = false;
    private boolean isSocketConnected = false;
    private boolean connected = false;
    private boolean connectionLost = false;
    private Object streamReadLock = new Object();
    private Object streamWriteLock = new Object();
    private int curMsgId = 0;
    private int keepAlivePeriod;
    private boolean topicNameCompression = false;
    private Hashtable outMsgIdsAllocated = new Hashtable();
    protected String connection;
    public static final String[] msgTypes;
    protected MqttException registeredException = null;

    static {
        String[] stringArray = new String[15];
        stringArray[1] = "CONNECT";
        stringArray[2] = "CONNACK";
        stringArray[3] = "PUBLISH";
        stringArray[4] = "PUBACK";
        stringArray[5] = "PUBREC";
        stringArray[6] = "PUBREL";
        stringArray[7] = "PUBCOMP";
        stringArray[8] = "SUBSCRIBE";
        stringArray[9] = "SUBACK";
        stringArray[10] = "UNSUBSCRIBE";
        stringArray[11] = "UNSUBACK";
        stringArray[12] = "PINGREQ";
        stringArray[13] = "PINGRESP";
        stringArray[14] = "DISCONNECT";
        msgTypes = stringArray;
    }

    protected Mqtt() {
    }

    protected final void initialise(String string, Class clazz) {
        this.connection = string;
        this.socketClass = clazz;
    }

    private final MqttPacket decodePacket(byte[] byArray, int n2, short s2) throws MqttException {
        MqttPacket mqttPacket = null;
        if (this.isSocketConnected()) {
            switch (s2) {
                case 12: {
                    mqttPacket = new MqttPingreq(byArray, n2);
                    break;
                }
                case 13: {
                    mqttPacket = new MqttPingresp(byArray, n2);
                    break;
                }
                case 3: {
                    mqttPacket = new MqttPublish(byArray, n2);
                    break;
                }
                case 4: {
                    mqttPacket = new MqttPuback(byArray, n2);
                    break;
                }
                case 5: {
                    mqttPacket = new MqttPubrec(byArray, n2);
                    break;
                }
                case 6: {
                    mqttPacket = new MqttPubrel(byArray, n2);
                    break;
                }
                case 7: {
                    mqttPacket = new MqttPubcomp(byArray, n2);
                    break;
                }
                case 8: {
                    mqttPacket = new MqttSubscribe(byArray, n2);
                    break;
                }
                case 9: {
                    mqttPacket = new MqttSuback(byArray, n2);
                    break;
                }
                case 10: {
                    mqttPacket = new MqttUnsubscribe(byArray, n2);
                    break;
                }
                case 11: {
                    mqttPacket = new MqttUnsuback(byArray, n2);
                    break;
                }
                case 14: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    mqttPacket = new MqttConnack(byArray, n2);
                    break;
                }
                default: {
                    throw new MqttException("Mqtt: Unknown message type: " + s2);
                }
            }
        }
        return mqttPacket;
    }

    protected final int getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    protected final boolean isSocketConnected() {
        Object object = this.streamWriteLock;
        synchronized (object) {
            return this.isSocketConnected;
        }
    }

    private final void setSocketState(boolean bl) {
        Object object = this.streamWriteLock;
        synchronized (object) {
            this.isSocketConnected = bl;
        }
    }

    protected final void initialiseOutMsgIds(Vector vector) {
        this.outMsgIdsAllocated.clear();
        this.curMsgId = 1;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n2;
                Integer n3 = n2 = (Integer)enumeration.nextElement();
                this.outMsgIdsAllocated.put(n3, n3);
            }
        }
    }

    protected final int nextMsgId() throws MqttException {
        if (this.outMsgIdsAllocated.size() == 65535) {
            throw new MqttException("All available msgIds in use:65535");
        }
        boolean bl = false;
        while (!bl) {
            this.curMsgId = this.curMsgId < 65535 ? ++this.curMsgId : 1;
            Integer n2 = new Integer(this.curMsgId);
            if (this.outMsgIdsAllocated.contains(n2)) continue;
            Integer n3 = n2;
            this.outMsgIdsAllocated.put(n3, n3);
            bl = true;
        }
        return this.curMsgId;
    }

    protected final void releaseMsgId(int n2) {
        this.outMsgIdsAllocated.remove(new Integer(n2));
    }

    public final synchronized boolean isConnected() {
        return this.connected;
    }

    public final boolean supportTopicNameCompression() {
        return this.topicNameCompression;
    }

    protected final void process() throws Exception {
        MqttPacket mqttPacket = this.readPacket();
        if (mqttPacket != null) {
            mqttPacket.process(this);
        } else {
            System.out.println("Mqtt: Read a null packet from the socket");
        }
    }

    public void process(MqttConnack mqttConnack) {
        if (mqttConnack.returnCode == 0) {
            this.topicNameCompression = mqttConnack.topicNameCompression;
            this.setConnectionState(true);
        } else if (mqttConnack.returnCode == 1) {
            this.setConnectionState(false);
        } else if (mqttConnack.returnCode == 2) {
            this.setConnectionState(false);
        } else if (mqttConnack.returnCode == 3) {
            this.setConnectionState(false);
        }
        if (mqttConnack.returnCode != 0) {
            this.tcpipDisconnect(false);
        }
    }

    public final void process(MqttPingreq mqttPingreq) {
        try {
            this.writePacket(new MqttPingresp());
        }
        catch (Exception exception) {}
    }

    public final void process(MqttSubscribe mqttSubscribe) {
    }

    public final void process(MqttUnsubscribe mqttUnsubscribe) {
    }

    public final void process(MqttPingresp mqttPingresp) {
    }

    public abstract void process(MqttPublish var1);

    public abstract void process(MqttPuback var1);

    public abstract void process(MqttPubrec var1);

    public abstract void process(MqttPubrel var1);

    public abstract void process(MqttPubcomp var1);

    public abstract void process(MqttSuback var1);

    public abstract void process(MqttUnsuback var1);

    protected final MqttPublish genPublishPacket(int n2, int n3, String string, byte[] byArray, boolean bl, boolean bl2) {
        MqttPublish mqttPublish = new MqttPublish();
        mqttPublish.setMsgId(n2);
        mqttPublish.setQos(n3);
        mqttPublish.topicName = string;
        mqttPublish.setPayload(byArray);
        mqttPublish.setDup(bl2);
        mqttPublish.setRetain(bl);
        if (this.topicNameCompression) {
            mqttPublish.compressTopic();
        }
        return mqttPublish;
    }

    protected final MqttPacket readPacket() throws MqttException, InterruptedIOException, IOException {
        byte[] byArray = new byte[5];
        byte[] byArray2 = null;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        short s2 = 0;
        Object object = this.streamReadLock;
        synchronized (object) {
            byte by;
            try {
                n2 = this.stream_in.read(byArray, 0, 1);
            }
            catch (IOException iOException) {
                MQeTrace.trace(this, (short)-30033, 0x200000L, iOException.getMessage());
                throw iOException;
            }
            if (n2 < 0) {
                throw new EOFException("DataInputStream.read returned -1");
            }
            int n5 = 0;
            do {
                byArray[n4] = by = (byte)this.stream_in.read();
                n5 += (by & 0x7F) * n3;
                n3 *= 128;
                ++n4;
            } while ((by & 0x80) != 0);
            byArray2 = new byte[n5 + n4];
            int n6 = 0;
            while (n6 < n4) {
                byArray2[n6] = byArray[n6];
                ++n6;
            }
            if (n5 > 0) {
                this.stream_in.readFully(byArray2, n4, n5);
            }
            s2 = (short)(byArray2[0] >>> 4 & 0xF);
        }
        return this.decodePacket(byArray2, n4, s2);
    }

    protected synchronized void setConnectionState(boolean bl) {
        this.connected = bl;
    }

    protected final void setKeepAlive(int n2) {
        this.keepAlivePeriod = n2;
    }

    protected final void tcpipConnect(MqttConnect mqttConnect) throws IOException, Exception {
        Object object = this.streamWriteLock;
        synchronized (object) {
            this.tcpipDisconnect(true);
            try {
                this.socket = (MqttAdapter)this.socketClass.newInstance();
                this.socket.setConnection(this.connection, mqttConnect.KeepAlive);
                this.setSocketState(true);
            }
            catch (IOException iOException) {
                this.tcpipDisconnect(true);
                throw iOException;
            }
            catch (Exception exception) {
                this.tcpipDisconnect(true);
                throw exception;
            }
            this.stream_in = new DataInputStream(this.socket.getInputStream());
            this.stream_out = new DataOutputStream(this.socket.getOutputStream());
            this.writePacket(mqttConnect);
        }
    }

    protected final void tcpipDisconnect(boolean bl) {
        Object object = this.streamWriteLock;
        synchronized (object) {
            if (this.stream_out != null) {
                try {
                    this.stream_out.close();
                }
                catch (IOException iOException) {}
                this.stream_out = null;
            }
            if (bl) {
                this.setSocketState(false);
                if (this.stream_in != null) {
                    try {
                        this.stream_in.close();
                    }
                    catch (IOException iOException) {}
                    this.stream_in = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {}
                    this.socket = null;
                }
            }
        }
    }

    protected final void writePacket(MqttPacket mqttPacket) throws MqttException {
        Object object = this.streamWriteLock;
        synchronized (object) {
            if (this.stream_out != null) {
                try {
                    byte[] byArray = mqttPacket.getPayload();
                    byte[] byArray2 = mqttPacket.toBytes();
                    mqttPacket.setDup(true);
                    ((OutputStream)this.stream_out).write(byArray2);
                    if (byArray != null) {
                        ((OutputStream)this.stream_out).write(byArray);
                    }
                    this.stream_out.flush();
                    byArray = null;
                }
                catch (IOException iOException) {
                    MQeTrace.trace(this, (short)-30034, 0x200000L, iOException.getMessage());
                    this.tcpipDisconnect(true);
                    throw new MqttException(iOException);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    this.tcpipDisconnect(true);
                    throw new MqttException(exception2);
                }
            } else {
                throw new MqttNotConnectedException();
            }
        }
    }

    protected final synchronized boolean isConnectionLost() {
        return this.connectionLost;
    }

    protected final synchronized void setConnectionLost(boolean bl) {
        this.connectionLost = bl;
    }

    protected final void setRegisteredThrowable(Throwable throwable) {
        this.registeredException = throwable == null || throwable instanceof MqttException ? (MqttException)throwable : new MqttException(throwable);
        this.setConnectionState(false);
        this.tcpipDisconnect(true);
        this.setConnectionLost(true);
    }
}

