/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.user.infochannel;

import com.ibm.mobile.uib.common.CommonVisualPlugin;
import com.ibm.mobile.uib.common.MessageWidget;
import com.ibm.mobile.uib.plugins.AbstractVisualPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Source;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Subscriber;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBMessage;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.Composite;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.ListWidget;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import com.ibm.rtk.ValueListener;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public final class InformationChannels
extends CommonVisualPlugin
implements ValueListener,
Subscriber {
    protected String ICON_PREFERENCE = "Tab-icon";
    protected String LOGO_PREFERENCE = "Logo";
    private static Translator translator;
    protected Command addChannelCommand;
    protected Command deleteChannelCommand;
    protected Source brokerListChannel;
    protected String channelListTopic;
    protected Hashtable channelWidgetTable;

    public InformationChannels() {
        super("Channels");
    }

    public final void enable() {
        super.enable();
        try {
            this.connectionPool.subscribe(this.brokerListChannel, this, null);
            this.subscribeToDefaultChannelList();
        }
        catch (CommsException ce) {
            this.handleError(ce);
        }
    }

    protected final void handleError(CommsException ce) {
        this.log.severe("Channels can't connect to the server. " + ce.getMessage());
        ce.printStackTrace();
    }

    public final void initialise(Preferences prefs) {
        super.initialise(prefs);
        String username = this.getPreferenceMgr().getGeneralPreferences().getDefaultClientID();
        String subscriptionStoreBrokersListTopic = "UIB/channels/brokers/" + username;
        this.brokerListChannel = new Source(subscriptionStoreBrokersListTopic);
        this.channelListTopic = "UIB/channels/" + username;
        this.channelWidgetTable = new Hashtable();
    }

    protected final StandardForm initialiseDisplay() {
        StandardForm form = new StandardForm();
        translator = (Translator)PluginManager.getManager().getPlugin("Language");
        String logoName = (String)this.prefs.get(this.LOGO_PREFERENCE);
        if (logoName != null) {
            try {
                Image logo = Toolkit.createImage(logoName);
                form.setLogo(logo, 24);
            }
            catch (Exception exception) {
                Exception e2 = exception;
                exception.printStackTrace();
            }
        }
        String iconName = (String)this.prefs.get(this.ICON_PREFERENCE);
        this.setIcon(iconName, null);
        form.setBackground(this.getBackgroundImage(), this.getPreferenceMgr().getGeneralPreferences().getDefaultBGColour());
        Image icon = AbstractVisualPlugin.generateIcon(iconName, this.getName(), this.log);
        StringWidget title = this.createTitlebar(translator.getKey("informationchannels.title"));
        form.append(title);
        this.listWidget = new ListWidget(Style.getDefaultFont(), 1);
        this.listWidget.highlightbg = this.getPreferenceMgr().getGeneralPreferences().getDefaultHLColour();
        this.listWidget.setCriteria(1);
        Composite channelsListWidgetWithScroll = this.listWidget.attachScroll(false);
        FormData layout = new FormData();
        new FormData().top = new FormAttachment(title);
        layout.left = new FormAttachment(0, 0);
        layout.right = new FormAttachment(100, 0);
        layout.bottom = new FormAttachment(100, 0);
        channelsListWidgetWithScroll.setLayoutData(layout);
        form.append(channelsListWidgetWithScroll);
        this.addPluginCommands(form);
        this.listWidget.setListener(this);
        form.setListener(this);
        return form;
    }

    protected final void addPluginCommands(StandardForm form) {
        this.addChannelCommand = new Command(translator.getKey("informationchannels.add"), 8, 1);
        this.deleteChannelCommand = new Command(translator.getKey("informationchannels.delete"), 8, 2);
        form.addCommand(this.addChannelCommand);
        form.addCommand(this.deleteChannelCommand);
        form.setCommandListener(this);
    }

    public final void commandAction(Command aCommand, Displayable aDisplayable) {
        if (aCommand == this.addChannelCommand) {
            this.addChannel();
        } else if (aCommand == this.deleteChannelCommand) {
            this.deleteChannel();
        } else {
            super.commandAction(aCommand, aDisplayable);
        }
    }

    public final void messageArrived(Message message) {
        Source channel = message.getSource();
        if (channel.equals(this.brokerListChannel)) {
            this.handleSubscriptionStoreBrokerListMessage(message);
        } else if (channel.getTopic().startsWith(this.channelListTopic)) {
            this.handleChannelListMessage(message);
        } else {
            this.handleChannelMessage(message);
        }
    }

    private final void handleSubscriptionStoreBrokerListMessage(Message message) {
        String[] brokers = this.getParsedArray(message.getDataString(), null, null);
        if (brokers != null) {
            try {
                this.connectionPool.subscribe(brokers, message.getSource().getBroker(), this, null);
            }
            catch (CommsException commsException) {
                CommsException e2 = commsException;
                commsException.printStackTrace();
            }
        } else {
            this.log.warning("Received a message on the subscription store brokers channel (" + this.brokerListChannel + ") but it had no content");
        }
    }

    private final void subscribeToDefaultChannelList() {
        Source source = new Source(this.channelListTopic);
        try {
            this.connectionPool.subscribe(source, this, null);
        }
        catch (CommsException e2) {
            this.log.severe("Channels failed to subscribe to the default channels");
            e2.printStackTrace();
        }
    }

    protected final void handleChannelListMessage(Message message) {
        String[] topics = this.getParsedArray(message.getDataString(), "UIB/info/", null);
        int count = topics.length;
        Source messageChannel = message.getSource();
        if (topics != null) {
            String broker = messageChannel.getBroker();
            Source channel = null;
            int i2 = 0;
            while (i2 < count) {
                channel = new Source(topics[i2], broker);
                if (this.channelWidgetTable.get(channel.toString()) == null) {
                    this.addChannel(channel);
                }
                ++i2;
            }
            try {
                this.connectionPool.subscribe(topics, broker, this, null);
            }
            catch (CommsException commsException) {
                CommsException e2 = commsException;
                commsException.printStackTrace();
                this.log.severe("Channels could not subscribe to the list of channels");
            }
        } else {
            this.log.warning("Channels - empty channel list message");
        }
    }

    protected final MessageWidget addChannel(Source channel) {
        MessageWidget cw = new MessageWidget("<" + channel.getTopic() + ">");
        UIBMessage emptyMsg = new UIBMessage(null, channel);
        cw.setData(emptyMsg);
        this.channelWidgetTable.put(channel.toString(), cw);
        this.listWidget.append(cw);
        return cw;
    }

    private final void addChannel() {
        String topic = "[" + translator.getKey("informationchannels.newtopic") + "]";
        String broker = "[" + translator.getKey("informationchannels.defaultbroker") + "]";
        Source channel = new Source(topic, broker);
        this.addChannel(channel);
    }

    private final void deleteChannel() {
        int selected = this.listWidget.selectedindex;
        Source src = null;
        if (selected != -1) {
            try {
                MessageWidget cw = (MessageWidget)this.listWidget.selected;
                UIBMessage uibMsg = (UIBMessage)cw.getData();
                src = uibMsg.getSource();
                this.listWidget.insertRemove(null, selected);
                this.connectionPool.unsubscribe(src, this, null);
                this.channelWidgetTable.remove(src.toString());
                if (this.listWidget.v.size() > 0) {
                    this.listWidget.setHighlight(0);
                }
            }
            catch (CommsException e2) {
                this.log.severe("Channels failed to delete channel name " + src.getTopic());
                e2.printStackTrace();
            }
        }
    }

    protected final void handleChannelMessage(Message message) {
        Source source = message.getSource();
        this.autoDisplayedLastAlert = false;
        UIBMessage uibMsg = this.createUIBMessage(message);
        System.out.println("Received " + uibMsg.getPayload().getHeading());
        if (uibMsg != null) {
            Toolkit.pauseApp(true);
            Toolkit.setLocked(150L);
            this.lastMsg = uibMsg;
            MessageWidget cw = (MessageWidget)((Object)this.channelWidgetTable.get(source.toString()));
            if (cw == null) {
                cw = this.addChannel(source);
            }
            cw.setMessage(uibMsg);
            cw.repaintExt();
            this.listWidget.doLayout();
            Toolkit.pauseApp(false);
            Toolkit.setUnlocked();
            this.handleAlert(uibMsg);
        } else {
            this.log.warning("Channels - invalid message on " + source);
        }
    }

    public final void connected(String serverName) {
    }
}

