/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.prefs;

import com.ibm.mobile.uib.Common;
import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.core.prefs.PreferenceException;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import java.util.Hashtable;
import javax.microedition.midlet.MIDlet;

public final class PreferencesManager
extends AbstractPlugin {
    public static PreferencesManager singleton = null;
    private Hashtable preferencePages = new Hashtable();
    private Hashtable preferencesTable = new Hashtable();
    private GeneralPreference gp;

    public static PreferencesManager getInstance() {
        if (singleton == null) {
            singleton = new PreferencesManager();
            singleton.initialise(null);
            singleton.enable();
        }
        return singleton;
    }

    private PreferencesManager() {
        super("PrefsMgr");
    }

    public final void enable() {
        super.enable();
        this.loadGeneralPreferences();
    }

    private final void loadGeneralPreferences() {
        this.gp = new GeneralPreference();
    }

    public final Preferences retrievePreferences(MIDlet midlet, String pluginName, int index) {
        Preferences prefs = null;
        prefs = new Preferences(pluginName);
        try {
            String pluginProps;
            prefs.load();
            if (prefs.isEmpty() && (pluginProps = midlet.getAppProperty("plugins-" + index + "-props")) != null) {
                prefs.store(pluginProps);
            }
            this.preferencesTable.put(pluginName, prefs);
        }
        catch (PreferenceException preferenceException) {
            PreferenceException e2 = preferenceException;
            preferenceException.printStackTrace();
        }
        return prefs;
    }

    public final GeneralPreference getGeneralPreferences() {
        return this.gp;
    }

    public final class GeneralPreference {
        private String HL_COLOUR = "HL-Colour";
        private String BG_COLOUR = "BG-Colour";
        private String FOCUS_COLOUR = "Focus-Colour";
        private String BG_IMAGE = "BG-Image";
        private String TEXT_COLOUR = "Text-Colour";
        public String USERNAME = "Username";
        public String BROKER = "Broker";
        private String LOGO = "Splash-Image";
        private String PROFILE = "Profile";
        private String LOG = "log";
        private String FULLSCREEN = "FullscreenMode";
        private String FONT = "Font";
        private String TTS = "tts";
        private String ENCODING = "encoding";
        private Preferences prefs = new Preferences("General-Prefs");
        private boolean ttsEnabled;

        private GeneralPreference() {
            try {
                String tts;
                this.prefs.load();
                if (this.prefs.isEmpty()) {
                    this.prefs.store(UniversalCommunicator.getInbox().getAppProperty(Common.GENERAL_PREFS_KEY));
                }
                this.ttsEnabled = (tts = (String)this.prefs.get(this.TTS)) != null && tts.equalsIgnoreCase("y");
                PreferencesManager.this.preferencesTable.put("General-Prefs", this.prefs);
            }
            catch (PreferenceException preferenceException) {
                PreferenceException e2 = preferenceException;
                preferenceException.printStackTrace();
            }
        }

        public final String getDefaultBroker() {
            return (String)this.prefs.get(this.BROKER);
        }

        public final void setDefaultBroker(String broker) {
            this.prefs.put(this.BROKER, broker);
        }

        public final String getSplashScreenLogo() {
            String c2 = null;
            try {
                c2 = (String)this.prefs.get(this.LOGO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return c2;
        }

        public final String getDefaultClientID() {
            String clientID = (String)this.prefs.get(this.USERNAME);
            if (clientID == null) {
                clientID = "UIB-" + System.currentTimeMillis();
                this.prefs.put(this.USERNAME, clientID);
                try {
                    this.prefs.store();
                }
                catch (PreferenceException e2) {
                    PreferencesManager.this.log.severe("User name could not be saved");
                }
            }
            return clientID;
        }

        public final void setDefaultClientID(String usr) {
            this.prefs.put(this.USERNAME, usr);
        }

        public final int getDefaultTextColour() {
            String c2 = (String)this.prefs.get(this.TEXT_COLOUR);
            if (c2 == null) {
                c2 = "000000";
            }
            return Integer.parseInt(c2, 16);
        }

        public final String getFontSize() {
            String fs = (String)this.prefs.get(this.FONT);
            if (fs == null) {
                fs = "s";
            }
            return fs;
        }

        public final int getDefaultBGColour() {
            String c2 = (String)this.prefs.get(this.BG_COLOUR);
            if (c2 == null) {
                c2 = "ffffff";
            }
            return Integer.parseInt(c2, 16);
        }

        public final int getDefaultHLColour() {
            String c2 = (String)this.prefs.get(this.HL_COLOUR);
            if (c2 == null) {
                c2 = "aaaaaa";
            }
            return Integer.parseInt(c2, 16);
        }

        public final int getFocusColour() {
            String c2 = (String)this.prefs.get(this.FOCUS_COLOUR);
            if (c2 == null) {
                c2 = "000000";
            }
            return Integer.parseInt(c2, 16);
        }

        public final String getDefaultBGImageName() {
            return (String)this.prefs.get(this.BG_IMAGE);
        }

        public final boolean isTTSEnabled() {
            return this.ttsEnabled;
        }

        public final boolean useFullscreen() {
            String setting = (String)this.prefs.get(this.FULLSCREEN);
            return setting != null && setting.equals(Preferences.TRUE);
        }

        public final void setFullScreen(boolean fs) {
            if (fs) {
                this.prefs.put(this.FULLSCREEN, Preferences.TRUE);
            } else {
                this.prefs.put(this.FULLSCREEN, Preferences.FALSE);
            }
        }

        public final void store() throws PreferenceException {
            this.prefs.store();
        }
    }
}

