/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.prefs;

import com.ibm.mobile.uib.plugins.core.prefs.PreferenceException;
import com.ibm.mobile.uib.util.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class Preferences
extends Hashtable {
    public static String TRUE = "Y";
    public static String FALSE = "N";
    private String pluginName;

    public Preferences(String pluginName) {
        this.pluginName = pluginName;
    }

    public final void store() throws PreferenceException {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.pluginName, (boolean)true);
            byte[] inBytes = this.getBytes();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(inBytes, 0, inBytes.length);
            } else {
                RecordEnumeration re = rs.enumerateRecords(null, null, true);
                while (re.hasNextElement()) {
                    int rid = re.nextRecordId();
                    rs.setRecord(rid, inBytes, 0, inBytes.length);
                }
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            RecordStoreException e2 = recordStoreException;
            recordStoreException.printStackTrace();
            throw new PreferenceException("Preferences could not be stored for " + this.pluginName);
        }
    }

    protected final byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Enumeration keys = this.keys();
        byte[] array = null;
        try {
            while (keys.hasMoreElements()) {
                String prefKey = (String)keys.nextElement();
                dos.writeUTF(prefKey);
                dos.writeUTF((String)this.get(prefKey));
            }
            array = baos.toByteArray();
            dos.close();
            baos.close();
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
        }
        return array;
    }

    public final void store(String propsList) throws PreferenceException {
        if (propsList != null) {
            Vector propsString = Utility.getParsedList(propsList);
            Vector pair = null;
            int count = propsString.size();
            boolean prefixIndex = false;
            int i2 = 0;
            while (i2 < count) {
                pair = Utility.tokenize((String)propsString.elementAt(i2), "=");
                if (pair.size() == 2) {
                    this.put(pair.elementAt(0), pair.elementAt(1));
                }
                ++i2;
            }
            this.store();
        }
    }

    public final void load() throws PreferenceException {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.pluginName, (boolean)false);
            int rc = rs.getNumRecords();
            if (rc > 0) {
                RecordEnumeration re = rs.enumerateRecords(null, null, true);
                while (re.hasNextElement()) {
                    int rid = re.nextRecordId();
                    byte[] data = rs.getRecord(rid);
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    DataInputStream dis = new DataInputStream(bais);
                    while (dis.available() > 0) {
                        String key = dis.readUTF();
                        String value = dis.readUTF();
                        this.put(key, value);
                    }
                    dis.close();
                    bais.close();
                }
            }
            rs.closeRecordStore();
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
            throw new PreferenceException("Preferences could not be loaded for " + this.pluginName);
        }
        catch (RecordStoreNotFoundException e1) {
            return;
        }
        catch (RecordStoreException recordStoreException) {
            RecordStoreException rse = recordStoreException;
            recordStoreException.printStackTrace();
            throw new PreferenceException("Preferences could not be loaded for " + this.pluginName);
        }
    }

    public final String getString(Object key) {
        return (String)this.get(key);
    }
}

