/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.logging;

import com.ibm.mobile.uib.plugins.Plugin;
import com.ibm.mobile.uib.plugins.core.logging.LogListener;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class LogManager
implements Plugin {
    private boolean enabled;
    private Hashtable listeners;

    public final void enable() {
        this.enabled = true;
    }

    public final void initialise(Preferences prefs) {
        this.listeners = new Hashtable();
    }

    public final String getName() {
        return "LogMgr";
    }

    public final void addLogListener(LogListener listener, int level) {
        this.listeners.put(listener, new Integer(level));
    }

    public final void log(int logLevel, String message) {
        if (this.enabled) {
            Date date = new Date();
            if (this.listeners.size() > 0) {
                Enumeration listenersEnum = this.listeners.keys();
                while (listenersEnum.hasMoreElements()) {
                    LogListener currentListener = (LogListener)listenersEnum.nextElement();
                    Integer currentListenerLogLevel = (Integer)this.listeners.get(currentListener);
                    if (currentListenerLogLevel > logLevel) continue;
                    currentListener.log(logLevel, message, date);
                }
            } else {
                LogManager.displayLogMessageOnCommandLine(logLevel, message, date);
            }
        }
    }

    public final void severe(String message) {
        this.log(1000, message);
    }

    public final void warning(String message) {
        this.log(900, message);
    }

    public final void info(String message) {
        this.log(800, message);
    }

    public final void fine(String message) {
        this.log(500, message);
    }

    public static void displayLogMessageOnCommandLine(int level, String message, Date date) {
        if (level >= 1000) {
            System.err.println("SEV: " + message);
        } else if (level >= 900) {
            System.err.println("W: " + message);
        } else if (level >= 800) {
            System.out.println("I: " + message);
        } else if (level >= 500) {
            System.out.println("F: " + message);
        } else if (level >= 400) {
            System.out.println("F: " + message);
        } else {
            System.out.println(message);
        }
    }
}

