/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins.core.comms.messaging;

import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayload;
import com.ibm.mobile.uib.util.Utility;
import java.util.Vector;

public final class UIBOldPayloadImpl
implements UIBPayload {
    protected String dataString;
    protected Action[] actions;

    public UIBOldPayloadImpl(String payloadString) {
        this.dataString = payloadString;
    }

    public final int getType() throws NumberFormatException {
        try {
            return Integer.parseInt(Utility.parseValueBetweenTags("<type>", "</type>", this.dataString));
        }
        catch (NumberFormatException nfe) {
            return 80;
        }
    }

    public final String getSubject() {
        return Utility.parseValueBetweenTags("<subj>", "</subj>", this.dataString);
    }

    public final String getBody() {
        return Utility.parseValueBetweenTags("<body>", "</body>", this.dataString);
    }

    public final String toString() {
        if (this.dataString != null) {
            return this.dataString;
        }
        return "Invalid message";
    }

    public final String getHeading() {
        String heading = this.getSubject();
        if (heading.equals("")) {
            String body = this.getBody();
            heading = body.length() < 20 ? body : body.substring(0, 20);
        }
        return " " + heading;
    }

    public final boolean isAlert() {
        return this.getType() == 0;
    }

    public final Action[] getActions() {
        if (this.actions == null) {
            String label = "";
            String key = "";
            String topic = null;
            String exit = "";
            boolean closeWindow = true;
            int index = 1;
            Action action = null;
            Vector<Action> actionList = new Vector<Action>();
            String actionXml = Utility.parseValueBetweenTags("<actions>", "</actions>", this.dataString);
            if (actionXml != null && !actionXml.equals("")) {
                while (label != null) {
                    label = Utility.parseValueBetweenTags("<l>", "</l>", index, actionXml);
                    if (label != null) {
                        topic = Utility.parseValueBetweenTags("<t>", "</t>", index, actionXml);
                        key = Utility.getAttributeValue("key", "<ar>", index, actionXml);
                        exit = Utility.getAttributeValue("exit", "<ar>", index, actionXml);
                        closeWindow = !exit.equals("0");
                        String msg = Utility.parseValueBetweenTags("<m>", "</m>", index, actionXml);
                        action = new Action(label, topic, msg, key, closeWindow);
                        actionList.addElement(action);
                    }
                    ++index;
                }
            }
            this.actions = new Action[actionList.size()];
            actionList.copyInto(this.actions);
        }
        return this.actions;
    }

    public final String getURL() {
        return Utility.parseValueBetweenTags("<url>", "</url>", this.dataString);
    }

    public final String getImageURL() {
        return Utility.parseValueBetweenTags("<img>", "</img>", this.dataString);
    }

    public final String getAudioURL() {
        return Utility.parseValueBetweenTags("<au>", "</au>", this.dataString);
    }
}

