/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.plugins;

import com.ibm.mobile.uib.plugins.CorePluginLoadFailedException;
import com.ibm.mobile.uib.plugins.Plugin;
import com.ibm.mobile.uib.plugins.PluginListener;
import com.ibm.mobile.uib.plugins.PluginRegistry;
import com.ibm.mobile.uib.plugins.PluginRegistryEntry;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

public final class PluginManager {
    private static final String[] CORE_PLUGINS;
    private static PluginManager singleton;
    private PluginRegistry registry = new PluginRegistry();
    private Hashtable loadingPlugins;
    private Vector pluginListeners = new Vector();
    private LogManager log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        String[] stringArray = new String[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.mobile.uib.plugins.core.logging.LogManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.ibm.mobile.uib.plugins.core.comms.messaging.mqtt.MqttConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[2] = clazz3.getName();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("com.ibm.mobile.uib.plugins.core.audioplayer.PlayAudioThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz4.getName();
        CORE_PLUGINS = stringArray;
    }

    private PluginManager() {
    }

    public static synchronized PluginManager getManager() {
        if (singleton == null) {
            singleton = new PluginManager();
        }
        return singleton;
    }

    public final void enableAllPlugins() {
        Vector allPlugins = this.registry.getPlugins();
        int count = allPlugins.size();
        int i2 = 0;
        while (i2 < count) {
            PluginRegistryEntry pre = (PluginRegistryEntry)allPlugins.elementAt(i2);
            Plugin p2 = pre.getPlugin();
            p2.enable();
            ++i2;
        }
        this.allPluginsLoaded();
    }

    private final void loadPlugins(String[] plugins, MIDlet midlet) throws CorePluginLoadFailedException {
        if (plugins != null) {
            int i2 = 0;
            while (i2 < plugins.length) {
                String pluginClass = plugins[i2];
                try {
                    if (pluginClass != null) {
                        this.loadPlugin(pluginClass, midlet, i2);
                    } else {
                        this.handlePluginFailure(pluginClass, new Exception("Plugin index " + i2 + " could not be loaded."));
                    }
                }
                catch (Exception e2) {
                    this.handlePluginFailure(pluginClass, e2);
                }
                ++i2;
            }
        }
    }

    private final void handlePluginFailure(String pluginClass, Exception e2) throws CorePluginLoadFailedException {
        if (e2 instanceof CorePluginLoadFailedException) {
            throw (CorePluginLoadFailedException)e2;
        }
        boolean corePlugin = pluginClass != null && PluginManager.isCorePlugin(pluginClass);
        if (corePlugin) {
            throw new CorePluginLoadFailedException(e2, pluginClass);
        }
        if (this.logManagerLoaded()) {
            this.log.warning("Failed to initialise or enable plugin: " + pluginClass + " please make sure that you plugin class provides a no argument constructor method.");
            e2.printStackTrace();
        }
    }

    public final void loadCorePlugins(MIDlet midlet) throws CorePluginLoadFailedException {
        this.loadingPlugins = new Hashtable();
        this.loadPlugins(CORE_PLUGINS, midlet);
    }

    public final void loadUserPlugins(MIDlet midlet) {
        block2: {
            String[] userPlugins = this.getUserPlugins(midlet);
            try {
                this.loadPlugins(userPlugins, midlet);
            }
            catch (CorePluginLoadFailedException e2) {
                if (!this.logManagerLoaded()) break block2;
                this.log.warning("Failed to load a core plugin but all core plugins should have been loaded already");
            }
        }
    }

    private final String[] getUserPlugins(MIDlet midlet) {
        String[] plugins;
        block3: {
            plugins = null;
            String pluginsString = midlet.getAppProperty("plugins");
            try {
                int numberOfPlugins = Integer.parseInt(pluginsString);
                plugins = new String[numberOfPlugins];
                int i2 = 0;
                while (i2 < numberOfPlugins) {
                    String pluginClassProperty = "plugins-" + i2 + "-class";
                    plugins[i2] = midlet.getAppProperty(pluginClassProperty);
                    ++i2;
                }
            }
            catch (NumberFormatException e2) {
                if (!this.logManagerLoaded()) break block3;
                this.log.warning("The number of plugins specified in the JAD (" + pluginsString + ") is invalid");
            }
        }
        return plugins;
    }

    private final void loadPlugin(String className, MIDlet midlet, int index) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ClassCastException, CorePluginLoadFailedException {
        Plugin loadedPlugin = this.registry.getPlugin(className);
        if (loadedPlugin == null) {
            try {
                String string = className;
                String alreadyLoadingPlugin = this.loadingPlugins.put(string, string);
                if (alreadyLoadingPlugin == null) {
                    Class<?> pluginClass = Class.forName(className);
                    Plugin plugin = (Plugin)pluginClass.newInstance();
                    this.initialisePlugin(plugin, midlet, index);
                    this.registry.addPlugin(plugin);
                }
            }
            finally {
                if (className != null) {
                    this.loadingPlugins.remove(className);
                }
            }
        }
    }

    public final void loadPlugin(String className, MIDlet midlet) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, CorePluginLoadFailedException {
        this.loadPlugin(className, midlet, this.registry.getPlugins().size());
    }

    private final void initialisePlugin(Plugin plugin, MIDlet midlet, int index) {
        Preferences prefs = PreferencesManager.getInstance().retrievePreferences(midlet, plugin.getName(), index);
        plugin.initialise(prefs);
        if (this.logManagerLoaded()) {
            this.log.fine("Plugin initialised: " + plugin.getName() + " (" + plugin.getClass().getName() + ")");
        }
    }

    public final Plugin getPlugin(String pluginName) {
        return this.registry.getPlugin(pluginName);
    }

    public final Plugin getPlugin(Class pluginClass) {
        Plugin plugin = null;
        Vector plugins = this.registry.getPlugins(pluginClass);
        if (plugins.size() > 0) {
            plugin = (Plugin)plugins.firstElement();
        }
        return plugin;
    }

    public final Vector getAllPlugins() {
        return this.registry.getPlugins(0);
    }

    public final Vector getVisualPlugins() {
        return this.registry.getPlugins(3);
    }

    public static boolean isCorePlugin(String pluginClass) {
        boolean isCorePlugin = false;
        int i2 = 0;
        while (i2 < CORE_PLUGINS.length && !isCorePlugin) {
            String currentCorePluginClass = CORE_PLUGINS[i2];
            if (pluginClass.equals(currentCorePluginClass)) {
                isCorePlugin = true;
            }
            ++i2;
        }
        return isCorePlugin;
    }

    private final boolean logManagerLoaded() {
        boolean logManagerLoaded = false;
        if (this.log == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.mobile.uib.plugins.core.logging.LogManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = (LogManager)this.getPlugin(clazz);
            if (this.log != null) {
                logManagerLoaded = true;
            }
        } else {
            logManagerLoaded = true;
        }
        return logManagerLoaded;
    }

    private final void allPluginsLoaded() {
        if (this.logManagerLoaded()) {
            this.log.info("All plugins loaded");
        }
        Enumeration pluginListenersEnum = this.pluginListeners.elements();
        while (pluginListenersEnum.hasMoreElements()) {
            PluginListener listener = (PluginListener)pluginListenersEnum.nextElement();
            listener.allPluginsLoaded();
        }
    }
}

