/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.common;

import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBMessage;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayload;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public final class MessageWidget
extends StringWidget {
    private static Image iconsImage = null;

    public MessageWidget(String heading) {
        super(heading, true);
        PreferencesManager prefs = PreferencesManager.getInstance();
        this.setStyle(prefs.getGeneralPreferences().getDefaultTextColour(), Style.getDefaultFont(), false, 2);
        this.setFrame(-2);
    }

    public final void setMessage(UIBMessage uibMsg) {
        Vector<Object> items = new Vector<Object>();
        this.setData(uibMsg);
        UIBPayload payload = uibMsg.getPayload();
        try {
            int type = payload.getType();
            Sprite sprite = this.getSprite(type);
            if (sprite != null) {
                items.addElement(sprite);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        items.addElement(payload.getHeading());
        this.setItems(items);
    }

    private final Sprite getSprite(int number) {
        Sprite sprite = new Sprite(MessageWidget.getIconsImage(), 15, 15);
        sprite.setFrame(number);
        return sprite;
    }

    private static Image getIconsImage() {
        if (iconsImage == null) {
            try {
                iconsImage = Toolkit.createImage("/images/all-in-one.png");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return iconsImage;
    }
}

