/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.common;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.common.ActionCommand;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.alerter.Alerter;
import com.ibm.mobile.uib.plugins.core.audioplayer.Audio;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Action;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBMessage;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayload;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.logging.LogManager;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringAttr;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public final class MessageDetailForm
extends StandardForm
implements CommandListener {
    protected UIBMessage msg;
    protected StringWidget msgWidget;
    protected StringWidget imgWidget;
    protected FormData msgFormData;
    protected FormData imgFormData;
    protected StandardForm parent;
    protected Command closeCmd;
    protected LogManager log;
    protected Alerter alerter;
    protected Audio audio;
    protected static Translator translator;
    protected Image bgImage = null;
    private String BG_IMAGE_NAME = "/images/tback.png";
    protected Vector actionCommands = new Vector();
    protected Command urlCmd;
    protected Command audioCmd;
    private String currentTopicName;

    public MessageDetailForm() {
        this.log = (LogManager)PluginManager.getManager().getPlugin("LogMgr");
        this.alerter = (Alerter)((Object)PluginManager.getManager().getPlugin("Alerter"));
        this.audio = (Audio)((Object)PluginManager.getManager().getPlugin("Audio"));
        translator = (Translator)PluginManager.getManager().getPlugin("Language");
        this.msgWidget = new StringWidget("", false);
        this.imgWidget = new StringWidget("", false);
        this.msgFormData = new FormData();
        this.msgFormData.top = new FormAttachment(this.imgWidget, 2);
        this.msgFormData.left = new FormAttachment(0, 2);
        this.msgFormData.right = new FormAttachment(100, -2);
        this.msgWidget.setLayoutData(this.msgFormData);
        this.imgFormData = new FormData();
        this.imgFormData.top = new FormAttachment(0, 2);
        this.imgFormData.left = new FormAttachment(0, 2);
        this.imgFormData.right = new FormAttachment(100, -2);
        this.imgWidget.setLayoutData(this.imgFormData);
        MessageDetailForm messageDetailForm = this;
        messageDetailForm.append(messageDetailForm.imgWidget);
        MessageDetailForm messageDetailForm2 = this;
        messageDetailForm2.append(messageDetailForm2.msgWidget);
        MessageDetailForm messageDetailForm3 = this;
        messageDetailForm3.setCommandListener(messageDetailForm3);
        this.closeCmd = new Command(translator.getKey("messagedetailform.close"), 2, 1);
        this.urlCmd = new Command(translator.getKey("messagedetailform.details"), 8, 1);
        this.audioCmd = new Command(translator.getKey("messagedetailform.replay"), 8, 1);
    }

    public final void setMessage(StandardForm parentForm, UIBMessage aMsg) {
        String body;
        String img;
        this.msg = aMsg;
        this.parent = parentForm;
        UIBPayload payload = this.msg.getPayload();
        String subj = payload.getSubject();
        MessageDetailForm messageDetailForm = this;
        messageDetailForm.setCurrentTopicName(messageDetailForm.msg.getSource().getTopic());
        if (subj != null) {
            this.setStatus(subj, Style.getDefaultFont(), 32, 1, null);
        }
        String audioLink = payload.getAudioURL();
        if (this.audio != null && audioLink.length() != 0) {
            this.audio.playAudio(audioLink);
        }
        if ((img = payload.getImageURL()) != null) {
            try {
                this.bgImage = Toolkit.createImage(img);
                int gap = this.getWidth() - this.bgImage.getWidth();
                int left = gap > 0 ? gap / 2 : 0;
                this.imgFormData.left = new FormAttachment(0, left);
                this.imgWidget.setItems(this.bgImage);
                this.imgWidget.setLayoutData(this.imgFormData);
                MessageDetailForm messageDetailForm2 = this;
                messageDetailForm2.append(messageDetailForm2.imgWidget);
                this.msgFormData.top = new FormAttachment(this.imgWidget, 2);
            }
            catch (IOException e2) {
                img = null;
            }
        }
        if (img == null) {
            MessageDetailForm messageDetailForm3 = this;
            messageDetailForm3.remove(messageDetailForm3.imgWidget);
            this.imgWidget.setItems("");
            this.bgImage = null;
            this.msgFormData.top = new FormAttachment(0, 2);
        }
        if ((body = payload.getBody()) != null) {
            int colour = this.getPreferenceMgr().getGeneralPreferences().getDefaultTextColour();
            StringAttr msgStrAttr = new StringAttr(body, Style.getDefaultFont(), colour);
            this.msgWidget.setItems(msgStrAttr);
        } else {
            this.msgWidget.setItems("");
        }
        this.handleActions(payload);
        MessageDetailForm messageDetailForm4 = this;
        messageDetailForm4.addCommand(messageDetailForm4.closeCmd);
        this.doLayout();
        this.setViewLocation(0, 0);
    }

    protected final void handleActions(UIBPayload payload) {
        int size = this.actionCommands.size();
        int i2 = 0;
        while (i2 < size) {
            MessageDetailForm messageDetailForm = this;
            messageDetailForm.removeCommand((ActionCommand)((Object)messageDetailForm.actionCommands.elementAt(i2)));
            ++i2;
        }
        this.actionCommands.removeAllElements();
        Action[] actions = payload.getActions();
        size = actions.length;
        if (size != 0) {
            int i3 = 0;
            while (i3 < size) {
                ActionCommand ac2 = new ActionCommand(actions[i3]);
                this.addCommand(ac2);
                this.actionCommands.addElement(ac2);
                ++i3;
            }
        }
        if (!payload.getURL().equals("")) {
            MessageDetailForm messageDetailForm = this;
            messageDetailForm.addCommand(messageDetailForm.urlCmd);
        } else {
            MessageDetailForm messageDetailForm = this;
            messageDetailForm.removeCommand(messageDetailForm.urlCmd);
        }
        if (!payload.getAudioURL().equals("")) {
            MessageDetailForm messageDetailForm = this;
            messageDetailForm.addCommand(messageDetailForm.audioCmd);
        } else {
            MessageDetailForm messageDetailForm = this;
            messageDetailForm.removeCommand(messageDetailForm.audioCmd);
        }
    }

    protected final PreferencesManager getPreferenceMgr() {
        return PreferencesManager.getInstance();
    }

    public final void keyPressed(int keyCode) {
        System.out.println("KeyCode: " + (char)keyCode);
        String key = new Character((char)keyCode).toString();
        int i2 = 0;
        while (i2 < this.actionCommands.size()) {
            if (((ActionCommand)((Object)this.actionCommands.elementAt(i2))).getKey().equals(key)) {
                ((ActionCommand)((Object)this.actionCommands.elementAt(i2))).respond();
                if (!((ActionCommand)((Object)this.actionCommands.elementAt(i2))).getCloseWindow()) break;
                this.close();
                break;
            }
            ++i2;
        }
    }

    public final void commandAction(Command c2, Displayable aDisplayable) {
        if (c2 == this.closeCmd) {
            this.close();
        } else if (c2 == this.audioCmd) {
            UIBPayload payload = this.msg.getPayload();
            this.audio.playAudio(payload.getAudioURL());
        } else if (c2 == this.urlCmd) {
            UIBPayload payload = this.msg.getPayload();
            try {
                UniversalCommunicator.getInbox().platformRequest(payload.getURL());
            }
            catch (ConnectionNotFoundException e2) {
                this.log.warning("URL could not be launched for message '" + payload.getSubject() + "'");
            }
        } else if (c2 instanceof ActionCommand) {
            ((ActionCommand)c2).respond();
            if (((ActionCommand)c2).getCloseWindow()) {
                this.close();
            }
        }
    }

    public final void close() {
        if (this.alerter != null) {
            this.alerter.stopVibrating();
            this.alerter.stopFlashing();
        }
        if (this.audio != null) {
            this.audio.stopAudio();
        }
        int size = this.actionCommands.size();
        ActionCommand actCmd = null;
        int i2 = 0;
        while (i2 < size) {
            actCmd = (ActionCommand)((Object)this.actionCommands.elementAt(i2));
            this.removeCommand(actCmd);
            this.parent.removeCommand(actCmd);
            ++i2;
        }
        this.actionCommands.removeAllElements();
        MessageDetailForm messageDetailForm = this;
        messageDetailForm.removeCommand(messageDetailForm.closeCmd);
        this.parent.removeCommand(this.closeCmd);
        this.setCurrentTopicName(null);
        this.parent.dismissDialog();
    }

    public final void hasFocus() {
        if (this.alerter != null && this.msg != null) {
            this.alerter.tts(this.msg.getPayload().getBody());
        }
    }

    public final void setCurrentTopicName(String string) {
        this.currentTopicName = string;
    }
}

