/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib.common;

import com.ibm.mobile.uib.UniversalCommunicator;
import com.ibm.mobile.uib.common.MessageDetailForm;
import com.ibm.mobile.uib.common.MessageWidget;
import com.ibm.mobile.uib.plugins.AbstractVisualPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.core.comms.messaging.CommsException;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionListener;
import com.ibm.mobile.uib.plugins.core.comms.messaging.ConnectionPool;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Message;
import com.ibm.mobile.uib.plugins.core.comms.messaging.Subscriber;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBMessage;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBOldPayloadImpl;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayload;
import com.ibm.mobile.uib.plugins.core.comms.messaging.UIBPayloadImpl;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.mobile.uib.util.Style;
import com.ibm.mobile.uib.util.Utility;
import com.ibm.rtk.ListWidget;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.ValueListener;
import java.util.Vector;

public abstract class CommonVisualPlugin
extends AbstractVisualPlugin
implements Subscriber,
ValueListener,
ConnectionListener {
    protected MessageDetailForm msgDetailForm;
    protected ListWidget listWidget;
    protected ConnectionPool connectionPool;
    protected UIBMessage lastMsg;
    protected boolean autoDisplayedLastAlert = true;
    protected MessageWidget currentMsgWidget = null;

    public CommonVisualPlugin(String name, String imageLoc, String hlImageLoc) {
        super(name, imageLoc, hlImageLoc);
    }

    public CommonVisualPlugin(String name) {
        super(name);
    }

    public void initialise(Preferences prefs) {
        if (this.logoName == null) {
            this.logoName = "/images/ets.png";
        }
        super.initialise(prefs);
    }

    /*
     * WARNING - void declaration
     */
    protected final UIBMessage createUIBMessage(Message message) {
        void var2_3;
        UIBPayload uibPayload;
        String dataString = message.getDataString();
        if (dataString.startsWith("<m>")) {
            uibPayload = new UIBPayloadImpl(message.getDataString());
        } else if (dataString.startsWith("<msg>")) {
            uibPayload = new UIBOldPayloadImpl(message.getDataString());
        } else {
            return null;
        }
        UIBMessage uibMsg = new UIBMessage((UIBPayload)var2_3, message.getSource());
        return uibMsg;
    }

    public final boolean valueNotify(int index, Object widget) {
        try {
            if (widget instanceof StringWidget) {
                if (index == -2) {
                    UIBMessage msg = (UIBMessage)((StringWidget)((Object)widget)).getData();
                    if (this.alerter != null && msg.getPayload() != null) {
                        this.alerter.tts(msg.getPayload().getHeading());
                    }
                } else if (index == -1 || index == -5) {
                    int pos = this.listWidget.v.indexOf(widget);
                    if (pos != -1) {
                        this.listWidget.setHighlight(pos);
                    }
                    UIBMessage msg = (UIBMessage)((StringWidget)((Object)widget)).getData();
                    this.displayMsg(msg);
                }
            }
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            this.log.severe(String.valueOf(this.getName()) + "list navigation error");
        }
        return true;
    }

    protected final void displayMsg(UIBMessage msg) {
        if (msg.getPayload() != null) {
            this.msgDetailForm = new MessageDetailForm();
            this.msgDetailForm.setMessage(this.mainDisplay, msg);
            Style.showAsDialog(this.mainDisplay, this.msgDetailForm, 1, 0);
            this.msgDetailForm.hasFocus();
        }
    }

    protected final String[] getParsedArray(String commaString, String prefix, String suffix) {
        Vector list = Utility.getParsedList(commaString);
        int size = list.size();
        String[] listArray = new String[size];
        int i2 = 0;
        while (i2 < size) {
            if (prefix != null) {
                listArray[i2] = String.valueOf(prefix) + (String)list.elementAt(i2);
            }
            if (suffix != null) {
                listArray[i2] = String.valueOf(listArray[i2]) + suffix;
            }
            ++i2;
        }
        return listArray;
    }

    public final void connectionLost(String serverName) {
    }

    public abstract void messageArrived(Message var1);

    public abstract void connected(String var1);

    protected abstract StandardForm initialiseDisplay();

    public void enable() {
        super.enable();
        try {
            this.enableBasicPlugins();
        }
        catch (CommsException e2) {
            this.log.severe(String.valueOf(this.getName()) + " can't receive connection status information");
        }
    }

    protected final void enableBasicPlugins() throws CommsException {
        this.connectionPool = (ConnectionPool)PluginManager.getManager().getPlugin("Connection Pool");
        CommonVisualPlugin commonVisualPlugin = this;
        this.connectionPool.addListener(commonVisualPlugin, commonVisualPlugin.getPreferenceMgr().getGeneralPreferences().getDefaultBroker());
    }

    public void hasFocus() {
        super.hasFocus();
        if (this.alerter != null) {
            this.alerter.tts(this.name);
        }
        this.mainDisplay.setFocus(this.listWidget);
        if (this.lastMsg != null && this.lastMsg.getPayload().isAlert() && !this.autoDisplayedLastAlert) {
            this.autoDisplayedLastAlert = true;
            CommonVisualPlugin commonVisualPlugin = this;
            commonVisualPlugin.displayMsg(commonVisualPlugin.lastMsg);
        }
    }

    public final void lostFocus() {
        this.mainDisplay.dismissDialog();
        super.lostFocus();
    }

    protected final void doAlerting() {
        this.alerter.alert();
    }

    protected final void handleAlert(UIBMessage uibMsg) {
        boolean isAlert = this.lastMsg.getPayload().isAlert();
        if (isAlert) {
            UniversalCommunicator.getInbox().requestDisplay(this.mainDisplay);
            this.doAlerting();
        }
        if (this.focus && isAlert) {
            this.autoDisplayedLastAlert = true;
            CommonVisualPlugin commonVisualPlugin = this;
            commonVisualPlugin.displayMsg(commonVisualPlugin.lastMsg);
        }
    }
}

